<?php

namespace DEVELUXSCT\Taxonomies;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
class Tags
{
    public static function get_tags_list($bulk_item_id):array {

        $all_tags = get_categories([
            'taxonomy' => 'product_tag',
            'orderby' => 'name',
            'show_count' => 1,
            'pad_counts' => 0,
            'hierarchical' => 1,
            'hide_empty' => 0
        ] );

        $label_tag_ids = get_post_meta($bulk_item_id, 'develux_bulk_item_tag_ids', true);

        if(!empty($label_tag_ids)){
            $label_tag_ids_arr = explode(',', $label_tag_ids);
            $i = 0;
            foreach($all_tags as $tag_item){
                if(array_search($tag_item->cat_ID, $label_tag_ids_arr) !== false){
                    $all_tags[$i]->chacked_status = 'true';
                }else{
                    $all_tags[$i]->chacked_status = 'false';
                }
                $i++;
            }
        }

        return $all_tags;
    }

}