<?php

namespace DEVELUXSCT\Taxonomies;
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Categories
{
    public static function get_categories_list($bulk_item_id): array
    {
        $all_categories = get_categories([
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'show_count' => 1,
            'pad_counts' => 0,
            'hierarchical' => 1,
            'hide_empty' => 0
        ]);
        $label_cat_ids = get_post_meta($bulk_item_id, 'develux_bulk_item_cat_ids', true);
        $label_cat_ids_arr = explode(',', $label_cat_ids);
        //Attaching image for object
        $i = 0;
        foreach ($all_categories as $category) {
            $thumbnail_id = get_term_meta($category->cat_ID, 'thumbnail_id', true);
            $all_categories[$i]->cat_img = $thumbnail_id ? wp_get_attachment_url($thumbnail_id) :
                plugin_dir_url(__FILE__) . '../../assets/images/helpers/woocommerce-placeholder.png';

            if (!empty($label_cat_ids)) {
                if (array_search($category->cat_ID, $label_cat_ids_arr) !== false) {
                    $all_categories[$i]->chacked_status = 'true';
                } else {
                    $all_categories[$i]->chacked_status = 'false';
                }
            }
            $i++;
        }


        return $all_categories;


    }
}