<?php

namespace DEVELUXSCT;
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

use DEVELUXSCT\Metaboxes\Product_Main_Facade;
use DEVELUXSCT\Options\Plugin_Main_Options_Page;
use DEVELUXSCT\BulkManager\Bulk;
use DEVELUXSCT\DashboardWidget\DashboardWidget;
use DEVELUXSCT\WC_Settings\WC_Timer_Select;


/**
 *
 */
class Product_Card_Customizer_Facade
{
    /**
     * Init main features
     */
    public function __construct()
    {
        add_action('init', [$this, 'create_product_metabox']);
        add_action('init', [$this, 'plugin_options_page']);
        add_action('init', [$this, 'bulk_set_label']);
        add_action('init', [$this, 'plugin_dashboard_widgets']);
        add_action('init', [$this, 'extend_wc_settings']);

    }


    public function create_product_metabox(): void
    {
        new Product_Main_Facade();
    }

    public function plugin_options_page(): void
    {
        new Plugin_Main_Options_Page();
    }

    public function bulk_set_label(): void
    {
        new Bulk();
    }

    public function plugin_dashboard_widgets(): void{
        new DashboardWidget();
    }

    public function extend_wc_settings(): void{
        new WC_Timer_Select();
    }
}