<?php

namespace DEVELUXSCT\Options;

use DEVELUXSCT\HTMLGenerators\TemplateRenderer;

if (!defined('ABSPATH')) {
    exit;
}

class Timer_Editor
{
    public TemplateRenderer $renderer;

    public function __construct()
    {
        $this->renderer = new TemplateRenderer();
    }

    public function display_timers(): void
    {
        $allowed_html = $this->renderer::get_allowed_html();
        echo '<div class="develux"><div class="flex flex-row flex-wrap items-start justify-between gap pr-15">';
        echo wp_kses($this->renderer->render('general/timer_editor/form_create_cpt', [
            'form_id' => 'develux-create-timer-form',
            'id' => 'create-timer',
            'name' => 'create_timer',
            'label' => 'Timer Title',
            'post_type' => 'develuxsct_timer'
        ]), $allowed_html);
        echo wp_kses($this->renderer->render('general/timer_editor/timer_loop_item', [
            'post_type' => 'develuxsct_timer',
            'posts_per_page' => -1,
            'renderer' => $this->renderer
        ]), $allowed_html);
        echo '</div></div>';

    }

    public function display_builder_form(): void
    {
        $allowed_html = $this->renderer::get_allowed_html();
        echo wp_kses($this->renderer->render('general/timer_editor/timer_editor',
            ['renderer' => $this->renderer]), $allowed_html);
    }

}