<?php

namespace DEVELUXSCT\Options;
if (!defined('ABSPATH')) {
    exit;
}

class Timer_CPT_Query_Data
{
    public static function get_all_timers_id_title(): array
    {
        $args = [
            'post_type' => 'develuxsct_timer',
            'post_status' => 'publish',
            'posts_per_page' => -1,
        ];
        $posts_data = [];
        $query = new \WP_Query($args);
        if ($query->have_posts()) {
            while ($query->have_posts()) {
                $query->the_post();
                $posts_data[] = [
                    'id' => get_the_ID(),
                    'title' => get_the_title()
                ];
            }
        }
        wp_reset_postdata();
        return $posts_data;

    }
    public static function get_all_timers_id_bulk(): array
    {
        static $cached_blocks = null;

        if ($cached_blocks !== null) {
            return $cached_blocks;
        }

        $args = [
            'post_type'      => 'develuxsct_timer',
            'post_status'    => 'publish',
            'posts_per_page' => -1,
            'fields'         => 'ids',
        ];

        $post_ids = get_posts($args);

        $cached_blocks = [];
        foreach ($post_ids as $post_id) {
            $bulk_value = get_post_meta($post_id, 'develux_bulk_item_all_products_ids', true);

            if (!empty($bulk_value)) {
                $cached_blocks[] = [
                    'id'   => (int) $post_id,
                    'bulk' => sanitize_text_field($bulk_value),
                ];
            }
        }

        return $cached_blocks;
    }


}