<?php

namespace DEVELUXSCT\Options;
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
class Timer_CPT
{
    public function __construct() {
        add_action('init', [$this, 'register_timer_cpt']);
    }

    public function register_timer_cpt(): void
    {
        $args = [
            'labels' => [
                'name'          => __('Timer', 'devellux-sales-countdown-timer-builder'),
                'singular_name' => __('Timer', 'devellux-sales-countdown-timer-builder'),
                'add_new'       => __('Add New Timer', 'devellux-sales-countdown-timer-builder'),
                'edit_item'     => __('Edit Timer', 'devellux-sales-countdown-timer-builder'),
                'view_item'     => __('View Timer', 'devellux-sales-countdown-timer-builder'),
                'all_items'     => __('All Timers', 'devellux-sales-countdown-timer-builder'),
            ],
            'public'              => false,
            'show_ui'             => false,
            'show_in_menu'        => false,
            'show_in_admin_bar'   => false,
            'capability_type'     => 'post',
            'hierarchical'        => false,
            'supports'            => ['title','custom-fields'],
            'menu_icon'           => 'dashicons-layout',
            'has_archive'         => false,
            'exclude_from_search' => true,
        ];

        register_post_type('develuxsct_timer', $args);
    }

}