<?php

namespace DEVELUXSCT\Options;
if (!defined('ABSPATH')) {
    exit;
}

trait Global_Timer_Styles_Fields
{
    public function get_global_timer_styles_fields_names(): array
    {
        return [
            'develux_use_single_product_schedule',
            'develux_timer_start_date',
            'develux_timer_date',
            'develux_timer_display_animation',
            'develux_timer_display_on_card',
            'develux_timer_title',
            'develux_timer_title_text_align',
            'develux_font_color_timer_title',
            'develux_font_style_timer_title',
            'develux_font_size_timer_title',
            'develux_font_weight_timer_title',
            'develux_time_title_font_color',
            'develux_time_title_font_size',
            'develux_time_title_font_size_unit',
            'develux_time_title_size_unit',
            'develux_time_title_font_style',
            'develux_time_title_font_weight',
            'develux_timer_day_name',
            'develux_timer_hour_name',
            'develux_timer_minute_name',
            'develux_timer_second_name',
            'develux_timer_location',
            'develux_timer_font_size',
            'develux_timer_font_color',
            'develux_timer_font_weight',
            'develux_timer_font_style',
            'develux_timer_background_color',
            'develux_timer_container_background_color',
            'develux_timer_container_background_a',
            'develux_timer_border_radius',
            'develux_timer_width',
            'develux_timer_height',
            'develux_timer_gap',
            'develux_timer_margin_top',
            'develux_timer_container_padding_x',
            'develux_timer_padding_bottom',
            'develux_timer_container_width',
            'develux_timer_container_vertical_position',
            'develux_timer_wrapper_padding',
            'develux_timer_wrapper_top',
            'develux_timer_wrapper_margin_bottom',
            'develux_timer_wrapper_border_radius',
            'develux_timer_wrapper_border_width',
            'develux_timer_wrapper_border_color',
            'develux_timer_title_text_align',
            'develux_font_style_timer_title',
            'develux_timer_font_size_unit',
            'develux_font_weight_timer_title',

        ];
    }

    private function get_start_end_default_date(): array
    {
        $now = time();
        $futureWeek = $now + (7 * 24 * 60 * 60);

        $saleStart = gmdate('Y-m-d', $now);
        $saleEnd = gmdate('Y-m-d', $futureWeek);

        return [
            'start_date' => $saleStart,
            'end_date' => $saleEnd,
        ];
    }

    public function get_global_timer_default_data_set(): array
    {
        $default_dated = $this->get_start_end_default_date();
        $sale_start = $default_dated['start_date'];
        $sale_end = $default_dated['end_date'];
        return
            [
                'develux_timer_start_date' => $sale_start,
                'develux_timer_date' => $sale_end,
                'develux_timer_display_animation' => 0,
                'develux_timer_display_on_card' => 1,
                'develux_timer_display_on_single' => '0',
                'develux_timer_title' => 'Timer Title',
                'develux_timer_title_text_align' => 'center',
                'develux_font_color_timer_title' => '#ffffff',
                'develux_font_style_timer_title' => 'normal',
                'develux_font_size_timer_title' => 1.3,
                'develux_font_weight_timer_title' => 700,
                'develux_time_title_font_color' => '#62096d',
                'develux_time_title_font_size' => 1,
                'develux_time_title_font_size_unit' => 'rem',
                'develux_time_title_size_unit' => 'rem',
                'develux_time_title_font_style' => 'normal',
                'develux_time_title_font_weight' => 400,
                'develux_timer_day_name' => 'days',
                'develux_timer_hour_name' => 'hrs',
                'develux_timer_minute_name' => 'mins',
                'develux_timer_second_name' => 'secs',
                'develux_timer_location' => 'before_product_title',
                'develux_timer_font_size' => 1.3,
                'develux_timer_font_color' => '#ffffff',
                'develux_timer_font_weight' => 400,
                'develux_timer_font_style' => 'normal',
                'develux_timer_background_color' => '#61086d',
                'develux_timer_container_background_color' => '#9c75d0',
                'develux_timer_border_radius' => 5,
                'develux_timer_width' => 25,
                'develux_timer_height' => 40,
                'develux_timer_gap' => 5,
                'develux_timer_margin_top' => 18,
                'develux_timer_container_padding_x' => 0,
                'develux_timer_padding_bottom' => 5,
                'develux_timer_container_width' => 100,
                'develux_timer_container_vertical_position' => 0,
                'develux_timer_wrapper_padding' => 15,
                'develux_timer_wrapper_top' => 0,
                'develux_timer_wrapper_margin_bottom' => 0,
                'develux_timer_wrapper_border_radius' => 0,
                'develux_timer_wrapper_border_width' => 0,
                'develux_timer_wrapper_border_color' => '#9c75d0',
                'develux_timer_font_size_unit' => 'rem',
                'develux_timer_image_repeat' => 'repeat',
                'develux_timer_image_size' => 'cover',
                'develux_timer_image_position' => 'top',
            ];
    }

    public function get_global_timer_default_multi_data_set(): array
    {
        $develux_coming_soon_space_icon_id = get_option('develux_coming_soon_space_icon_id') ?? '';
        $develux_coming_soon_space_icon_url = $this->develux_get_attachment_url($develux_coming_soon_space_icon_id);

        $develux_new_proposition_icon_id = get_option('develux_new_proposition_icon_id') ?? '';
        $develux_new_proposition_icon_url = $this->develux_get_attachment_url($develux_new_proposition_icon_id);

        $develux_big_sale_icon_id = get_option('develux_big_sale_icon_id') ?? '';
        $develux_big_sale_icon_url = $this->develux_get_attachment_url($develux_big_sale_icon_id);

        $develux_3_for_2_icon_id = get_option('develux_3_for_2_icon_id') ?? '';
        $develux_3_for_2_icon_url = $this->develux_get_attachment_url($develux_3_for_2_icon_id);

        $develux_hurry_up_icon_id = get_option('develux_hurry_up_icon_id') ?? '';
        $develux_hurry_up_icon_url = $this->develux_get_attachment_url($develux_hurry_up_icon_id);

        $develux_new_year_sale_icon_id = get_option('develux_new_year_sale_icon_id') ?? '';
        $develux_new_year_sale_icon_url = $this->develux_get_attachment_url($develux_new_year_sale_icon_id);

        $develux_sale_time_icon_id = get_option('develux_sale_time_icon_id') ?? '';
        $develux_sale_time_icon_url = $this->develux_get_attachment_url($develux_sale_time_icon_id);

        $default_dated = $this->get_start_end_default_date();
        $sale_start = $default_dated['start_date'];
        $sale_end = $default_dated['end_date'];

        return [
            [
                'develux_timer_new_title'=> 'Green Timer',
                'develux_timer_title'=> 'Timer Title',
                'develux_timer_day_name'=> 'Days',
                'develux_timer_hour_name'=> 'Hr',
                'develux_timer_minute_name'=> 'Min',
                'develux_timer_second_name'=> 'Sc',
                'develux_timer_location'=> 'before_product_card',
                'develux_timer_display_on_card'=> '1',
                'develux_timer_display_on_single'=> '0',
                'develux_use_single_product_schedule'=> '1',
                'develux_timer_start_date'=> $sale_start,
                'develux_timer_date'=> $sale_end,
                'develux_font_size_timer_title'=> '1.3',
                'develux_font_weight_timer_title'=> '700',
                'develux_font_style_timer_title'=> 'normal',
                'develux_font_color_timer_title'=> '#ffffff',
                'develux_timer_title_text_align'=> 'center',
                'develux_time_title_font_size'=> '1',
                'develux_time_title_font_style'=> 'normal',
                'develux_time_title_font_weight'=> '400',
                'develux_time_title_font_color'=> '#ffffff',
                'develux_timer_display_animation'=> '0',
                'develux_timer_font_size'=> '1',
                'develux_timer_font_style'=> 'normal',
                'develux_timer_font_weight'=> '400',
                'develux_timer_font_color'=> '#ffffff',
                'develux_timer_border_radius'=> '0',
                'develux_timer_width'=> '25',
                'develux_timer_height'=> '40',
                'develux_timer_gap'=> '5',
                'develux_timer_margin_top'=> '5',
                'develux_timer_background_color'=> '#287447',
                'develux_timer_padding_bottom'=> '0',
                'develux_timer_container_padding_x'=> '0',
                'develux_timer_container_width'=> '100',
                'develux_timer_container_vertical_position'=> '0',
                'develux_timer_container_background_color'=> '#329059',
                'develux_timer_container_background_a'=> '1',
                'develux_timer_bg_icon'=> '',
                'develux_timer_bg_icon_url'=> '',
                'develux_timer_image_repeat'=> 'repeat',
                'develux_timer_image_size'=> 'cover',
                'develux_timer_image_position'=> 'top',
                'develux_timer_wrapper_padding'=> '15',
                'develux_timer_wrapper_top'=> '0',
                'develux_timer_wrapper_margin_bottom'=> '0',
                'develux_timer_wrapper_border_radius'=> '0',
                'develux_timer_wrapper_border_width'=> '0',
                'develux_timer_wrapper_border_color'=> '#9c75d0',
            ],// green timer
            [
                'develux_timer_new_title'=> 'Big Sale #2',
                'develux_timer_title'=> 'Big Sale',
                'develux_timer_day_name'=> 'Days',
                'develux_timer_hour_name'=> 'Hours',
                'develux_timer_minute_name'=> 'Min',
                'develux_timer_second_name'=> 'Sec',
                'develux_timer_location'=> 'before_product_title',
                'develux_timer_display_on_card'=> '1',
                'develux_timer_display_on_single'=> '0',
                'develux_use_single_product_schedule'=> '0',
                'develux_timer_start_date'=> $sale_start,
                'develux_timer_date'=> $sale_end,
                'develux_font_size_timer_title'=> '1.2',
                'develux_font_weight_timer_title'=> '700',
                'develux_font_style_timer_title'=> 'normal',
                'develux_font_color_timer_title'=> '#f05151',
                'develux_timer_title_text_align'=> 'center',
                'develux_time_title_font_size'=> '0.8',
                'develux_time_title_font_style'=> 'normal',
                'develux_time_title_font_weight'=> '400',
                'develux_time_title_font_color'=> '#a3a3a3',
                'develux_timer_display_animation'=> '1',
                'develux_timer_font_size'=> '1.8',
                'develux_timer_font_style'=> 'normal',
                'develux_timer_font_weight'=> '400',
                'develux_timer_font_color'=> '#c33737',
                'develux_timer_border_radius'=> '5',
                'develux_timer_width'=> '25',
                'develux_timer_height'=> '40',
                'develux_timer_gap'=> '5',
                'develux_timer_margin_top'=> '10',
                'develux_timer_background_color'=> '#ffffff',
                'develux_timer_padding_bottom'=> '0',
                'develux_timer_container_padding_x'=> '0',
                'develux_timer_container_width'=> '100',
                'develux_timer_container_vertical_position'=> '0',
                'develux_timer_container_background_color'=> '#ebecff',
                'develux_timer_container_background_a'=> '1',
                'develux_timer_bg_icon'=> '',
                'develux_timer_bg_icon_url'=> '',
                'develux_timer_image_repeat'=> 'repeat',
                'develux_timer_image_size'=> 'cover',
                'develux_timer_image_position'=> 'top',
                'develux_timer_wrapper_padding'=> '7',
                'develux_timer_wrapper_top'=> '5',
                'develux_timer_wrapper_margin_bottom'=> '0',
                'develux_timer_wrapper_border_radius'=> '0',
                'develux_timer_wrapper_border_width'=> '0',
                'develux_timer_wrapper_border_color'=> '#9c75d0',
            ], // big sale # 2
            [
                'develux_timer_new_title'=> 'Coming soon…',
                'develux_timer_title'=> 'Coming soon…',
                'develux_timer_day_name'=> 'DAYS',
                'develux_timer_hour_name'=> 'HOURS',
                'develux_timer_minute_name'=> 'MINUTES',
                'develux_timer_second_name'=> 'SECONDS',
                'develux_timer_location'=> 'before_product_title',
                'develux_timer_display_on_card'=> '1',
                'develux_timer_display_on_single'=> '0',
                'develux_use_single_product_schedule'=> '1',
                'develux_timer_start_date'=> $sale_start,
                'develux_timer_date'=> $sale_end,
                'develux_font_size_timer_title'=> '1.3',
                'develux_font_weight_timer_title'=> '700',
                'develux_font_style_timer_title'=> 'normal',
                'develux_font_color_timer_title'=> '#ffffff',
                'develux_timer_title_text_align'=> 'center',
                'develux_time_title_font_size'=> '0.5',
                'develux_time_title_font_style'=> 'normal',
                'develux_time_title_font_weight'=> '400',
                'develux_time_title_font_color'=> '#e9a912',
                'develux_timer_display_animation'=> '1',
                'develux_timer_font_size'=> '1.6',
                'develux_timer_font_style'=> 'normal',
                'develux_timer_font_weight'=> '700',
                'develux_timer_font_color'=> '#dbdbdb',
                'develux_timer_border_radius'=> '5',
                'develux_timer_width'=> '25',
                'develux_timer_height'=> '40',
                'develux_timer_gap'=> '5',
                'develux_timer_margin_top'=> '10',
                'develux_timer_background_color'=> '#3e3e3e',
                'develux_timer_padding_bottom'=> '5',
                'develux_timer_container_padding_x'=> '0',
                'develux_timer_container_width'=> '100',
                'develux_timer_container_vertical_position'=> '0',
                'develux_timer_container_background_color'=> '#1e1e1e',
                'develux_timer_container_background_a'=> '1',
                'develux_timer_bg_icon'=> '',
                'develux_timer_bg_icon_url'=> '',
                'develux_timer_image_repeat'=> 'repeat',
                'develux_timer_image_size'=> 'cover',
                'develux_timer_image_position'=> 'top',
                'develux_timer_wrapper_padding'=> '15',
                'develux_timer_wrapper_top'=> '0',
                'develux_timer_wrapper_margin_bottom'=> '0',
                'develux_timer_wrapper_border_radius'=> '0',
                'develux_timer_wrapper_border_width'=> '3',
                'develux_timer_wrapper_border_color'=> '#000000',
            ], // coming soon ...
            [
                'develux_timer_new_title'=> 'Coming soon space',
                'develux_timer_title'=> 'Coming soon',
                'develux_timer_day_name'=> 'days',
                'develux_timer_hour_name'=> 'hrs',
                'develux_timer_minute_name'=> 'mins',
                'develux_timer_second_name'=> 'secs',
                'develux_timer_location'=> 'before_product_title',
                'develux_timer_display_on_card'=> '1',
                'develux_timer_display_on_single'=> '0',
                'develux_use_single_product_schedule'=> '0',
                'develux_timer_start_date'=> $sale_start,
                'develux_timer_date'=> $sale_end,
                'develux_font_size_timer_title'=> '1.3',
                'develux_font_weight_timer_title'=> '700',
                'develux_font_style_timer_title'=> 'normal',
                'develux_font_color_timer_title'=> '#ffffff',
                'develux_timer_title_text_align'=> 'center',
                'develux_time_title_font_size'=> '0.8',
                'develux_time_title_font_style'=> 'normal',
                'develux_time_title_font_weight'=> '600',
                'develux_time_title_font_color'=> '#ffffff',
                'develux_timer_display_animation'=> '0',
                'develux_timer_font_size'=> '1.3',
                'develux_timer_font_style'=> 'normal',
                'develux_timer_font_weight'=> '700',
                'develux_timer_font_color'=> '#360d83',
                'develux_timer_border_radius'=> '10',
                'develux_timer_width'=> '20',
                'develux_timer_height'=> '36',
                'develux_timer_gap'=> '9',
                'develux_timer_margin_top'=> '18',
                'develux_timer_background_color'=> '#ffffff',
                'develux_timer_padding_bottom'=> '5',
                'develux_timer_container_padding_x'=> '0',
                'develux_timer_container_width'=> '100',
                'develux_timer_container_vertical_position'=> '0',
                'develux_timer_container_background_color'=> '#9c75d0',
                'develux_timer_container_background_a'=> '1',
                'develux_timer_bg_icon'=> $develux_coming_soon_space_icon_id,
                'develux_timer_bg_icon_url'=> $develux_coming_soon_space_icon_url,
                'develux_timer_image_repeat'=> 'repeat',
                'develux_timer_image_size'=> 'cover',
                'develux_timer_image_position'=> 'top',
                'develux_timer_wrapper_padding'=> '15',
                'develux_timer_wrapper_width'=> '50',
                'develux_timer_wrapper_top'=> '0',
                'develux_timer_wrapper_margin_bottom'=> '0',
                'develux_timer_wrapper_border_radius'=> '0',
                'develux_timer_wrapper_border_width'=> '0',
                'develux_timer_wrapper_border_color'=> '#9c75d0',
            ], // coming soon space
            [
                'develux_timer_new_title'=> 'New proposition',
                'develux_timer_title'=> 'New proposition',
                'develux_timer_day_name'=> '',
                'develux_timer_hour_name'=> '',
                'develux_timer_minute_name'=> '',
                'develux_timer_second_name'=> '',
                'develux_timer_location'=> 'before_product_title',
                'develux_timer_display_on_card'=> '1',
                'develux_timer_display_on_single'=> '0',
                'develux_use_single_product_schedule'=> '1',
                'develux_timer_start_date'=> $sale_start,
                'develux_timer_date'=> $sale_end,
                'develux_font_size_timer_title'=> '1.3',
                'develux_font_weight_timer_title'=> '700',
                'develux_font_style_timer_title'=> 'normal',
                'develux_font_color_timer_title'=> '#ffffff',
                'develux_timer_title_text_align'=> 'center',
                'develux_time_title_font_size'=> '1',
                'develux_time_title_font_style'=> 'normal',
                'develux_time_title_font_weight'=> '400',
                'develux_time_title_font_color'=> '#62096d',
                'develux_timer_display_animation'=> '0',
                'develux_timer_font_size'=> '1.3',
                'develux_timer_font_style'=> 'normal',
                'develux_timer_font_weight'=> '400',
                'develux_timer_font_color'=> '#ffffff',
                'develux_timer_border_radius'=> '5',
                'develux_timer_width'=> '25',
                'develux_timer_height'=> '40',
                'develux_timer_gap'=> '5',
                'develux_timer_margin_top'=> '18',
                'develux_timer_background_color'=> '#05dbfe',
                'develux_timer_padding_bottom'=> '5',
                'develux_timer_container_padding_x'=> '0',
                'develux_timer_container_width'=> '100',
                'develux_timer_container_vertical_position'=> '0',
                'develux_timer_container_background_color'=> '#9c75d0',
                'develux_timer_container_background_a'=> '1',
                'develux_timer_bg_icon'=> $develux_new_proposition_icon_id,
                'develux_timer_bg_icon_url'=> $develux_new_proposition_icon_url,
                'develux_timer_image_repeat'=> 'repeat',
                'develux_timer_image_size'=> 'cover',
                'develux_timer_image_position'=> 'center',
                'develux_timer_wrapper_padding'=> '7',
                'develux_timer_wrapper_width'=> '50',
                'develux_timer_wrapper_top'=> '0',
                'develux_timer_wrapper_margin_bottom'=> '0',
                'develux_timer_wrapper_border_radius'=> '0',
                'develux_timer_wrapper_border_width'=> '0',
                'develux_timer_wrapper_border_color'=> '#9c75d0',
                'develux-bulk-include-product'=> '',
                'develux-bulk-exclude-product'=> '',
            ], // New proposition
            [
                'develux_timer_new_title'=> 'Big Sale',
                'develux_timer_title'=> 'Big Sale',
                'develux_timer_day_name'=> 'D',
                'develux_timer_hour_name'=> 'H',
                'develux_timer_minute_name'=> 'M',
                'develux_timer_second_name'=> 'S',
                'develux_timer_location'=> 'before_product_card',
                'develux_timer_display_on_card'=> '1',
                'develux_timer_display_on_single'=> '0',
                'develux_use_single_product_schedule'=> '1',
                'develux_timer_start_date'=> $sale_start,
                'develux_timer_date'=> $sale_end,
                'develux_font_size_timer_title'=> '1.3',
                'develux_font_weight_timer_title'=> '900',
                'develux_font_style_timer_title'=> 'normal',
                'develux_font_color_timer_title'=> '#ffffff',
                'develux_timer_title_text_align'=> 'center',
                'develux_time_title_font_size'=> '1',
                'develux_time_title_font_style'=> 'normal',
                'develux_time_title_font_weight'=> '600',
                'develux_time_title_font_color'=> '#18a9e7',
                'develux_timer_display_animation'=> '0',
                'develux_timer_font_size'=> '1.3',
                'develux_timer_font_style'=> 'normal',
                'develux_timer_font_weight'=> '400',
                'develux_timer_font_color'=> '#fff700',
                'develux_timer_border_radius'=> '5',
                'develux_timer_width'=> '20',
                'develux_timer_height'=> '34',
                'develux_timer_gap'=> '8',
                'develux_timer_margin_top'=> '5',
                'develux_timer_background_color'=> '#52cbc9',
                'develux_timer_padding_bottom'=> '0',
                'develux_timer_container_padding_x'=> '0',
                'develux_timer_container_width'=> '100',
                'develux_timer_container_vertical_position'=> '0',
                'develux_timer_container_background_color'=> '#9c75d0',
                'develux_timer_container_background_a'=> '1',
                'develux_timer_bg_icon'=> $develux_big_sale_icon_id,
                'develux_timer_bg_icon_url'=> $develux_big_sale_icon_url,
                'develux_timer_image_repeat'=> 'repeat',
                'develux_timer_image_size'=> 'cover',
                'develux_timer_image_position'=> 'top',
                'develux_timer_wrapper_padding'=> '5',
                'develux_timer_wrapper_width'=> '50',
                'develux_timer_wrapper_top'=> '0',
                'develux_timer_wrapper_margin_bottom'=> '0',
                'develux_timer_wrapper_border_radius'=> '0',
                'develux_timer_wrapper_border_width'=> '0',
                'develux_timer_wrapper_border_color'=> '#9c75d0',
            ], // Big Sale
            [
                'develux_timer_new_title'=> '3 for 2',
                'develux_timer_title'=> '3 for 2',
                'develux_timer_day_name'=> 'Days',
                'develux_timer_hour_name'=> 'Hours',
                'develux_timer_minute_name'=> 'Min',
                'develux_timer_second_name'=> 'Sec',
                'develux_timer_location'=> 'before_product_title',
                'develux_timer_display_on_card'=> '1',
                'develux_timer_display_on_single'=> '0',
                'develux_use_single_product_schedule'=> '1',
                'develux_timer_start_date'=> $sale_start,
                'develux_timer_date'=> $sale_end,
                'develux_font_size_timer_title'=> '1.6',
                'develux_font_weight_timer_title'=> '700',
                'develux_font_style_timer_title'=> 'normal',
                'develux_font_color_timer_title'=> '#fb0caa',
                'develux_timer_title_text_align'=> 'center',
                'develux_time_title_font_size'=> '0.8',
                'develux_time_title_font_style'=> 'normal',
                'develux_time_title_font_weight'=> '700',
                'develux_time_title_font_color'=> '#2d28b8',
                'develux_timer_display_animation'=> '0',
                'develux_timer_font_size'=> '1.1',
                'develux_timer_font_style'=> 'normal',
                'develux_timer_font_weight'=> '400',
                'develux_timer_font_color'=> '#ffffff',
                'develux_timer_border_radius'=> '5',
                'develux_timer_width'=> '18',
                'develux_timer_height'=> '32',
                'develux_timer_gap'=> '8',
                'develux_timer_margin_top'=> '5',
                'develux_timer_background_color'=> '#2d28b8',
                'develux_timer_padding_bottom'=> '4',
                'develux_timer_container_padding_x'=> '0',
                'develux_timer_container_width'=> '100',
                'develux_timer_container_vertical_position'=> '0',
                'develux_timer_container_background_color'=> '#9c75d0',
                'develux_timer_container_background_a'=> '1',
                'develux_timer_bg_icon'=> $develux_3_for_2_icon_id,
                'develux_timer_bg_icon_url'=> $develux_3_for_2_icon_url,
                'develux_timer_image_repeat'=> 'no-repeat',
                'develux_timer_image_size'=> 'cover',
                'develux_timer_image_position'=> 'center',
                'develux_timer_wrapper_padding'=> '5',
                'develux_timer_wrapper_width'=> '50',
                'develux_timer_wrapper_top'=> '0',
                'develux_timer_wrapper_margin_bottom'=> '4',
                'develux_timer_wrapper_border_radius'=> '0',
                'develux_timer_wrapper_border_width'=> '0',
                'develux_timer_wrapper_border_color'=> '#9c75d0',
            ], // 3 for 2
            [
                'develux_timer_new_title'=> 'Hurry Up',
                'develux_timer_title'=> 'Hurry Up',
                'develux_timer_day_name'=> 'Days',
                'develux_timer_hour_name'=> 'Hours',
                'develux_timer_minute_name'=> 'Min',
                'develux_timer_second_name'=> 'Sec',
                'develux_timer_location'=> 'before_product_title',
                'develux_timer_display_on_card'=> '1',
                'develux_timer_display_on_single'=> '0',
                'develux_use_single_product_schedule'=> '0',
                'develux_timer_start_date'=> $sale_start,
                'develux_timer_date'=> $sale_end,
                'develux_font_size_timer_title'=> '1.2',
                'develux_font_weight_timer_title'=> '700',
                'develux_font_style_timer_title'=> 'normal',
                'develux_font_color_timer_title'=> '#ffffff',
                'develux_timer_title_text_align'=> 'center',
                'develux_time_title_font_size'=> '0.6',
                'develux_time_title_font_style'=> 'normal',
                'develux_time_title_font_weight'=> '800',
                'develux_time_title_font_color'=> '#ffffff',
                'develux_timer_display_animation'=> '0',
                'develux_timer_font_size'=> '1.3',
                'develux_timer_font_style'=> 'normal',
                'develux_timer_font_weight'=> '400',
                'develux_timer_font_color'=> '#ffffff',
                'develux_timer_border_radius'=> '5',
                'develux_timer_width'=> '20',
                'develux_timer_height'=> '37',
                'develux_timer_gap'=> '8',
                'develux_timer_margin_top'=> '10',
                'develux_timer_background_color'=> '#000000',
                'develux_timer_padding_bottom'=> '0',
                'develux_timer_container_padding_x'=> '0',
                'develux_timer_container_width'=> '100',
                'develux_timer_container_vertical_position'=> '0',
                'develux_timer_container_background_color'=> '#707aff',
                'develux_timer_container_background_a'=> '1',
                'develux_timer_bg_icon'=> $develux_hurry_up_icon_id,
                'develux_timer_bg_icon_url'=> $develux_hurry_up_icon_url,
                'develux_timer_image_repeat'=> 'no-repeat',
                'develux_timer_image_size'=> 'cover',
                'develux_timer_image_position'=> 'center',
                'develux_timer_wrapper_padding'=> '15',
                'develux_timer_wrapper_width'=> '50',
                'develux_timer_wrapper_top'=> '0',
                'develux_timer_wrapper_margin_bottom'=> '0',
                'develux_timer_wrapper_border_radius'=> '0',
                'develux_timer_wrapper_border_width'=> '0',
                'develux_timer_wrapper_border_color'=> '#9c75d0',
            ], // Hurry up
            [
                'develux_timer_new_title'=> 'Simple timer',
                'develux_timer_title'=> 'Simple timer',
                'develux_timer_day_name'=> '',
                'develux_timer_hour_name'=> '',
                'develux_timer_minute_name'=> '',
                'develux_timer_second_name'=> '',
                'develux_timer_location'=> 'before_product_card',
                'develux_timer_display_on_card'=> '1',
                'develux_timer_display_on_single'=> '0',
                'develux_use_single_product_schedule'=> '0',
                'develux_timer_start_date'=> $sale_start,
                'develux_timer_date'=> $sale_end,
                'develux_font_size_timer_title'=> '1.3',
                'develux_font_weight_timer_title'=> '700',
                'develux_font_style_timer_title'=> 'normal',
                'develux_font_color_timer_title'=> '#ffffff',
                'develux_timer_title_text_align'=> 'center',
                'develux_time_title_font_size'=> '1',
                'develux_time_title_font_style'=> 'normal',
                'develux_time_title_font_weight'=> '400',
                'develux_time_title_font_color'=> '#62096d',
                'develux_timer_display_animation'=> '0',
                'develux_timer_font_size'=> '1.3',
                'develux_timer_font_style'=> 'normal',
                'develux_timer_font_weight'=> '400',
                'develux_timer_font_color'=> '#ffffff',
                'develux_timer_border_radius'=> '5',
                'develux_timer_width'=> '17',
                'develux_timer_height'=> '32',
                'develux_timer_gap'=> '10',
                'develux_timer_margin_top'=> '0',
                'develux_timer_background_color'=> '#ed0c0c',
                'develux_timer_padding_bottom'=> '0',
                'develux_timer_container_padding_x'=> '0',
                'develux_timer_container_width'=> '90',
                'develux_timer_container_vertical_position'=> '0',
                'develux_timer_container_background_color'=> '#9c75d0',
                'develux_timer_container_background_a'=> '0',
                'develux_timer_bg_icon'=> '',
                'develux_timer_bg_icon_url'=> '',
                'develux_timer_image_repeat'=> 'repeat',
                'develux_timer_image_size'=> 'cover',
                'develux_timer_image_position'=> 'top',
                'develux_timer_wrapper_padding'=> '0',
                'develux_timer_wrapper_width'=> '50',
                'develux_timer_wrapper_top'=> '0',
                'develux_timer_wrapper_margin_bottom'=> '0',
                'develux_timer_wrapper_border_radius'=> '0',
                'develux_timer_wrapper_border_width'=> '0',
                'develux_timer_wrapper_border_color'=> '#9c75d0',
            ], // Simple timer
            [
                'develux_timer_new_title'=> 'New Year Sale',
                'develux_timer_title'=> 'New Year Sale',
                'develux_timer_day_name'=> 'Days',
                'develux_timer_hour_name'=> 'Hours',
                'develux_timer_minute_name'=> 'Min',
                'develux_timer_second_name'=> 'Sec',
                'develux_timer_location'=> 'after_product_title',
                'develux_timer_display_on_card'=> '1',
                'develux_timer_display_on_single'=> '0',
                'develux_use_single_product_schedule'=> '1',
                'develux_timer_start_date'=> $sale_start,
                'develux_timer_date'=> $sale_end,
                'develux_font_size_timer_title'=> '1.3',
                'develux_font_weight_timer_title'=> '700',
                'develux_font_style_timer_title'=> 'normal',
                'develux_font_color_timer_title'=> '#fff001',
                'develux_timer_title_text_align'=> 'center',
                'develux_time_title_font_size'=> '1',
                'develux_time_title_font_style'=> 'normal',
                'develux_time_title_font_weight'=> '400',
                'develux_time_title_font_color'=> '#ffce7a',
                'develux_timer_display_animation'=> '0',
                'develux_timer_font_size'=> '1.5',
                'develux_timer_font_style'=> 'normal',
                'develux_timer_font_weight'=> '600',
                'develux_timer_font_color'=> '#ff0000',
                'develux_timer_border_radius'=> '5',
                'develux_timer_width'=> '20',
                'develux_timer_height'=> '37',
                'develux_timer_gap'=> '5',
                'develux_timer_margin_top'=> '9',
                'develux_timer_background_color'=> '#f5f5f5',
                'develux_timer_padding_bottom'=> '0',
                'develux_timer_container_padding_x'=> '0',
                'develux_timer_container_width'=> '100',
                'develux_timer_container_vertical_position'=> '0',
                'develux_timer_container_background_color'=> '#1e7b29',
                'develux_timer_container_background_a'=> '1',
                'develux_timer_bg_icon'=> $develux_new_year_sale_icon_id,
                'develux_timer_bg_icon_url'=> $develux_new_year_sale_icon_url,
                'develux_timer_image_repeat'=> 'no-repeat',
                'develux_timer_image_size'=> 'cover',
                'develux_timer_image_position'=> 'top',
                'develux_timer_wrapper_padding'=> '5',
                'develux_timer_wrapper_width'=> '50',
                'develux_timer_wrapper_top'=> '0',
                'develux_timer_wrapper_margin_bottom'=> '5',
                'develux_timer_wrapper_border_radius'=> '0',
                'develux_timer_wrapper_border_width'=> '0',
                'develux_timer_wrapper_border_color'=> '#9c75d0',
            ], // new year sale
            [
                'develux_timer_new_title'=> 'White timer',
                'develux_timer_title'=> 'White timer',
                'develux_timer_day_name'=> 'Days',
                'develux_timer_hour_name'=> 'Hours',
                'develux_timer_minute_name'=> 'Min',
                'develux_timer_second_name'=> 'Sec',
                'develux_timer_location'=> 'before_product_title',
                'develux_timer_display_on_card'=> '1',
                'develux_timer_display_on_single'=> '0',
                'develux_use_single_product_schedule'=> '1',
                'develux_timer_start_date'=> $sale_start,
                'develux_timer_date'=> $sale_end,
                'develux_font_size_timer_title'=> '1.3',
                'develux_font_weight_timer_title'=> '700',
                'develux_font_style_timer_title'=> 'normal',
                'develux_font_color_timer_title'=> '#ffffff',
                'develux_timer_title_text_align'=> 'center',
                'develux_time_title_font_size'=> '0.7',
                'develux_time_title_font_style'=> 'normal',
                'develux_time_title_font_weight'=> '400',
                'develux_time_title_font_color'=> '#a3a3a3',
                'develux_timer_display_animation'=> '0',
                'develux_timer_font_size'=> '1.4',
                'develux_timer_font_style'=> 'normal',
                'develux_timer_font_weight'=> '400',
                'develux_timer_font_color'=> '#e81111',
                'develux_timer_border_radius'=> '6',
                'develux_timer_width'=> '22',
                'develux_timer_height'=> '40',
                'develux_timer_gap'=> '7',
                'develux_timer_margin_top'=> '0',
                'develux_timer_background_color'=> '#fcfcfc',
                'develux_timer_padding_bottom'=> '5',
                'develux_timer_container_padding_x'=> '0',
                'develux_timer_container_width'=> '100',
                'develux_timer_container_vertical_position'=> '0',
                'develux_timer_container_background_color'=> '#ffffff',
                'develux_timer_container_background_a'=> '1',
                'develux_timer_bg_icon'=> '',
                'develux_timer_bg_icon_url'=> '',
                'develux_timer_image_repeat'=> 'repeat',
                'develux_timer_image_size'=> 'cover',
                'develux_timer_image_position'=> 'top',
                'develux_timer_wrapper_padding'=> '15',
                'develux_timer_wrapper_width'=> '50',
                'develux_timer_wrapper_top'=> '0',
                'develux_timer_wrapper_margin_bottom'=> '0',
                'develux_timer_wrapper_border_radius'=> '0',
                'develux_timer_wrapper_border_width'=> '0',
                'develux_timer_wrapper_border_color'=> '#9c75d0',
            ], // white timer
            [
                'develux_timer_new_title'=> 'Sale Time',
                'develux_timer_title'=> 'Sale Time',
                'develux_timer_day_name'=> 'day',
                'develux_timer_hour_name'=> 'hour',
                'develux_timer_minute_name'=> 'min',
                'develux_timer_second_name'=> 'sec',
                'develux_timer_location'=> 'before_product_title',
                'develux_timer_display_on_card'=> '1',
                'develux_timer_display_on_single'=> '0',
                'develux_use_single_product_schedule'=> '1',
                'develux_timer_start_date'=> $sale_start,
                'develux_timer_date'=> $sale_end,
                'develux_font_size_timer_title'=> '1.3',
                'develux_font_weight_timer_title'=> '700',
                'develux_font_style_timer_title'=> 'normal',
                'develux_font_color_timer_title'=> '#62096d',
                'develux_timer_title_text_align'=> 'center',
                'develux_time_title_font_size'=> '0.9',
                'develux_time_title_font_style'=> 'normal',
                'develux_time_title_font_weight'=> '500',
                'develux_time_title_font_color'=> '#62096d',
                'develux_timer_display_animation'=> '0',
                'develux_timer_font_size'=> '1.1',
                'develux_timer_font_style'=> 'normal',
                'develux_timer_font_weight'=> '700',
                'develux_timer_font_color'=> '#f5f5f5',
                'develux_timer_border_radius'=> '5',
                'develux_timer_width'=> '20',
                'develux_timer_height'=> '35',
                'develux_timer_gap'=> '8',
                'develux_timer_margin_top'=> '18',
                'develux_timer_background_color'=> '#61086d',
                'develux_timer_padding_bottom'=> '0',
                'develux_timer_container_padding_x'=> '0',
                'develux_timer_container_width'=> '100',
                'develux_timer_container_vertical_position'=> '0',
                'develux_timer_container_background_color'=> '#bd5683',
                'develux_timer_container_background_a'=> '1',
                'develux_timer_bg_icon'=> $develux_sale_time_icon_id,
                'develux_timer_bg_icon_url'=> $develux_sale_time_icon_url,
                'develux_timer_image_repeat'=> 'no-repeat',
                'develux_timer_image_size'=> 'cover',
                'develux_timer_image_position'=> 'left',
                'develux_timer_wrapper_padding'=> '17',
                'develux_timer_wrapper_width'=> '50',
                'develux_timer_wrapper_top'=> '0',
                'develux_timer_wrapper_margin_bottom'=> '0',
                'develux_timer_wrapper_border_radius'=> '0',
                'develux_timer_wrapper_border_width'=> '0',
                'develux_timer_wrapper_border_color'=> '#9c75d0',
            ], // sale time
        ];
    }

    private function develux_get_attachment_url($attachment_id): string
    {
        if( $attachment_id ){
            $attachment_url = wp_get_attachment_url($attachment_id);
        }else{
            $attachment_url = '';
        }
        return $attachment_url;
    }
}