<?php

namespace DEVELUXSCT\Options;

if (!defined('ABSPATH')) {
    exit;
}

class CPT_Default_Instances
{
    use Global_Timer_Styles_Fields;

    public function __construct()
    {
        $this->register_default_instances();
    }

    public function register_default_instances(): void
    {
        $this->upload_plugin_icon_to_media();
        $this->create_default_instance('develuxsct_timer', $this->get_global_timer_default_multi_data_set());
    }

    private function upload_plugin_icon_to_media(): void
    {
        require_once ABSPATH . 'wp-admin/includes/image.php';
        require_once ABSPATH . 'wp-admin/includes/file.php';
        require_once ABSPATH . 'wp-admin/includes/media.php';

        $this->develux_upload_image_to_media_library( DEVELUXSCT_DWPC_PATH .'assets/images/default/coming_soon_space.jpg','coming_soon_space.jpg','develux_coming_soon_space_icon_id');
        $this->develux_upload_image_to_media_library( DEVELUXSCT_DWPC_PATH .'assets/images/default/new_proposition.jpg','new_proposition.jpg','develux_new_proposition_icon_id');
        $this->develux_upload_image_to_media_library( DEVELUXSCT_DWPC_PATH .'assets/images/default/big_sale.jpg','big_sale.jpg','develux_big_sale_icon_id');
        $this->develux_upload_image_to_media_library( DEVELUXSCT_DWPC_PATH .'assets/images/default/3_for_2.jpg','3_for_2.jpg','develux_3_for_2_icon_id');
        $this->develux_upload_image_to_media_library( DEVELUXSCT_DWPC_PATH .'assets/images/default/hurry_up.png','hurry_up.png','develux_hurry_up_icon_id');
        $this->develux_upload_image_to_media_library( DEVELUXSCT_DWPC_PATH .'assets/images/default/new_year_sale.png','new_year_sale.png','develux_new_year_sale_icon_id');
        $this->develux_upload_image_to_media_library( DEVELUXSCT_DWPC_PATH .'assets/images/default/sale_time.jpg','sale_time.jpg','develux_sale_time_icon_id');

    }
    private function create_default_instance(string $post_type, array $fields): void
    {
        foreach ($fields as $i => $field) {
            $query = new \WP_Query([
                'post_type' => $post_type,
                'posts_per_page' => 1,
                'post_status' => 'any',
                'title' => $field['develux_timer_new_title'],
                'fields' => 'ids',
            ]);

            if (!empty($query->posts)) {
                wp_reset_postdata();
                continue;
            }
            $post_id = wp_insert_post([
                'post_title' => $field['develux_timer_new_title'],
                'post_type' => $post_type,
                'post_status' => 'publish',
            ]);

            if ($post_id && !is_wp_error($post_id)) {
                foreach ($field as $meta_key => $meta_value) {
                    update_post_meta($post_id, $meta_key, $meta_value);
                }
            }

        }

    }

    private function develux_upload_image_to_media_library($image_path, $image_name, $option_key): void
    {
        if (!file_exists($image_path)) {
            return;
        }

        $image_data = file_get_contents($image_path);
        $upload = wp_upload_bits($image_name, null, $image_data);

        if (!empty($upload['error'])) {
            return;
        }

        $file_path = $upload['file'];
        $filetype = wp_check_filetype($file_path);

        $attachment = [
            'post_mime_type' => $filetype['type'],
            'post_title'     => sanitize_file_name($image_name),
            'post_content'   => '',
            'post_status'    => 'inherit',
        ];

        $attach_id = wp_insert_attachment($attachment, $file_path);
        if (is_wp_error($attach_id)) {
            return;
        }

        require_once ABSPATH . 'wp-admin/includes/image.php';

        $attach_data = wp_generate_attachment_metadata($attach_id, $file_path);
        wp_update_attachment_metadata($attach_id, $attach_data);

        update_option($option_key, $attach_id);
    }
}