<?php

namespace DEVELUXSCT\Metaboxes;
if (!defined('ABSPATH')) {
    exit;
}

use DEVELUXSCT\HTMLGenerators\CountdownTimerGenerator;
use DEVELUXSCT\Options\Timer_CPT_Query_Data;
use DEVELUXSCT\HTMLGenerators\TemplateRenderer;

class ProductFE
{
    public $allowed_html;

    public function __construct()
    {
        $this->allowed_html = TemplateRenderer::get_allowed_html();
        add_action('woocommerce_before_shop_loop_item_title', [$this, 'display_countdown_timer_before_title'], 20);
        add_action('woocommerce_after_shop_loop_item_title', [$this, 'display_countdown_timer_after_title'], 25);
        add_action('woocommerce_before_shop_loop_item', [$this, 'display_countdown_timer_before_loop_item'], 10);

        add_action('woocommerce_before_single_product_summary', [$this, 'display_single_product_timer_builder'], 20);
        add_action('woocommerce_before_add_to_cart_form', [$this, 'display_single_product_timer_builder'], 20);
        add_action('woocommerce_product_thumbnails', [$this, 'display_single_product_timer_builder'], 20);
        add_action('woocommerce_after_add_to_cart_form', [$this, 'display_single_product_timer_builder'], 20);
    }

    public function display_single_product_timer_builder(): void
    {
        global $product;
        if (!$product) {
            return;
        }
        $product_id = $product->get_id();
        $develux_timer_prioritise = 0;
        $develux_timer_select = get_post_meta($product_id, 'develux_timer_select', true);
        if($develux_timer_select){
            $develux_timer_prioritise = 1;
        }

        $current_hook = current_filter();


        if ($develux_timer_prioritise) {
            $develux_timer_location = get_post_meta($develux_timer_select, 'develux_timer_location_single', true) ?: '';
            $develux_timer_display_on_single = get_post_meta($develux_timer_select, 'develux_timer_display_on_single', true) || '';
            if ($develux_timer_location === $current_hook && $develux_timer_display_on_single) {
                $develux_use_single_product_schedule = get_post_meta($develux_timer_select, 'develux_use_single_product_schedule', true);
                if($develux_use_single_product_schedule){
                    echo wp_kses(CountdownTimerGenerator::generate_countdown_timer($develux_timer_select,'','',$product_id, true), $this->allowed_html);
                }else{
                    $develux_timer_start_date = get_post_meta($develux_timer_select, 'develux_timer_start_date', true) ?? '';
                    $develux_timer_date = get_post_meta($develux_timer_select, 'develux_timer_date', true) ?? '';
                    echo wp_kses(CountdownTimerGenerator::generate_countdown_timer($develux_timer_select,$develux_timer_date,$develux_timer_start_date,$product_id,true), $this->allowed_html);
                }
            }
        } else {
            $timer_data = Timer_CPT_Query_Data::get_all_timers_id_bulk();
            echo wp_kses(
                Helper::display_countdown_timer_single($timer_data, $product_id, $current_hook),
                $this->allowed_html);
        }

    }

    public function display_countdown_timer_before_title(): void
    {
        global $product;
        if (!$product) {
            return;
        }
        $product_id = $product->get_id();
        $develux_timer_prioritise = 0;
        $develux_timer_select = get_post_meta($product_id, 'develux_timer_select', true);

        if($develux_timer_select){
            $develux_timer_prioritise = 1;
        }

        if ($develux_timer_prioritise) {
            $develux_timer_location = get_post_meta($develux_timer_select, 'develux_timer_location', true) ?: '';
            $develux_use_single_product_schedule = get_post_meta($develux_timer_select, 'develux_use_single_product_schedule', true);
            $develux_timer_display_on_card = get_post_meta( $develux_timer_select, 'develux_timer_display_on_card', true);
            if(!$develux_timer_display_on_card){
                return;
            }
            if ($develux_timer_location === 'before_product_title') {
                if($develux_use_single_product_schedule){
                    echo wp_kses(CountdownTimerGenerator::generate_countdown_timer($develux_timer_select,'','',$product_id), $this->allowed_html);
                }else{
                    $develux_timer_start_date = get_post_meta($develux_timer_select, 'develux_timer_start_date', true) ?? '';
                    $develux_timer_date = get_post_meta($develux_timer_select, 'develux_timer_date', true) ?? '';
                    echo wp_kses(CountdownTimerGenerator::generate_countdown_timer($develux_timer_select,$develux_timer_date,$develux_timer_start_date,$product_id), $this->allowed_html);
                }
            }
        } else {
            $timer_data = Timer_CPT_Query_Data::get_all_timers_id_bulk();
            echo wp_kses(
                Helper::display_countdown_timer($timer_data, $product_id, 'before_product_title'),
                $this->allowed_html);
        }

    }

    public function display_countdown_timer_after_title(): void
    {
        global $product;
        if (!$product) {
            return;
        }
        $product_id = $product->get_id();
        $develux_timer_prioritise = 0;
        $develux_timer_select = get_post_meta($product_id, 'develux_timer_select', true);

        if($develux_timer_select){
            $develux_timer_prioritise = 1;
        }
        if ($develux_timer_prioritise) {
            $develux_timer_location = get_post_meta( $develux_timer_select, 'develux_timer_location', true) ?: '';
            $develux_use_single_product_schedule = get_post_meta($develux_timer_select, 'develux_use_single_product_schedule', true);
            $develux_timer_display_on_card = get_post_meta( $develux_timer_select, 'develux_timer_display_on_card', true);
            if(!$develux_timer_display_on_card){
                return;
            }
            if ($develux_timer_location === 'after_product_title') {
                if($develux_use_single_product_schedule){
                    echo wp_kses(CountdownTimerGenerator::generate_countdown_timer($develux_timer_select,'','',$product_id), $this->allowed_html);
                }else{
                    $develux_timer_start_date = get_post_meta($develux_timer_select, 'develux_timer_start_date', true) ?? '';
                    $develux_timer_date = get_post_meta($develux_timer_select, 'develux_timer_date', true) ?? '';
                    echo wp_kses(CountdownTimerGenerator::generate_countdown_timer($develux_timer_select,$develux_timer_date,$develux_timer_start_date,$product_id), $this->allowed_html);
                }
            }
        } else {
            $timer_data = Timer_CPT_Query_Data::get_all_timers_id_bulk();
            echo wp_kses(
                Helper::display_countdown_timer($timer_data, $product_id, 'after_product_title'),
                $this->allowed_html);
        }

    }

    public function display_countdown_timer_before_loop_item(): void
    {
        global $product;
        if (!$product) {
            return;
        }
        $product_id = $product->get_id();
        $develux_timer_prioritise = 0;
        $develux_timer_select = get_post_meta($product_id, 'develux_timer_select', true);
        if($develux_timer_select){
            $develux_timer_prioritise = 1;
        }
        if ($develux_timer_prioritise) {
            $develux_timer_location = get_post_meta($develux_timer_select, 'develux_timer_location', true) ?: '';
            $develux_use_single_product_schedule = get_post_meta($develux_timer_select, 'develux_use_single_product_schedule', true);
            $develux_timer_display_on_card = get_post_meta( $develux_timer_select, 'develux_timer_display_on_card', true);
            if(!$develux_timer_display_on_card){
                return;
            }
            if ($develux_timer_location === 'before_product_card') {
               if($develux_use_single_product_schedule){
                   echo wp_kses(CountdownTimerGenerator::generate_countdown_timer($develux_timer_select,'','',$product_id), $this->allowed_html);
               }else{
                   $develux_timer_start_date = get_post_meta($develux_timer_select, 'develux_timer_start_date', true) ?? '';
                   $develux_timer_date = get_post_meta($develux_timer_select, 'develux_timer_date', true) ?? '';
                   echo wp_kses(CountdownTimerGenerator::generate_countdown_timer($develux_timer_select,$develux_timer_date,$develux_timer_start_date,$product_id), $this->allowed_html);
               }

            }
        } else {
            $timer_data = Timer_CPT_Query_Data::get_all_timers_id_bulk();
            echo wp_kses(Helper::display_countdown_timer($timer_data, $product_id, 'before_product_card'),
                $this->allowed_html);
        }

    }


}