<?php

namespace DEVELUXSCT\HTMLGenerators;
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class TemplateRenderer implements RendererInterface
{
    public $template_dir;

    public function __construct()
    {
        $this->template_dir = DEVELUXSCT_DWPC_PATH . 'templates/';
    }

    public function render($slug, $data = [])
    {
        // Prevent directory traversal attacks (disallow "../")
        if (strpos($slug, '..') !== false) {
            return ''; // Reject invalid paths
        }

        // Construct the full template path
        $template_path = $this->template_dir . DIRECTORY_SEPARATOR . $slug . '.php';

        // Ensure the file exists inside the intended directory
        if (file_exists($template_path) && is_readable($template_path)) {
            extract($data);
            ob_start();
            // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
            // nosemgrep: audit.php.lang.security.file.inclusion-arg
            include $template_path;
            return ob_get_clean();
        }

        return '';
    }


    public static function get_allowed_html(): array
    {
        return [
            'style' => ['class' => true, 'id' => true],
            'br' => ['class' => true],
            'pre' => ['class' => true],
            'hr' => ['class' => true],
            'b' => ['class' => true, 'id' => true, 'data-label-tab' => true],
            'svg' => [
                'viewbox' => true,
                'xmlns' => true,
                'class' => true,
                'width' => true,
                'height' => true,
                'fill' => true,
                'id' => true,
            ],
            'path' => [
                'd' => true,
                'fill-rule' => true,
                'clip-rule' => true,
                'fill' => true,
                'stroke' => true,
                'stroke-width' => true,
                'stroke-linecap' => true,
                'stroke-linejoin' => true,
                'stroke-dasharray' => true
            ],
            'circle' => [
                'cx' => true,
                'cy' => true,
                'r' => true,
                'fill' => true,
                'stroke' => true,
                'stroke-width' => true,
            ],
            'rect' => ['width' => true, 'height' => true, 'fill' => true, 'x' => true, 'y' => true, 'transform' => true],
            'g' => ['fill' => true],
            'clipPath' => ['id' => true],
            'defs' => ['id' => true],
            'fieldset' => [
                'class' => true,
                'id' => true,
                'style' => true,
                'data-component' => true,
                'data-subcomponent' => true,
            ],
            'legend' => ['class' => true, 'id' => true, 'style' => true],
            'label' => ['class' => true, 'id' => true, 'for' => true, 'data-develux-tooltip' => true],
            'i' => ['class' => true, 'id' => true],
            'button' => [
                'class' => true,
                'style' => true,
                'id' => true,
                'data-post-id' => true,
                'data-product-id' => true,
                'data-target-div' => true,
                'data-value-field-type' => true,
                'data-container' => true,
                'data-icon-key' => true,
                'data-property-key' => true,
                'data-value-key' => true,
                'data-link-key' => true,
                'data-update-text' => true,
                'type' => true
            ],
            'div' => [
                'class' => true,
                'id' => true,
                'style' => true,
                'data-develux-id' => true,
                'data-develux-size' => true,
                'data-develux-color' => true,
                'data-develux-collapse-after' => true,
                'data-label-id' => true,
                'data-dislocation' => true,
                'data-dots-dislocation' => true,
                'data-tab' => true,
                'data-animation' => true,
                'data-countdown' => true,
                'data-countdown-start' => true,
                'data-product-id' => true,
                'data-index' => true,
                'data-sale-start-in-days' => true,
                'data-sale-end-in-days' => true,
                'data-sale-start' => true,
                'data-sale-end' => true,
                'data-component' => true,
                'data-subcomponent' => true,
                'data-dot-style' => true,
                'data-dot-active-style' => true,
                'data-active-dot-border-color' => true,
                'data-default-dot-border-color' => true,
                'data-target-thumbnail' => true,
                'data-thumbnail' => true,
                'data-value' => true,

            ],
            'h1' => ['class' => true, 'id' => true, 'style' => true],
            'h2' => ['class' => true, 'id' => true, 'style' => true],
            'h3' => ['class' => true, 'id' => true, 'style' => true],
            'h4' => ['class' => true, 'id' => true, 'style' => true],
            'del' => ['class' => true, 'id' => true, 'aria-hidden' => true],
            'bdi' => ['class' => true, 'id' => true],
            'ins' => ['class' => true, 'id' => true, 'aria-hidden' => true],
            'a' => [
                'class' => true,
                'id' => true,
                'style' => true,
                'target' => true,
                'download' => true,
                'rel' => true,
                'href' => true,
                'title' => true,
                'data-custom-block-tab' => true,
                'data-post-id' => true,
                'data-tab' => true,
                'data-product_sku' => true,
                'data-product_id' => true,
            ],
            'span' => [
                'class' => true,
                'id' => true,
                'style' => true,
                'tabindex' => true,
                'aria-hidden' => true,
                'aria-label' => true,
                'aria-describedby' => true,
                'data-target' => true,
                'data-develux-tooltip' => true,
                'data-label-tab' => true,
                'data-dot-style' => true,
                'data-dot-active-style' => true,
                'data-active-dot-border-color' => true,
                'data-default-dot-border-color' => true,
                'data-target-thumbnail' => true,
                'data-thumbnail' => true,
                'data-diff-percent' => true,
                'data-diff-number' => true,
            ],
            'p' => [
                'class' => true,
                'id' => true,
                'style' => true,
                'data-id' => true,
                'data-thumbnail' => true,
                'data-currency-symbol' => true,
                'data-price' => true,
                'data-sale-price' => true,
                'data-name' => true,
                'data-nonce' => true,
                'data-subcomponent' => true
            ],
            'ul' => [
                'class' => true,
                'id' => true,
                'style' => true,
                'data-develux-properties-list-id' => true,
            ],
            'li' => [
                'class' => true,
                'id' => true,
                'style' => true
            ],
            'img' => [
                'class' => true,
                'id' => true,
                'src' => true,
                'alt' => true,
                'style' => true,
                'width' => true,
                'height' => true,
                'data-search' => true,
                'data-hide-search' => true,
                'data-thumbnail' => true,
            ],
            'form' => ['id' => true, 'class' => true, 'method' => true, 'data-url' => true],
            'textarea' => [
                'placeholder' => true,
                'class' => true,
                'id' => true,
                'data-target' => true,
                'data-property' => true,
                'data-unit' => true,
                'name' => true,
            ],
            'input' => [
                'checked' => true,
                'class' => true,
                'id' => true,
                'type' => true,
                'name' => true,
                'value' => true,
                'placeholder' => true,
                'min' => true,
                'max' => true,
                'step' => true,
                'required' => true,
                'data-depended-target-value' => true,
                'data-default-value' => true,
                'data-target' => true,
                'data-property' => true,
                'data-unit' => true,
                'data-target-color-a' => true,
                'data-direct-value-unchecked' => true,
                'data-direct-value-checked' => true,
            ],
            'select' => [
                'class' => true,
                'id' => true,
                'name' => true,
                'data-default-value' => true,
                'data-property' => true,
                'data-unit' => true,
                'data-target' => true,
            ],
            'option' => ['class' => true, 'value' => true, 'selected' => true],
        ];
    }

}