<?php

namespace DEVELUXSCT\HTMLGenerators;
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class SVG_Generator
{

    public static function get_allowed_svg_elements(): array
    {
        return [
            'span' => ['class' => true, 'id' => true],
            'b' => ['class' => true, 'id' => true],
            'svg' => [
                'viewbox' => true,
                'xmlns' => true,
                'class' => true,
                'width' => true,
                'height' => true,
                'fill' => true,
                'id' => true,
            ],
            'path' => [
                'd' => true,
                'fill-rule' => true,
                'clip-rule' => true,
                'fill' => true,
                'stroke' => true,
                'stroke-width' => true,
                'stroke-linecap' => true,
                'stroke-linejoin' => true,
                'stroke-dasharray' => true
            ],
            'circle' => [
                'cx' => true,
                'cy' => true,
                'r' => true,
                'fill' => true,
                'stroke' => true,
                'stroke-width' => true,
            ],
            'rect' => ['width' => true, 'height' => true, 'fill' => true, 'x' => true, 'y' => true, 'transform' => true],
            'g' => ['fill' => true],
            'clipPath' => ['id' => true],
            'defs' => ['id' => true],
        ];

    }

    public static function generate_single_edit_menu_icons(): array
    {
        return [
            'properties' => ['passive' => '<svg width="13" height="13" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11 12C11 13.1046 10.1046 14 9 14C7.89543 14 7 13.1046 7 12M11 12C11 10.8954 10.1046 10 9 10C7.89543 10 7 10.8954 7 12M11 12H20M7 12H4" stroke="#2271b1" stroke-width="1.6" stroke-linecap="round"/>
<path d="M13 18C13 19.1046 13.8954 20 15 20C16.1046 20 17 19.1046 17 18M13 18C13 16.8954 13.8954 16 15 16C16.1046 16 17 16.8954 17 18M13 18H4M17 18H20" stroke="#2271b1" stroke-width="1.6" stroke-linecap="round"/>
<path d="M13 6C13 7.10457 13.8954 8 15 8C16.1046 8 17 7.10457 17 6M13 6C13 4.89543 13.8954 4 15 4C16.1046 4 17 4.89543 17 6M13 6H4M17 6H20" stroke="#2271b1" stroke-width="1.6" stroke-linecap="round"/>
</svg>', 'active' => '<svg width="13" height="13" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11 12C11 13.1046 10.1046 14 9 14C7.89543 14 7 13.1046 7 12M11 12C11 10.8954 10.1046 10 9 10C7.89543 10 7 10.8954 7 12M11 12H20M7 12H4" stroke="#222222" stroke-width="1.6" stroke-linecap="round"/>
<path d="M13 18C13 19.1046 13.8954 20 15 20C16.1046 20 17 19.1046 17 18M13 18C13 16.8954 13.8954 16 15 16C16.1046 16 17 16.8954 17 18M13 18H4M17 18H20" stroke="#222222" stroke-width="1.6" stroke-linecap="round"/>
<path d="M13 6C13 7.10457 13.8954 8 15 8C16.1046 8 17 7.10457 17 6M13 6C13 4.89543 13.8954 4 15 4C16.1046 4 17 4.89543 17 6M13 6H4M17 6H20" stroke="#222222" stroke-width="1.6" stroke-linecap="round"/>
</svg>', 'active_white' => '<svg width="13" height="13" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11 12C11 13.1046 10.1046 14 9 14C7.89543 14 7 13.1046 7 12M11 12C11 10.8954 10.1046 10 9 10C7.89543 10 7 10.8954 7 12M11 12H20M7 12H4" stroke="white" stroke-width="1.6" stroke-linecap="round"/>
<path d="M13 18C13 19.1046 13.8954 20 15 20C16.1046 20 17 19.1046 17 18M13 18C13 16.8954 13.8954 16 15 16C16.1046 16 17 16.8954 17 18M13 18H4M17 18H20" stroke="white" stroke-width="1.6" stroke-linecap="round"/>
<path d="M13 6C13 7.10457 13.8954 8 15 8C16.1046 8 17 7.10457 17 6M13 6C13 4.89543 13.8954 4 15 4C16.1046 4 17 4.89543 17 6M13 6H4M17 6H20" stroke="white" stroke-width="1.6" stroke-linecap="round"/>
</svg>'],
            'label' => ['passive' => '<svg width="13" height="13" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.6716 3.92901L18.7426 5.34323L20.1569 12.4143L11.6716 20.8996L3.18629 12.4143L11.6716 3.92901Z" stroke="#808080" stroke-width="1.6" stroke-linejoin="round"/>
<circle cx="15.207" cy="8.87906" r="1" transform="rotate(45 15.207 8.87906)" fill="#808080"/>
</svg>', 'active' => '<svg width="13" height="13" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.1716 3.92901L18.2426 5.34323L19.6569 12.4143L11.1716 20.8996L2.68629 12.4143L11.1716 3.92901Z" stroke="#222222" stroke-width="1.6" stroke-linejoin="round"/>
<circle cx="14.707" cy="8.87881" r="1" transform="rotate(45 14.707 8.87881)" fill="#222222"/>
</svg>', 'active_white' => '<svg width="13" height="13" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.1716 3.92901L18.2426 5.34323L19.6569 12.4143L11.1716 20.8996L2.68629 12.4143L11.1716 3.92901Z" stroke="white" stroke-width="1.6" stroke-linejoin="round"/>
<circle cx="14.707" cy="8.87881" r="1" transform="rotate(45 14.707 8.87881)" fill="white"/>
</svg>'],
            'slider' => ['passive' => '<svg width="13" height="13" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7 6H12L17 6V18H7L7 6Z" stroke="#808080" stroke-width="1.6" stroke-linejoin="round"/>
<path d="M20 7.5V16.5" stroke="#808080" stroke-width="1.6" stroke-linecap="round"/>
<path d="M23 9L23 15" stroke="#808080" stroke-width="1.6" stroke-linecap="round"/>
<path d="M1 9L0.999999 15" stroke="#808080" stroke-width="1.6" stroke-linecap="round"/>
<path d="M4 7.5V16.5" stroke="#808080" stroke-width="1.6" stroke-linecap="round"/>
</svg>', 'active' => '<svg width="13" height="13" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7 6H12L17 6V18H7L7 6Z" stroke="#222222" stroke-width="1.6" stroke-linejoin="round"/>
<path d="M20 7.5V16.5" stroke="#222222" stroke-width="1.6" stroke-linecap="round"/>
<path d="M23 9L23 15" stroke="#222222" stroke-width="1.6" stroke-linecap="round"/>
<path d="M1 9L0.999999 15" stroke="#222222" stroke-width="1.6" stroke-linecap="round"/>
<path d="M4 7.5V16.5" stroke="#222222" stroke-width="1.6" stroke-linecap="round"/>
</svg>'],
            'switcher' => ['passive' => '<svg width="13" height="13" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.30078 8.3H16.6973V6.7H8.30078V8.3ZM16.6973 15.7H8.30078V17.3H16.6973V15.7ZM8.30078 15.7C6.25733 15.7 4.60078 14.0435 4.60078 12H3.00078C3.00078 14.9271 5.37367 17.3 8.30078 17.3V15.7ZM20.3973 12C20.3973 14.0435 18.7407 15.7 16.6973 15.7V17.3C19.6244 17.3 21.9973 14.9271 21.9973 12H20.3973ZM16.6973 8.3C18.7407 8.3 20.3973 9.95655 20.3973 12H21.9973C21.9973 9.07289 19.6244 6.7 16.6973 6.7V8.3ZM8.30078 6.7C5.37367 6.7 3.00078 9.07289 3.00078 12H4.60078C4.60078 9.95655 6.25733 8.3 8.30078 8.3V6.7Z" fill="#808080"/>
<circle cx="16.1772" cy="11.9995" r="2.25537" stroke="#808080" stroke-width="1.6"/>
</svg>', 'active' => '<svg width="13" height="13" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80078 8.3H16.1973V6.7H7.80078V8.3ZM16.1973 15.7H7.80078V17.3H16.1973V15.7ZM7.80078 15.7C5.75733 15.7 4.10078 14.0435 4.10078 12H2.50078C2.50078 14.9271 4.87367 17.3 7.80078 17.3V15.7ZM19.8973 12C19.8973 14.0435 18.2407 15.7 16.1973 15.7V17.3C19.1244 17.3 21.4973 14.9271 21.4973 12H19.8973ZM16.1973 8.3C18.2407 8.3 19.8973 9.95655 19.8973 12H21.4973C21.4973 9.07289 19.1244 6.7 16.1973 6.7V8.3ZM7.80078 6.7C4.87367 6.7 2.50078 9.07289 2.50078 12H4.10078C4.10078 9.95655 5.75733 8.3 7.80078 8.3V6.7Z" fill="black"/>
<circle cx="15.6772" cy="12" r="2.25537" stroke="black" stroke-width="1.6"/>
</svg>'],
            'timer' => ['passive' => '<svg width="13" height="13" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="13" r="7.16895" stroke="#808080" stroke-width="1.6"/>
<path d="M11.7861 3.50781V5.83032" stroke="#808080" stroke-width="1.6" stroke-linecap="round"/>
<path d="M10.1553 2.92188L13.416 2.92187" stroke="#808080" stroke-width="1.6" stroke-linecap="round"/>
<path d="M17.8564 8.12695L18.6826 7.30078" stroke="#808080" stroke-width="1.6" stroke-linecap="round"/>
<path d="M12.1045 13.2627L14.8165 10.5507" stroke="#808080" stroke-width="1.6" stroke-linecap="round"/>
</svg>', 'active' => '<svg width="13" height="13" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12.001" cy="13" r="7.16895" stroke="black" stroke-width="1.6"/>
<path d="M11.7871 3.50854V5.83105" stroke="black" stroke-width="1.6" stroke-linecap="round"/>
<path d="M10.1562 2.92236L13.417 2.92236" stroke="black" stroke-width="1.6" stroke-linecap="round"/>
<path d="M17.8574 8.12744L18.6836 7.30127" stroke="black" stroke-width="1.6" stroke-linecap="round"/>
<path d="M12.1055 13.2632L14.8175 10.5511" stroke="black" stroke-width="1.6" stroke-linecap="round"/>
</svg>'],
            'custom_block' => ['passive' => '<svg width="13" height="13" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.30957 7.04883V6.24883C3.86774 6.24883 3.50957 6.607 3.50957 7.04883H4.30957ZM10.1546 7.04883H10.9546C10.9546 6.607 10.5964 6.24883 10.1546 6.24883V7.04883ZM10.1546 12.8938V13.6938C10.5964 13.6938 10.9546 13.3357 10.9546 12.8938H10.1546ZM4.30957 12.8938H3.50957C3.50957 13.3357 3.86774 13.6938 4.30957 13.6938V12.8938ZM4.30957 7.84883H10.1546V6.24883H4.30957V7.84883ZM9.35457 7.04883V12.8938H10.9546V7.04883H9.35457ZM10.1546 12.0938H4.30957V13.6938H10.1546V12.0938ZM5.10957 12.8938V7.04883H3.50957V12.8938H5.10957Z" fill="#2271b1"/>
<path d="M14.8457 7.04883V6.24883C14.4039 6.24883 14.0457 6.607 14.0457 7.04883H14.8457ZM20.6907 7.04883H21.4907C21.4907 6.607 21.1325 6.24883 20.6907 6.24883V7.04883ZM20.6907 12.8938V13.6938C21.1325 13.6938 21.4907 13.3357 21.4907 12.8938H20.6907ZM14.8457 12.8938H14.0457C14.0457 13.3357 14.4039 13.6938 14.8457 13.6938V12.8938ZM14.8457 7.84883H20.6907V6.24883H14.8457V7.84883ZM19.8907 7.04883V12.8938H21.4907V7.04883H19.8907ZM20.6907 12.0938H14.8457V13.6938H20.6907V12.0938ZM15.6457 12.8938V7.04883H14.0457V12.8938H15.6457Z" fill="#2271b1"/>
<path d="M4.30957 16.9512H10.1546" stroke="#2271b1" stroke-width="1.6" stroke-linecap="round"/>
<path d="M14.8457 16.9512H20.6907" stroke="#2271b1" stroke-width="1.6" stroke-linecap="round"/>
</svg>', 'active' => '<svg width="13" height="13" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.80859 7.04883V6.24883C3.36677 6.24883 3.00859 6.607 3.00859 7.04883H3.80859ZM9.65359 7.04883H10.4536C10.4536 6.607 10.0954 6.24883 9.65359 6.24883V7.04883ZM9.65359 12.8938V13.6938C10.0954 13.6938 10.4536 13.3357 10.4536 12.8938H9.65359ZM3.80859 12.8938H3.00859C3.00859 13.3357 3.36677 13.6938 3.80859 13.6938V12.8938ZM3.80859 7.84883H9.65359V6.24883H3.80859V7.84883ZM8.85359 7.04883V12.8938H10.4536V7.04883H8.85359ZM9.65359 12.0938H3.80859V13.6938H9.65359V12.0938ZM4.60859 12.8938V7.04883H3.00859V12.8938H4.60859Z" fill="black"/>
<path d="M14.3457 7.04883V6.24883C13.9039 6.24883 13.5457 6.607 13.5457 7.04883H14.3457ZM20.1907 7.04883H20.9907C20.9907 6.607 20.6325 6.24883 20.1907 6.24883V7.04883ZM20.1907 12.8938V13.6938C20.6325 13.6938 20.9907 13.3357 20.9907 12.8938H20.1907ZM14.3457 12.8938H13.5457C13.5457 13.3357 13.9039 13.6938 14.3457 13.6938V12.8938ZM14.3457 7.84883H20.1907V6.24883H14.3457V7.84883ZM19.3907 7.04883V12.8938H20.9907V7.04883H19.3907ZM20.1907 12.0938H14.3457V13.6938H20.1907V12.0938ZM15.1457 12.8938V7.04883H13.5457V12.8938H15.1457Z" fill="black"/>
<path d="M3.80859 16.9509H9.65359" stroke="black" stroke-width="1.6" stroke-linecap="round"/>
<path d="M14.3457 16.9509H20.1907" stroke="black" stroke-width="1.6" stroke-linecap="round"/>
</svg>']
        ];
    }

    public static function generate_list_decoration_icons(): array
    {
        return [
            'circle' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.3661 12C15.3661 13.8591 13.8591 15.3661 12 15.3661C10.1409 15.3661 8.63386 13.8591 8.63386 12C8.63386 10.1409 10.1409 8.63386 12 8.63386C13.8591 8.63386 15.3661 10.1409 15.3661 12Z" stroke="#333333" stroke-width="1.6"/>
</svg>
',
            'disc' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.3661 12C15.3661 13.8591 13.8591 15.3661 12 15.3661C10.1409 15.3661 8.63386 13.8591 8.63386 12C8.63386 10.1409 10.1409 8.63386 12 8.63386C13.8591 8.63386 15.3661 10.1409 15.3661 12Z" fill="#333333" stroke="#333333" stroke-width="1.6"/>
</svg>',
            'decimal' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.0483 8.72727V16H11.0739V10.5455H11.0312L9.44034 11.4972V9.82102L11.2301 8.72727H13.0483ZM15.2598 16.1136C14.9851 16.1136 14.7496 16.0178 14.5531 15.826C14.359 15.6319 14.2631 15.3963 14.2654 15.1193C14.2631 14.8494 14.359 14.6186 14.5531 14.4268C14.7496 14.2351 14.9851 14.1392 15.2598 14.1392C15.5202 14.1392 15.7498 14.2351 15.9487 14.4268C16.1499 14.6186 16.2517 14.8494 16.2541 15.1193C16.2517 15.304 16.2032 15.4721 16.1085 15.6236C16.0162 15.7727 15.8954 15.8923 15.7463 15.9822C15.5971 16.0698 15.435 16.1136 15.2598 16.1136Z" fill="#333333"/>
</svg>',
            'none' => 'img',
        ];

    }

    public static function generate_text_editor_icons(): array
    {
        return [
            'normal' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<g clip-path="url(#clip0_62_11138)">
<path d="M18.9185 10.5L2.08175 10.5" stroke="black" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/>
</g>
<defs>
<clipPath id="clip0_62_11138">
<rect width="19" height="19" fill="white" transform="translate(0.5 0.5)"/>
</clipPath>
</defs>
</svg>',
            'italic' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<g clip-path="url(#clip0_62_11141)">
<path d="M6.0415 1.29199H16.3332" stroke="black" stroke-width="1.8" stroke-linecap="round"/>
<path d="M3.6665 18.708H13.9582" stroke="black" stroke-width="1.8" stroke-linecap="round"/>
<path d="M11.1875 1.29199L8.8125 18.7087" stroke="black" stroke-width="1.8" stroke-linecap="round"/>
</g>
<defs>
<clipPath id="clip0_62_11141">
<rect width="19" height="19" fill="white" transform="translate(0.5 0.5)"/>
</clipPath>
</defs>
</svg>',

        ];

    }

    public static function generate_button_icons(): array
    {
        return [
            'close' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 8L16 16M8 16L16 8" stroke="#D12B2E" stroke-width="1.6" stroke-linecap="round"/>
</svg>',
            'close_passive' => '<svg class="svg-passive-js" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 8L16 16M8 16L16 8" stroke="#DDDDDD" stroke-width="1.6" stroke-linecap="round"/>
</svg>',
            'close_active' => '<svg class="svg-active-js" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 8L16 16M8 16L16 8" stroke="#AAAAAA" stroke-width="1.6" stroke-linecap="round"/>
</svg>',
            'close_red' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 8L16 16M8 16L16 8" stroke="#D12B2E" stroke-width="1.6" stroke-linecap="round"/>
</svg>',
            'add' => '<svg class="svg-passive-js" width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7 1V13" stroke="#F0F0F0" stroke-width="1.6" stroke-linecap="round"/>
<path d="M1 7L13 7" stroke="#F0F0F0" stroke-width="1.6" stroke-linecap="round"/>
</svg>',
            'add_blue' => '<svg class="svg-passive-js" width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7 1V13" stroke="#2271b1" stroke-width="1.6" stroke-linecap="round"/>
<path d="M1 7L13 7" stroke="#2271b1" stroke-width="1.6" stroke-linecap="round"/>
</svg>',
            'add_white' => '<svg class="svg-active-js" width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7 1V13" stroke="#FFFFFF" stroke-width="1.6" stroke-linecap="round"/>
<path d="M1 7L13 7" stroke="#FFFFFF" stroke-width="1.6" stroke-linecap="round"/>
</svg>',
            'upload' => '<svg class="svg-passive-js" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.5657 6.12181C12.2533 5.8094 11.7467 5.8094 11.4343 6.12181L6.34315 11.213C6.03073 11.5254 6.03073 12.0319 6.34315 12.3444C6.65557 12.6568 7.1621 12.6568 7.47452 12.3444L12 7.81887L16.5255 12.3444C16.8379 12.6568 17.3444 12.6568 17.6569 12.3444C17.9693 12.0319 17.9693 11.5254 17.6569 11.213L12.5657 6.12181ZM11.2 6.6875V14.1875H12.8V6.6875H11.2ZM7 18.1125H17V16.5125H7V18.1125Z" fill="#F0F0F0"/>
</svg>',
            'upload_blue' => '<svg class="svg-passive-js" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.5657 6.12181C12.2533 5.8094 11.7467 5.8094 11.4343 6.12181L6.34315 11.213C6.03073 11.5254 6.03073 12.0319 6.34315 12.3444C6.65557 12.6568 7.1621 12.6568 7.47452 12.3444L12 7.81887L16.5255 12.3444C16.8379 12.6568 17.3444 12.6568 17.6569 12.3444C17.9693 12.0319 17.9693 11.5254 17.6569 11.213L12.5657 6.12181ZM11.2 6.6875V14.1875H12.8V6.6875H11.2ZM7 18.1125H17V16.5125H7V18.1125Z" fill="#2271b1"/>
</svg>',
            'upload_white' => '<svg class="svg-active-js"  width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.5657 6.12181C12.2533 5.8094 11.7467 5.8094 11.4343 6.12181L6.34315 11.213C6.03073 11.5254 6.03073 12.0319 6.34315 12.3444C6.65557 12.6568 7.1621 12.6568 7.47452 12.3444L12 7.81887L16.5255 12.3444C16.8379 12.6568 17.3444 12.6568 17.6569 12.3444C17.9693 12.0319 17.9693 11.5254 17.6569 11.213L12.5657 6.12181ZM11.2 6.6875V14.1875H12.8V6.6875H11.2ZM7 18.1125H17V16.5125H7V18.1125Z" fill="#FFFFFF"/>
</svg>',
            'replace' => '<svg class="svg-passive-js" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.94381 13.1116V7.4502H17.0535M6.94381 13.1116L8.96574 11.0897M6.94381 13.1116L4.92188 11.0897" stroke="#2271b1" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17.0523 10.8874V16.5488H6.94261M17.0523 10.8874L15.0304 12.9093M17.0523 10.8874L19.0742 12.9093" stroke="#2271b1" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
            'replace_white' => '<svg class="svg-active-js" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.94381 13.1116V7.4502H17.0535M6.94381 13.1116L8.96574 11.0897M6.94381 13.1116L4.92188 11.0897" stroke="#FFFFFF" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17.0523 10.8874V16.5488H6.94261M17.0523 10.8874L15.0304 12.9093M17.0523 10.8874L19.0742 12.9093" stroke="#FFFFFF" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
            'properties_styling' => '<svg class="svg-passive-js" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.6841 9.21387L13.2498 8.64818C12.9373 8.33576 12.4308 8.33576 12.1184 8.64818L12.6841 9.21387ZM15.0202 11.55L15.5859 12.1157C15.8983 11.8033 15.8983 11.2968 15.5859 10.9843L15.0202 11.55ZM5.14964 21.4206L4.58395 21.9863C4.89637 22.2987 5.4029 22.2987 5.71532 21.9863L5.14964 21.4206ZM2.81347 19.0845L2.24779 18.5188C1.93537 18.8312 1.93537 19.3377 2.24779 19.6502L2.81347 19.0845ZM12.1184 9.77955L14.4546 12.1157L15.5859 10.9843L13.2498 8.64818L12.1184 9.77955ZM14.4546 10.9843L4.58395 20.855L5.71532 21.9863L15.5859 12.1157L14.4546 10.9843ZM5.71532 20.855L3.37916 18.5188L2.24779 19.6502L4.58395 21.9863L5.71532 20.855ZM3.37916 19.6502L13.2498 9.77955L12.1184 8.64818L2.24779 18.5188L3.37916 19.6502Z" fill="black"/>
<path d="M12.6514 9.24609L13.2171 8.68041C12.9046 8.36799 12.3981 8.36799 12.0857 8.68041L12.6514 9.24609ZM14.9875 11.5823L15.5532 12.1479C15.8656 11.8355 15.8656 11.329 15.5532 11.0166L14.9875 11.5823ZM12.0373 14.5325L11.4716 15.0982C11.784 15.4106 12.2905 15.4106 12.6029 15.0982L12.0373 14.5325ZM9.7011 12.1964L9.13541 11.6307C8.82299 11.9431 8.82299 12.4496 9.13541 12.762L9.7011 12.1964ZM12.0857 9.81178L14.4218 12.1479L15.5532 11.0166L13.2171 8.68041L12.0857 9.81178ZM14.4218 11.0166L11.4716 13.9668L12.6029 15.0982L15.5532 12.1479L14.4218 11.0166ZM12.6029 13.9668L10.2668 11.6307L9.13541 12.762L11.4716 15.0982L12.6029 13.9668ZM10.2668 12.762L13.2171 9.81178L12.0857 8.68041L9.13541 11.6307L10.2668 12.762Z" fill="black"/>
<path d="M6.83624 4.48242L7.47964 6.22117L9.21838 6.86456L7.47964 7.50796L6.83624 9.2467L6.19285 7.50796L4.4541 6.86456L6.19285 6.22117L6.83624 4.48242Z" stroke="black" stroke-linejoin="round"/>
<path d="M18.0867 2.58008L18.9238 4.84237L21.1861 5.67949L18.9238 6.51662L18.0867 8.77891L17.2496 6.51662L14.9873 5.67949L17.2496 4.84237L18.0867 2.58008Z" stroke="black" stroke-linejoin="round"/>
<path d="M18.0273 14.0059L18.7499 15.9586L20.7026 16.6812L18.7499 17.4037L18.0273 19.3564L17.3048 17.4037L15.3521 16.6812L17.3048 15.9586L18.0273 14.0059Z" stroke="black" stroke-linejoin="round"/>
</svg>',
            'properties_styling_passive' => '<svg width="13" height="13" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.6841 9.21387L13.2498 8.64818C12.9373 8.33576 12.4308 8.33576 12.1184 8.64818L12.6841 9.21387ZM15.0202 11.55L15.5859 12.1157C15.8983 11.8033 15.8983 11.2968 15.5859 10.9843L15.0202 11.55ZM5.14964 21.4206L4.58395 21.9863C4.89637 22.2987 5.4029 22.2987 5.71532 21.9863L5.14964 21.4206ZM2.81347 19.0845L2.24779 18.5188C1.93537 18.8312 1.93537 19.3377 2.24779 19.6502L2.81347 19.0845ZM12.1184 9.77955L14.4546 12.1157L15.5859 10.9843L13.2498 8.64818L12.1184 9.77955ZM14.4546 10.9843L4.58395 20.855L5.71532 21.9863L15.5859 12.1157L14.4546 10.9843ZM5.71532 20.855L3.37916 18.5188L2.24779 19.6502L4.58395 21.9863L5.71532 20.855ZM3.37916 19.6502L13.2498 9.77955L12.1184 8.64818L2.24779 18.5188L3.37916 19.6502Z" fill="#2271b1"/>
<path d="M12.6514 9.24609L13.2171 8.68041C12.9046 8.36799 12.3981 8.36799 12.0857 8.68041L12.6514 9.24609ZM14.9875 11.5823L15.5532 12.1479C15.8656 11.8355 15.8656 11.329 15.5532 11.0166L14.9875 11.5823ZM12.0373 14.5325L11.4716 15.0982C11.784 15.4106 12.2905 15.4106 12.6029 15.0982L12.0373 14.5325ZM9.7011 12.1964L9.13541 11.6307C8.82299 11.9431 8.82299 12.4496 9.13541 12.762L9.7011 12.1964ZM12.0857 9.81178L14.4218 12.1479L15.5532 11.0166L13.2171 8.68041L12.0857 9.81178ZM14.4218 11.0166L11.4716 13.9668L12.6029 15.0982L15.5532 12.1479L14.4218 11.0166ZM12.6029 13.9668L10.2668 11.6307L9.13541 12.762L11.4716 15.0982L12.6029 13.9668ZM10.2668 12.762L13.2171 9.81178L12.0857 8.68041L9.13541 11.6307L10.2668 12.762Z" fill="#2271b1"/>
<path d="M6.83624 4.48242L7.47964 6.22117L9.21838 6.86456L7.47964 7.50796L6.83624 9.2467L6.19285 7.50796L4.4541 6.86456L6.19285 6.22117L6.83624 4.48242Z" stroke="#2271b1" stroke-linejoin="round"/>
<path d="M18.0867 2.58008L18.9238 4.84237L21.1861 5.67949L18.9238 6.51662L18.0867 8.77891L17.2496 6.51662L14.9873 5.67949L17.2496 4.84237L18.0867 2.58008Z" stroke="#2271b1" stroke-linejoin="round"/>
<path d="M18.0273 14.0059L18.7499 15.9586L20.7026 16.6812L18.7499 17.4037L18.0273 19.3564L17.3048 17.4037L15.3521 16.6812L17.3048 15.9586L18.0273 14.0059Z" stroke="#2271b1" stroke-linejoin="round"/>
</svg>',
            'properties_styling_active' => '<svg width="13" height="13" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.6841 9.21387L13.2498 8.64818C12.9373 8.33576 12.4308 8.33576 12.1184 8.64818L12.6841 9.21387ZM15.0202 11.55L15.5859 12.1157C15.8983 11.8033 15.8983 11.2968 15.5859 10.9843L15.0202 11.55ZM5.14964 21.4206L4.58395 21.9863C4.89637 22.2987 5.4029 22.2987 5.71532 21.9863L5.14964 21.4206ZM2.81347 19.0845L2.24779 18.5188C1.93537 18.8312 1.93537 19.3377 2.24779 19.6502L2.81347 19.0845ZM12.1184 9.77955L14.4546 12.1157L15.5859 10.9843L13.2498 8.64818L12.1184 9.77955ZM14.4546 10.9843L4.58395 20.855L5.71532 21.9863L15.5859 12.1157L14.4546 10.9843ZM5.71532 20.855L3.37916 18.5188L2.24779 19.6502L4.58395 21.9863L5.71532 20.855ZM3.37916 19.6502L13.2498 9.77955L12.1184 8.64818L2.24779 18.5188L3.37916 19.6502Z" fill="black"/>
<path d="M12.6514 9.24609L13.2171 8.68041C12.9046 8.36799 12.3981 8.36799 12.0857 8.68041L12.6514 9.24609ZM14.9875 11.5823L15.5532 12.1479C15.8656 11.8355 15.8656 11.329 15.5532 11.0166L14.9875 11.5823ZM12.0373 14.5325L11.4716 15.0982C11.784 15.4106 12.2905 15.4106 12.6029 15.0982L12.0373 14.5325ZM9.7011 12.1964L9.13541 11.6307C8.82299 11.9431 8.82299 12.4496 9.13541 12.762L9.7011 12.1964ZM12.0857 9.81178L14.4218 12.1479L15.5532 11.0166L13.2171 8.68041L12.0857 9.81178ZM14.4218 11.0166L11.4716 13.9668L12.6029 15.0982L15.5532 12.1479L14.4218 11.0166ZM12.6029 13.9668L10.2668 11.6307L9.13541 12.762L11.4716 15.0982L12.6029 13.9668ZM10.2668 12.762L13.2171 9.81178L12.0857 8.68041L9.13541 11.6307L10.2668 12.762Z" fill="black"/>
<path d="M6.83624 4.48242L7.47964 6.22117L9.21838 6.86456L7.47964 7.50796L6.83624 9.2467L6.19285 7.50796L4.4541 6.86456L6.19285 6.22117L6.83624 4.48242Z" stroke="black" stroke-linejoin="round"/>
<path d="M18.0867 2.58008L18.9238 4.84237L21.1861 5.67949L18.9238 6.51662L18.0867 8.77891L17.2496 6.51662L14.9873 5.67949L17.2496 4.84237L18.0867 2.58008Z" stroke="black" stroke-linejoin="round"/>
<path d="M18.0273 14.0059L18.7499 15.9586L20.7026 16.6812L18.7499 17.4037L18.0273 19.3564L17.3048 17.4037L15.3521 16.6812L17.3048 15.9586L18.0273 14.0059Z" stroke="black" stroke-linejoin="round"/>
</svg>',
            'properties_styling_white' => '<svg class="svg-active-js" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.6841 9.21387L13.2498 8.64818C12.9373 8.33576 12.4308 8.33576 12.1184 8.64818L12.6841 9.21387ZM15.0202 11.55L15.5859 12.1157C15.8983 11.8033 15.8983 11.2968 15.5859 10.9843L15.0202 11.55ZM5.14964 21.4206L4.58395 21.9863C4.89637 22.2987 5.4029 22.2987 5.71532 21.9863L5.14964 21.4206ZM2.81347 19.0845L2.24779 18.5188C1.93537 18.8312 1.93537 19.3377 2.24779 19.6502L2.81347 19.0845ZM12.1184 9.77955L14.4546 12.1157L15.5859 10.9843L13.2498 8.64818L12.1184 9.77955ZM14.4546 10.9843L4.58395 20.855L5.71532 21.9863L15.5859 12.1157L14.4546 10.9843ZM5.71532 20.855L3.37916 18.5188L2.24779 19.6502L4.58395 21.9863L5.71532 20.855ZM3.37916 19.6502L13.2498 9.77955L12.1184 8.64818L2.24779 18.5188L3.37916 19.6502Z" fill="white"/>
<path d="M12.6514 9.24609L13.2171 8.68041C12.9046 8.36799 12.3981 8.36799 12.0857 8.68041L12.6514 9.24609ZM14.9875 11.5823L15.5532 12.1479C15.8656 11.8355 15.8656 11.329 15.5532 11.0166L14.9875 11.5823ZM12.0373 14.5325L11.4716 15.0982C11.784 15.4106 12.2905 15.4106 12.6029 15.0982L12.0373 14.5325ZM9.7011 12.1964L9.13541 11.6307C8.82299 11.9431 8.82299 12.4496 9.13541 12.762L9.7011 12.1964ZM12.0857 9.81178L14.4218 12.1479L15.5532 11.0166L13.2171 8.68041L12.0857 9.81178ZM14.4218 11.0166L11.4716 13.9668L12.6029 15.0982L15.5532 12.1479L14.4218 11.0166ZM12.6029 13.9668L10.2668 11.6307L9.13541 12.762L11.4716 15.0982L12.6029 13.9668ZM10.2668 12.762L13.2171 9.81178L12.0857 8.68041L9.13541 11.6307L10.2668 12.762Z" fill="white"/>
<path d="M6.83624 4.48242L7.47964 6.22117L9.21838 6.86456L7.47964 7.50796L6.83624 9.2467L6.19285 7.50796L4.4541 6.86456L6.19285 6.22117L6.83624 4.48242Z" stroke="white" stroke-linejoin="round"/>
<path d="M18.0867 2.58008L18.9238 4.84237L21.1861 5.67949L18.9238 6.51662L18.0867 8.77891L17.2496 6.51662L14.9873 5.67949L17.2496 4.84237L18.0867 2.58008Z" stroke="white" stroke-linejoin="round"/>
<path d="M18.0273 14.0059L18.7499 15.9586L20.7026 16.6812L18.7499 17.4037L18.0273 19.3564L17.3048 17.4037L15.3521 16.6812L17.3048 15.9586L18.0273 14.0059Z" stroke="white" stroke-linejoin="round"/>
</svg>',
            'arrow_up' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 9.5L7 14.5H17L12 9.5Z" fill="black"/>
</svg>',
            'arrow_down' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 14.5L7 9.5H17L12 14.5Z" fill="black"/>
</svg>', 'copy' => '<svg class="svg-passive-js" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6 5H10.6667L15.3333 5V16.2H6L6 5Z" stroke="#222222" stroke-width="1.6" stroke-linejoin="round"/>
<path d="M8.80078 16.2V19H13.4674H18.1341V7.8H15.3341" stroke="#222222" stroke-width="1.6" stroke-linejoin="round"/>
</svg>',
            'copy_white' => '<svg class="svg-active-js" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6 5H10.6667L15.3333 5V16.2H6L6 5Z" stroke="#FFFFFF" stroke-width="1.6" stroke-linejoin="round"/>
<path d="M8.80078 16.2V19H13.4674H18.1341V7.8H15.3341" stroke="#FFFFFF" stroke-width="1.6" stroke-linejoin="round"/>
</svg>',
            'info' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.2591 10.323V15.9957H12.8324V10.323H11.2591Z" fill="black"/>
<path d="M11.4474 9.35909C11.6149 9.5142 11.8155 9.59176 12.0494 9.59176C12.2833 9.59176 12.4828 9.5142 12.6477 9.35909C12.8152 9.20152 12.8989 9.01316 12.8989 8.79403C12.8989 8.57737 12.8152 8.39148 12.6477 8.23636C12.4828 8.07879 12.2833 8 12.0494 8C11.8155 8 11.6149 8.07879 11.4474 8.23636C11.2825 8.39148 11.2 8.57737 11.2 8.79403C11.2 9.01316 11.2825 9.20152 11.4474 9.35909Z" fill="black"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M4 12C4 7.584 7.584 4 12 4C16.416 4 20 7.584 20 12C20 16.416 16.416 20 12 20C7.584 20 4 16.416 4 12ZM5.6 12C5.6 15.528 8.472 18.4 12 18.4C15.528 18.4 18.4 15.528 18.4 12C18.4 8.472 15.528 5.6 12 5.6C8.472 5.6 5.6 8.472 5.6 12Z" fill="black"/>
</svg>',
            'info_purple' => '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.25909 6.32301V11.9957H8.83239V6.32301H7.25909Z" fill="#2271b1"/>
<path d="M7.44744 5.35909C7.61487 5.5142 7.81553 5.59176 8.04943 5.59176C8.28333 5.59176 8.48277 5.5142 8.64773 5.35909C8.81515 5.20152 8.89886 5.01316 8.89886 4.79403C8.89886 4.57737 8.81515 4.39148 8.64773 4.23636C8.48277 4.07879 8.28333 4 8.04943 4C7.81553 4 7.61487 4.07879 7.44744 4.23636C7.28248 4.39148 7.2 4.57737 7.2 4.79403C7.2 5.01316 7.28248 5.20152 7.44744 5.35909Z" fill="#2271b1"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M0 8C0 3.584 3.584 0 8 0C12.416 0 16 3.584 16 8C16 12.416 12.416 16 8 16C3.584 16 0 12.416 0 8ZM1.6 8C1.6 11.528 4.472 14.4 8 14.4C11.528 14.4 14.4 11.528 14.4 8C14.4 4.472 11.528 1.6 8 1.6C4.472 1.6 1.6 4.472 1.6 8Z" fill="#2271b1"/>
</svg>'
        ];

    }

    public static function generate_gradient_types_icons(): array
    {
        return [
            'radial' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="8" stroke="black" stroke-width="1.6"/>
<circle cx="12" cy="12" r="4" stroke="black" stroke-width="1.6"/>
</svg>',
            'conic' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 3L21 12L12 21L3 12L12 3Z" stroke="black" stroke-width="1.6"/>
</svg>',
            'left' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.43431 11.4343C3.1219 11.7467 3.1219 12.2533 3.43431 12.5657L8.52548 17.6569C8.8379 17.9693 9.34443 17.9693 9.65685 17.6569C9.96927 17.3444 9.96927 16.8379 9.65685 16.5255L5.13137 12L9.65685 7.47452C9.96927 7.1621 9.96927 6.65557 9.65685 6.34315C9.34444 6.03073 8.8379 6.03073 8.52548 6.34315L3.43431 11.4343ZM20 12.8C20.4418 12.8 20.8 12.4418 20.8 12C20.8 11.5582 20.4418 11.2 20 11.2V12.8ZM4 12.8L20 12.8V11.2L4 11.2L4 12.8Z" fill="black"/>
</svg>',
            'right' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.5657 12.5657C20.8781 12.2533 20.8781 11.7467 20.5657 11.4343L15.4745 6.34315C15.1621 6.03073 14.6556 6.03073 14.3431 6.34315C14.0307 6.65557 14.0307 7.1621 14.3431 7.47452L18.8686 12L14.3431 16.5255C14.0307 16.8379 14.0307 17.3444 14.3431 17.6569C14.6556 17.9693 15.1621 17.9693 15.4745 17.6569L20.5657 12.5657ZM4 11.2C3.55817 11.2 3.2 11.5582 3.2 12C3.2 12.4418 3.55817 12.8 4 12.8L4 11.2ZM20 11.2L4 11.2L4 12.8L20 12.8V11.2Z" fill="black"/>
</svg>',
            'top' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.5657 3.43431C12.2533 3.1219 11.7467 3.1219 11.4343 3.43431L6.34315 8.52548C6.03073 8.8379 6.03073 9.34443 6.34315 9.65685C6.65557 9.96927 7.1621 9.96927 7.47452 9.65685L12 5.13137L16.5255 9.65685C16.8379 9.96927 17.3444 9.96927 17.6569 9.65685C17.9693 9.34443 17.9693 8.8379 17.6569 8.52548L12.5657 3.43431ZM11.2 20C11.2 20.4418 11.5582 20.8 12 20.8C12.4418 20.8 12.8 20.4418 12.8 20H11.2ZM11.2 4V20H12.8V4H11.2Z" fill="black"/>
</svg>',
            'bottom' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.4343 20.5657C11.7467 20.8781 12.2533 20.8781 12.5657 20.5657L17.6569 15.4745C17.9693 15.1621 17.9693 14.6556 17.6569 14.3431C17.3444 14.0307 16.8379 14.0307 16.5255 14.3431L12 18.8686L7.47452 14.3431C7.1621 14.0307 6.65557 14.0307 6.34315 14.3431C6.03073 14.6556 6.03073 15.1621 6.34315 15.4745L11.4343 20.5657ZM12.8 4C12.8 3.55817 12.4418 3.2 12 3.2C11.5582 3.2 11.2 3.55817 11.2 4H12.8ZM12.8 20V4H11.2V20H12.8Z" fill="black"/>
</svg>',
            'top_left_bottom_right' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17.6562 18.4567C18.0981 18.4567 18.4562 18.0986 18.4562 17.6567L18.4563 10.4567C18.4563 10.0149 18.0981 9.65674 17.6563 9.65674C17.2144 9.65674 16.8563 10.0149 16.8563 10.4567L16.8563 16.8567L10.4563 16.8567C10.0144 16.8567 9.65625 17.2149 9.65625 17.6567C9.65625 18.0986 10.0144 18.4567 10.4563 18.4567L17.6562 18.4567ZM6.90823 5.77734C6.59581 5.46492 6.08928 5.46493 5.77686 5.77734C5.46444 6.08976 5.46444 6.5963 5.77686 6.90871L6.90823 5.77734ZM18.2219 17.0911L6.90823 5.77734L5.77686 6.90871L17.0906 18.2224L18.2219 17.0911Z" fill="black"/>
</svg>',
            'top_right_bottom_left' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5.54375 17.6567C5.54375 18.0986 5.90192 18.4567 6.34375 18.4567L13.5437 18.4567C13.9856 18.4567 14.3438 18.0986 14.3438 17.6567C14.3438 17.2149 13.9856 16.8567 13.5437 16.8567L7.14375 16.8567L7.14375 10.4567C7.14375 10.0149 6.78558 9.65674 6.34375 9.65674C5.90192 9.65674 5.54375 10.0149 5.54375 10.4567L5.54375 17.6567ZM18.2231 6.90872C18.5356 6.5963 18.5356 6.08977 18.2231 5.77735C17.9107 5.46493 17.4042 5.46493 17.0918 5.77735L18.2231 6.90872ZM6.90944 18.2224L18.2231 6.90872L17.0918 5.77735L5.77806 17.0911L6.90944 18.2224Z" fill="black"/>
</svg>',
        ];
    }

    public static function generate_positioning_icons(): array
    {
        return [
            'top_left' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 4.8H16V3.2H8V4.8ZM19.2 8V16H20.8V8H19.2ZM16 19.2H8V20.8H16V19.2ZM4.8 16V8H3.2V16H4.8ZM8 19.2C6.23269 19.2 4.8 17.7673 4.8 16H3.2C3.2 18.651 5.34903 20.8 8 20.8V19.2ZM19.2 16C19.2 17.7673 17.7673 19.2 16 19.2V20.8C18.651 20.8 20.8 18.651 20.8 16H19.2ZM16 4.8C17.7673 4.8 19.2 6.23269 19.2 8H20.8C20.8 5.34903 18.651 3.2 16 3.2V4.8ZM8 3.2C5.34903 3.2 3.2 5.34903 3.2 8H4.8C4.8 6.23269 6.23269 4.8 8 4.8V3.2Z" fill="#B3B3B3"/>
<circle cx="5" cy="5" r="3" fill="#333333"/>
</svg>',
            'top_center' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 4.8H16V3.2H8V4.8ZM19.2 8V16H20.8V8H19.2ZM16 19.2H8V20.8H16V19.2ZM4.8 16V8H3.2V16H4.8ZM8 19.2C6.23269 19.2 4.8 17.7673 4.8 16H3.2C3.2 18.651 5.34903 20.8 8 20.8V19.2ZM19.2 16C19.2 17.7673 17.7673 19.2 16 19.2V20.8C18.651 20.8 20.8 18.651 20.8 16H19.2ZM16 4.8C17.7673 4.8 19.2 6.23269 19.2 8H20.8C20.8 5.34903 18.651 3.2 16 3.2V4.8ZM8 3.2C5.34903 3.2 3.2 5.34903 3.2 8H4.8C4.8 6.23269 6.23269 4.8 8 4.8V3.2Z" fill="#B3B3B3"/>
<circle cx="12" cy="4" r="3" fill="#333333"/>
</svg>',
            'top_right' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 4.8H16V3.2H8V4.8ZM19.2 8V16H20.8V8H19.2ZM16 19.2H8V20.8H16V19.2ZM4.8 16V8H3.2V16H4.8ZM8 19.2C6.23269 19.2 4.8 17.7673 4.8 16H3.2C3.2 18.651 5.34903 20.8 8 20.8V19.2ZM19.2 16C19.2 17.7673 17.7673 19.2 16 19.2V20.8C18.651 20.8 20.8 18.651 20.8 16H19.2ZM16 4.8C17.7673 4.8 19.2 6.23269 19.2 8H20.8C20.8 5.34903 18.651 3.2 16 3.2V4.8ZM8 3.2C5.34903 3.2 3.2 5.34903 3.2 8H4.8C4.8 6.23269 6.23269 4.8 8 4.8V3.2Z" fill="#B3B3B3"/>
<circle cx="19" cy="5" r="3" fill="#333333"/>
</svg>',
        ];

    }

    public static function generate_border_icons(): array
    {
        return [
            'solid' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.833 12H4" stroke="black" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/>
</svg>
', 'solid_double' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.833 9.5H4" stroke="black" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.833 14.5H4" stroke="black" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
            'dotted' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="6.39961" cy="12" r="1.8" fill="#222222"/>
<circle cx="11.9992" cy="12" r="1.8" fill="#222222"/>
<circle cx="17.5988" cy="12" r="1.8" fill="#222222"/>
</svg>',
            'dashed' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.833 12H4" stroke="black" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" stroke-dasharray="3.2 3.2"/>
</svg>',
            'dashed_double' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.833 9.5H4" stroke="black" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" stroke-dasharray="3.2 3.2"/>
<path d="M20.833 14.5H4" stroke="black" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" stroke-dasharray="3.2 3.2"/>
</svg>',
            'inset' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.417 14.4226H3.58398" stroke="black" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17.9529 9.57739H6.04883" stroke="black" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/>
</svg>'
        ];
    }

    public static function generate_pseudo_element_icons(): array
    {
        return [
            'rectangle' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect x="2.875" y="2.875" width="14.25" height="14.25" fill="#222222"/>
</svg>',
            'flag' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M17.125 17.125V2.875L2.875 17.125H17.125Z" fill="#222222"/>
</svg>',
            'flag_rev' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M3 21V3L21 21H3Z" fill="#222222"/>
</svg>',
            'flag_top_left' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M3 3V21L21 3H3Z" fill="#222222"/>
</svg>',
            'flag_right' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.36364 12.5L17 3H7V22H17L8.36364 12.5Z" fill="#333333"/>
</svg>
',
            'flag_left' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.6364 12.5L7 3H17V22H7L15.6364 12.5Z" fill="#333333"/>
</svg>',
            'flag_top' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 16.1364L2.5 7.5V17.5H21.5V7.5L12 16.1364Z" fill="#333333"/>
</svg>
',
            'flag_bottom' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 8.86364L2.5 17.5V7.5H21.5V17.5L12 8.86364Z" fill="#333333"/>
</svg>',
            'bookmark' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2.87503 9.99999L10 2.875L17.125 9.99999L10 17.125L2.87503 9.99999Z" fill="#222222"/>
</svg>',
            'triangle' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<g clip-path="url(#clip0_143_6861)">
<path d="M18.5 11L3.5 19.5L3.5 2.5L18.5 11Z" fill="#333333"/>
</g>
<defs>
<clipPath id="clip0_143_6861">
<rect width="19" height="19" fill="white" transform="translate(0.5 0.5)"/>
</clipPath>
</defs>
</svg>',
            'arrow_left' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<g clip-path="url(#clip0_143_6123)">
<path d="M3.5 11L18.5 19.5L18.5 2.5L3.5 11Z" fill="#333333"/>
</g>
<defs>
<clipPath id="clip0_143_6123">
<rect width="19" height="19" fill="white" transform="translate(0.5 0.5)"/>
</clipPath>
</defs>
</svg>',
        ];
    }

    public static function generate_previewer_icons(): array
    {
        return [
            'show' => '<svg width="13" height="13" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="10" cy="10" r="2.5" stroke="#2271b1" stroke-width="1.33333"/>
<path d="M18.3333 10.0002C16.25 13.3335 14.3044 15.4168 9.99999 15.4168C5.69558 15.4168 3.74999 13.3335 1.66666 10.0002C3.33332 6.66683 5.83332 4.5835 9.99999 4.5835C14.1667 4.5835 16.6667 6.66683 18.3333 10.0002Z" stroke="#2271b1" stroke-width="1.33333" stroke-linejoin="round"/>
</svg>',
            'show_active' => '<svg width="13" height="13" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="10" cy="10" r="2.5" stroke="#000000" stroke-width="1.33333"/>
<path d="M18.3333 10.0002C16.25 13.3335 14.3044 15.4168 9.99999 15.4168C5.69558 15.4168 3.74999 13.3335 1.66666 10.0002C3.33332 6.66683 5.83332 4.5835 9.99999 4.5835C14.1667 4.5835 16.6667 6.66683 18.3333 10.0002Z" stroke="#000000" stroke-width="1.33333" stroke-linejoin="round"/>
</svg>',
            'hide' => '<svg width="13" height="13" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="10" cy="10" r="2.5" stroke="#333333" stroke-width="1.33333"/>
<path d="M14 5.4051C12.8685 4.8715 11.5492 4.58325 9.99935 4.58325C5.83268 4.58325 3.33268 6.66659 1.66602 9.99992C2.77706 11.7776 3.84894 13.1998 5.2603 14.14M16 6.76298C16.9315 7.6267 17.6934 8.72136 18.3327 9.99992C16.2493 13.3333 14.3038 15.4166 9.99935 15.4166C8.92453 15.4166 7.99678 15.2867 7.17724 15.0399" stroke="#333333" stroke-width="1.33333" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.5 4L3.5 15.5" stroke="#333333" stroke-width="1.6" stroke-linecap="round"/>
</svg>',
            'trey' => '<svg width="13" height="13" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect width="20" height="20" rx="10" fill="#F5F5F5"/>
<path d="M11.5 13L8.5 10L11.5 7" stroke="black" stroke-width="0.8" stroke-linecap="round"/>
</svg>'
        ];

    }

    public static function generate_slider_navigation_icons(): array
    {
        return [
            'classic_arrow' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16.8984 10.5657C17.2108 10.2533 17.2108 9.74673 16.8984 9.43432L11.8072 4.34315C11.4948 4.03073 10.9882 4.03073 10.6758 4.34315C10.3634 4.65557 10.3634 5.1621 10.6758 5.47452L15.2013 10L10.6758 14.5255C10.3634 14.8379 10.3634 15.3444 10.6758 15.6569C10.9882 15.9693 11.4948 15.9693 11.8072 15.6569L16.8984 10.5657ZM3.66602 9.2C3.22419 9.2 2.86602 9.55817 2.86602 10C2.86602 10.4418 3.22419 10.8 3.66602 10.8L3.66602 9.2ZM16.3327 9.2L3.66602 9.2L3.66602 10.8L16.3327 10.8V9.2Z" fill="black"/>
</svg>',
            'double_arrow' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.3535 8.02084H3.66602M14.3535 11.9792H3.66602M12.4245 6.02881L16.2105 10L12.4245 14.0383" stroke="black" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
            'triple_arrow' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.3535 8.02084H3.66602M14.3535 11.9792H3.66602M12.4245 6.02881L16.2105 10M16.2105 10L12.4245 14.0383M16.2105 10H3.66602" stroke="black" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
            'angle' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.625 5.25L12.375 10L7.625 14.75" stroke="black" stroke-width="1.6" stroke-linecap="round"/>
</svg>',
            'double_angle' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5.75781 5.25L10.5078 10L5.75781 14.75" stroke="black" stroke-width="1.6" stroke-linecap="round"/>
<path d="M9.49219 5.25L14.2422 10L9.49219 14.75" stroke="black" stroke-width="1.6" stroke-linecap="round"/>
</svg>
',
            'heavy_angle' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.16992 14.75L10.9199 10L6.16992 5.25H9.08084L13.8308 10L9.08084 14.75H6.16992Z" fill="black"/>
</svg>
'
        ];

    }

    public static function generate_writing_mode_icons(): array
    {
        return [
            'horizontal_tb' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.5657 12.5657C20.8781 12.2533 20.8781 11.7467 20.5657 11.4343L15.4745 6.34315C15.1621 6.03073 14.6556 6.03073 14.3431 6.34315C14.0307 6.65557 14.0307 7.1621 14.3431 7.47452L18.8686 12L14.3431 16.5255C14.0307 16.8379 14.0307 17.3444 14.3431 17.6569C14.6556 17.9693 15.1621 17.9693 15.4745 17.6569L20.5657 12.5657ZM4 11.2C3.55817 11.2 3.2 11.5582 3.2 12C3.2 12.4418 3.55817 12.8 4 12.8L4 11.2ZM20 11.2L4 11.2L4 12.8L20 12.8V11.2Z" fill="black"/>
</svg>',
            'vertical_rl' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.3187 19.7257C15.4945 19.9086 15.7143 20 15.978 20C16.2564 20 16.4835 19.9086 16.6593 19.7257C16.8352 19.5429 16.9231 19.3219 16.9231 19.0629V5.73714H21.0989C21.348 5.73714 21.5604 5.66095 21.7363 5.50857C21.9121 5.35619 22 5.14286 22 4.86857C22 4.60952 21.9121 4.40381 21.7363 4.25143C21.5604 4.08381 21.348 4 21.0989 4H10.8791C10.63 4 10.4176 4.08381 10.2418 4.25143C10.0806 4.40381 10 4.60952 10 4.86857C10 5.12762 10.0806 5.34095 10.2418 5.50857C10.4176 5.66095 10.63 5.73714 10.8791 5.73714H15.0549V19.0629C15.0549 19.3219 15.1429 19.5429 15.3187 19.7257Z" fill="black"/>
<path d="M8.65241 5.71194C8.71768 5.75327 8.7751 5.80864 8.82136 5.87483C8.86761 5.94103 8.90178 6.01673 8.92187 6.09756C8.94197 6.1784 8.94759 6.26274 8.93842 6.34571C8.92925 6.42869 8.90546 6.50864 8.86844 6.58092L8.86508 6.5875L7.37508 9.41774C7.33758 9.48897 7.28786 9.55109 7.22876 9.60055C7.16967 9.65 7.10235 9.68583 7.03066 9.70598C6.95896 9.72613 6.8843 9.73021 6.81092 9.71798C6.73755 9.70576 6.6669 9.67747 6.60302 9.63473C6.53913 9.59199 6.48326 9.53565 6.43859 9.4689C6.39392 9.40216 6.36132 9.32633 6.34267 9.24574C6.32401 9.16515 6.31966 9.08138 6.32986 8.99921C6.34006 8.91705 6.36461 8.8381 6.40212 8.76686L7.32924 7.00588C4.88504 7.53932 3.11473 9.9198 3.12696 12.7864C3.13027 13.5638 3.2701 14.3344 3.53847 15.0541C3.80685 15.7738 4.19851 16.4285 4.6911 16.9809C5.18369 17.5333 5.76755 17.9725 6.40935 18.2735C7.05116 18.5744 7.73834 18.7312 8.43165 18.735C8.50586 18.7351 8.57945 18.7517 8.6482 18.7838C8.71695 18.8158 8.77952 18.8627 8.83232 18.9217C8.88511 18.9808 8.9271 19.0508 8.95587 19.1278C8.98465 19.2048 8.99964 19.2873 8.99999 19.3705C9.00035 19.4537 8.98606 19.536 8.95794 19.6127C8.92982 19.6894 8.88842 19.759 8.83613 19.8175C8.78383 19.876 8.72166 19.9222 8.65318 19.9535C8.58469 19.9848 8.51124 20.0006 8.43703 20C6.88934 19.991 5.39146 19.3544 4.22008 18.2075C3.04869 17.0607 2.28295 15.4812 2.06429 13.7608C1.84564 12.0404 2.18884 10.2954 3.03051 8.84798C3.87218 7.4006 5.15545 6.3487 6.64327 5.88657L5.53152 5.18254C5.46675 5.14153 5.4097 5.0867 5.36363 5.02116C5.31756 4.95563 5.28336 4.88069 5.26299 4.80061C5.24261 4.72053 5.23647 4.63689 5.24491 4.55446C5.25334 4.47203 5.27619 4.39242 5.31215 4.32019L5.31557 4.3135C5.38919 4.1698 5.51063 4.06497 5.65356 4.02173C5.79649 3.97849 5.94939 4.00031 6.07914 4.08248L8.65241 5.71194Z" fill="black"/>
</svg>',
            'upright' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.3192 19.7257C15.495 19.9086 15.7148 20 15.9785 20C16.2569 20 16.484 19.9086 16.6599 19.7257C16.8357 19.5429 16.9236 19.3219 16.9236 19.0629V5.73714H21.0994C21.3485 5.73714 21.5609 5.66095 21.7368 5.50857C21.9126 5.35619 22.0005 5.14286 22.0005 4.86857C22.0005 4.60952 21.9126 4.40381 21.7368 4.25143C21.5609 4.08381 21.3485 4 21.0994 4H10.8796C10.6305 4 10.4181 4.08381 10.2423 4.25143C10.0811 4.40381 10.0005 4.60952 10.0005 4.86857C10.0005 5.12762 10.0811 5.34095 10.2423 5.50857C10.4181 5.66095 10.6305 5.73714 10.8796 5.73714H15.0555V19.0629C15.0555 19.3219 15.1434 19.5429 15.3192 19.7257Z" fill="black"/>
<path d="M6.53271 19.6499C6.81155 19.8501 7.18701 19.8501 7.46584 19.6499L10.4658 17.4961C10.8248 17.2384 10.9068 16.7385 10.6491 16.3796C10.3915 16.0207 9.89162 15.9387 9.53271 16.1963L7.79928 17.4409L7.79928 5.00005C7.79928 4.55822 7.44111 4.20005 6.99928 4.20005C6.55745 4.20005 6.19928 4.55822 6.19928 5.00005L6.19928 17.4409L4.46584 16.1963C4.10694 15.9387 3.6071 16.0207 3.34942 16.3796C3.09174 16.7385 3.17381 17.2384 3.53271 17.4961L6.53271 19.6499Z" fill="black"/>
</svg>'
        ];

    }

}
