<?php

namespace DEVELUXSCT\HTMLGenerators;
if (!defined('ABSPATH')) {
    exit;
}

use DEVELUXSCT\Metaboxes\Helper;

class CountdownTimerGenerator
{
    public static function generate_countdown_timer($post_id, $global_sale_end = '', $global_sale_start = '', $product_id = '', $is_single = false): string
    {
        if (!$global_sale_end && !$product_id) {
            $sale_start = esc_attr(get_post_meta($post_id, '_sale_price_dates_from', true)) ?? '';
            $sale_end = esc_attr(get_post_meta($post_id, '_sale_price_dates_to', true)) ?? '';
            if (!($sale_start && $sale_end)) {
                return '';
            }
        } elseif (!$global_sale_end && $product_id) {
            $sale_start = esc_attr(get_post_meta($product_id, '_sale_price_dates_from', true)) ?? '';
            $sale_end = esc_attr(get_post_meta($product_id, '_sale_price_dates_to', true)) ?? '';
            if (!($sale_start && $sale_end)) {
                return '';
            }
        } elseif ($global_sale_end && $global_sale_start) {
            $sale_end = strtotime($global_sale_end . ' 23:59:59');
            $sale_start = strtotime($global_sale_start);
            if ($sale_end === false || $sale_end < 0) {
                $sale_end = $global_sale_end;
            }
            if ($sale_start === false || $sale_start < 0) {
                $sale_start = $global_sale_start;
            }

        } elseif ($global_sale_end && !$global_sale_start) {
            $sale_end =  strtotime($global_sale_end . ' 23:59:59');
            if ($sale_end === false || $sale_end < 0) {
                $sale_end = $global_sale_end;
            }
            $sale_start = $global_sale_start;
        }
        else {
            $sale_start = time();
            $sale_end = time() + (30 * 24 * 60 * 60);
        }
        if ($sale_end <= $sale_start ) {
            return '';
        }
        if(time() < $sale_start){
            return '';
        }
        if(time() > $sale_end){
            return '';
        }


        $develux_timer_title = get_post_meta($post_id, 'develux_timer_title', true) ?? 'days';

        $day_field = get_post_meta($post_id, 'develux_timer_day_name', true) ?? 'days';
        $hour_field = get_post_meta($post_id, 'develux_timer_hour_name', true) ?? 'hours';
        $minute_field = get_post_meta($post_id, 'develux_timer_minute_name', true) ?? 'minutes';
        $second_field = get_post_meta($post_id, 'develux_timer_second_name', true) ?? 'seconds';
        $styles_data = [
            'develux_timer_location' => get_post_meta($post_id, 'develux_timer_location', true),
            'develux_timer_display_animation' => get_post_meta($post_id, 'develux_timer_display_animation', true),
            'develux_timer_font_size' => get_post_meta($post_id, 'develux_timer_font_size', true),
            'develux_timer_font_size_unit' => get_post_meta($post_id, 'develux_timer_font_size_unit', true),
            'develux_timer_font_weight' => get_post_meta($post_id, 'develux_timer_font_weight', true),
            'develux_timer_font_color' => get_post_meta($post_id, 'develux_timer_font_color', true),
            'develux_timer_font_style' => get_post_meta($post_id, 'develux_timer_font_style', true),
            'develux_timer_background_color' => get_post_meta($post_id, 'develux_timer_background_color', true),
            'develux_timer_container_background_color' => get_post_meta($post_id, 'develux_timer_container_background_color', true),
            'develux_timer_container_background_a' => get_post_meta($post_id, 'develux_timer_container_background_a', true) ?? 1,
            'develux_timer_image_repeat' => get_post_meta($post_id, 'develux_timer_image_repeat', true),
            'develux_timer_image_size' => get_post_meta($post_id, 'develux_timer_image_size', true),
            'develux_timer_image_position' => get_post_meta($post_id, 'develux_timer_image_position', true),
            'develux_timer_bg_icon_url' => get_post_meta($post_id, 'develux_timer_bg_icon_url', true),
            'develux_timer_border_radius' => get_post_meta($post_id, 'develux_timer_border_radius', true),
            'develux_timer_width' => get_post_meta($post_id, 'develux_timer_width', true),
            'develux_timer_height' => get_post_meta($post_id, 'develux_timer_height', true),
            'develux_timer_gap' => get_post_meta($post_id, 'develux_timer_gap', true),
            'develux_timer_margin_top' => get_post_meta($post_id, 'develux_timer_margin_top', true),
            'develux_timer_padding_bottom' => get_post_meta($post_id, 'develux_timer_padding_bottom', true),
            'develux_timer_container_padding_x' => get_post_meta($post_id, 'develux_timer_container_padding_x', true),
            'develux_timer_container_width' => get_post_meta($post_id, 'develux_timer_container_width', true),
            'develux_timer_container_vertical_position' => get_post_meta($post_id, 'develux_timer_container_vertical_position', true),
            'develux_time_title_font_style' => get_post_meta($post_id, 'develux_time_title_font_style', true),
            'develux_time_title_font_size' => get_post_meta($post_id, 'develux_time_title_font_size', true),
            'develux_time_title_font_size_unit' => get_post_meta($post_id, 'develux_time_title_font_size_unit', true),
            'develux_time_title_font_color' => get_post_meta($post_id, 'develux_time_title_font_color', true),
            'develux_time_title_font_weight' => get_post_meta($post_id, 'develux_time_title_font_weight', true),
            'develux_timer_title_text_align' => get_post_meta($post_id, 'develux_timer_title_text_align', true),
            'develux_timer_wrapper_padding' => get_post_meta($post_id, 'develux_timer_wrapper_padding', true),
            'develux_timer_wrapper_width' => get_post_meta($post_id, 'develux_timer_wrapper_width', true),
            'develux_timer_wrapper_top' => get_post_meta($post_id, 'develux_timer_wrapper_top', true),
            'develux_timer_wrapper_margin_bottom' => get_post_meta($post_id, 'develux_timer_wrapper_margin_bottom', true),
            'develux_timer_wrapper_border_radius' => get_post_meta($post_id, 'develux_timer_wrapper_border_radius', true),
            'develux_timer_wrapper_border_width' => get_post_meta($post_id, 'develux_timer_wrapper_border_width', true),
            'develux_timer_wrapper_border_color' => get_post_meta($post_id, 'develux_timer_wrapper_border_color', true),

            'develux_font_style_timer_title' => get_post_meta($post_id, 'develux_font_style_timer_title', true),
            'develux_font_size_timer_title' => get_post_meta($post_id, 'develux_font_size_timer_title', true),
            'develux_time_title_font_unit' => get_post_meta($post_id, 'develux_time_title_font_unit', true),
            'develux_font_color_timer_title' => get_post_meta($post_id, 'develux_font_color_timer_title', true),
            'develux_font_weight_timer_title' => get_post_meta($post_id, 'develux_font_weight_timer_title', true),


        ];


        return self::get_timer_template($post_id, $sale_end, $sale_start, $develux_timer_title, $day_field, $hour_field, $minute_field, $second_field, $styles_data, $is_single);
    }

    private static function get_timer_template($id, $sale_end, $sale_start, $develux_timer_title, $day_field, $hour_field, $minute_field, $second_field, $styles_data, $is_single = false): string
    {
        $develux_timer_location = $styles_data['develux_timer_location'];
        $develux_timer_display_animation = $styles_data['develux_timer_display_animation'];
        $font_size = $styles_data['develux_timer_font_size'] ?: 1;
        $develux_timer_font_size_unit = $styles_data['develux_timer_font_size_unit'] ?: 'rem';
        $font_weight = $styles_data['develux_timer_font_weight'] ?? 400;
        $font_color = $styles_data['develux_timer_font_color'] ?? '#000';
        $font_style = $styles_data['develux_timer_font_style'] ?? 'normal';

        $tt_font_size = $styles_data['develux_time_title_font_size'] ?: 1;

        $tt_font_size_unit = $styles_data['develux_time_title_font_size_unit'] ?: 'rem';

        $tt_font_weight = $styles_data['develux_time_title_font_weight'] ?? 400;
        $tt_font_color = $styles_data['develux_time_title_font_color'] ?? '#000';
        $tt_font_style = $styles_data['develux_time_title_font_style'] ?? 'normal';

        $tt_style = 'font-style:' . $tt_font_style . ';font-weight:' . $tt_font_weight . ';line-height:' . $tt_font_size . $tt_font_size_unit . ';font-size:' . $tt_font_size . 'rem;color:' . $tt_font_color . ';';

        $background_color = $styles_data['develux_timer_background_color'] ?: '#000';
        $container_bg = $styles_data['develux_timer_container_background_color'] ?: '#000';
        $container_background_a = $styles_data['develux_timer_container_background_a'] ?? 1;
        if($container_background_a === ''){
            $container_background_a = 1;
        }

        $container_background_color = Helper::hex_to_rgba($container_bg, $container_background_a);
        $image_repeat = $styles_data['develux_timer_image_repeat'] ?: 'no-repeat';
        $image_size = $styles_data['develux_timer_image_size'] ?: 'cover';
        $image_position = $styles_data['develux_timer_image_position'] ?: 'center';
        $develux_timer_bg_icon_url = $styles_data['develux_timer_bg_icon_url'] ?: '';
        $border_radius = $styles_data['develux_timer_border_radius'] ?: 0;
        $width = $styles_data['develux_timer_width'] ?: 20;
        $height = $styles_data['develux_timer_height'] ?: 20;
        $gap = $styles_data['develux_timer_gap'] ?: 0;
        $margin_t = $styles_data['develux_timer_margin_top'] ?: 0;
        $margin_b = 5;
        $margin_y = 0;
        $padding_top = 0;
        $padding_bottom = $styles_data['develux_timer_padding_bottom'] ?: 0;
        $container_padding_x = $styles_data['develux_timer_container_padding_x'] ?: 0;
        $container_width = $styles_data['develux_timer_container_width'] ?: 0;
        $top = $styles_data['develux_timer_container_vertical_position'] ?: 0;
        $z_index = 20;
        $wrapper_padding = $styles_data['develux_timer_wrapper_padding'] ?: 0;
        $wrapper_width = 100;
        $wrapper_top = $styles_data['develux_timer_wrapper_top'] ?: 0;
        $wrapper_margin_bottom = $styles_data['develux_timer_wrapper_margin_bottom'] ?: 0;
        $wrapper_border_radius = $styles_data['develux_timer_wrapper_border_radius'] ?: 0;
        $wrapper_border_width = $styles_data['develux_timer_wrapper_border_width'] ?: 0;
        $wrapper_border_color = $styles_data['develux_timer_wrapper_border_color'] ?? '#9c75d0';



        $timer_title_font_style = $styles_data['develux_font_style_timer_title'] ?: 'normal';
        $timer_title_font_size = $styles_data['develux_font_size_timer_title'] ?: 1;
        $tt_font_unit = $styles_data['develux_time_title_font_unit'] ?: 'rem';
        $timer_title_font_color = $styles_data['develux_font_color_timer_title'] ?: '#000';
        $timer_title_font_weight = $styles_data['develux_font_weight_timer_title'] ?: 400;
        $timer_title_text_align = $styles_data['develux_timer_title_text_align'] ?: 400;

        $count_num_style = 'margin-top:' . $margin_t . 'px;margin-bottom:' . $margin_b . 'px; height:' . $height . 'px;width:100%;line-height:' . $height . 'px;border-radius:' . $border_radius . 'px;background:' . $background_color . ';font-style:' . $font_style . ';font-weight:' . $font_weight . ';font-size:' . $font_size . $develux_timer_font_size_unit . ';color:' . $font_color . ';';
        $container_style = 'position:relative;left:0;top:' . $top . 'px;max-width:' . $container_width . '%;width:' . $container_width . '%;padding-left:' . $container_padding_x . 'px;padding-right:' . $container_padding_x . 'px;padding-top:' . $padding_top . 'px;padding-bottom:' . $padding_bottom . 'px;margin:' . $margin_y . 'px auto;gap:' . $gap . 'px;';
        $timer_title_style = 'text-align:' . $timer_title_text_align . ';font-weight:' . $timer_title_font_weight . ';color:' . $timer_title_font_color . ';font-style:' . $timer_title_font_style . ';font-size:' . $timer_title_font_size . $tt_font_unit . ';';

        $wrapper_position = 'static';
        $top = 'margin-top: ' . $wrapper_top . 'px;';
        if ($develux_timer_location === 'before_product_card') {
            $wrapper_position = 'absolute';
            $top = 'top: ' . $wrapper_top . 'px;';
        }
        // on single only static position
        if($is_single){
            $wrapper_position = 'static';
            $top = 'margin-top: ' . $wrapper_top . 'px;';
        }
        $wrapper_style = '
        margin-bottom:' . $wrapper_margin_bottom . 'px;
        border-radius:' . $wrapper_border_radius . 'px;
        border-width:' . $wrapper_border_width . 'px;
        border-color:' . $wrapper_border_color . ';
        border-style: solid;
        left:0;'.$top.'
        max-width:' . $wrapper_width . '%;
        width:' . $wrapper_width . '%;
        position:' . $wrapper_position . ';
        z-index:' . $z_index . ';
        padding:' . $wrapper_padding . 'px;
        background:' . $container_background_color . ';';
        if ($develux_timer_bg_icon_url) {
            $wrapper_style .= 'background-image:url(' . $develux_timer_bg_icon_url . ');background-repeat:' . $image_repeat . ';
            background-size:' . $image_size . ';background-position:' . $image_position . ';';
        }
        return '
    <div class="develux-timer-countdown-wrapper" style="' . $wrapper_style . '">
        <div class="develux-timer-countdown-timer-title" style="' . $timer_title_style . '">' . $develux_timer_title . '</div>
        <div style="' . $container_style . '" data-animation="' . $develux_timer_display_animation . '" data-countdown-start="' . $sale_start . '" data-countdown="' . $sale_end . '" data-develux-id="' . $id . '" 
            class="develux-timer-counter develux-timer-countdown-timer-js">
            <div class="develux-timer-counter-item" style="width:' . $width . '%;">
                <div style="' . $count_num_style . '" class="develux-timer-countnum develux-timer-block-days-js"></div>
                <div style="' . $tt_style . '" class="develux-timer-counter-title">' . $day_field . '</div>
            </div>
            <div class="develux-timer-counter-item"  style="width:' . $width . '%;">
                <div style="' . $count_num_style . '" class="develux-timer-countnum develux-timer-block-hours-js"></div>
                <div style="' . $tt_style . '" class="develux-timer-counter-title">' . $hour_field . '</div>
            </div>
            <div class="develux-timer-counter-item"  style="width:' . $width . '%;">
                <div style="' . $count_num_style . '" class="develux-timer-countnum develux-timer-block-minutes-js"></div>
                <div style="' . $tt_style . '" class="develux-timer-counter-title">' . $minute_field . '</div>
            </div>
            <div class="develux-timer-counter-item"  style="width:' . $width . '%;">
                <div style="' . $count_num_style . '" class="develux-timer-countnum develux-timer-block-seconds-js"></div>
                <div style="' . $tt_style . '" class="develux-timer-counter-title">' . $second_field . '</div>
            </div>
        </div>
    </div>';
    }

}