<?php

namespace DEVELUXSCT\DashboardWidget;
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

use DEVELUXSCT\HTMLGenerators\DashboardWidget as DashboardWidgetHTML;

class DashboardWidget
{
    public function __construct()
    {
        add_action('wp_dashboard_setup', [$this, 'develux_add_dashboard_widgets']);
    }

    public function develux_add_dashboard_widgets(): void
    {
        wp_add_dashboard_widget(
            'develux_dashboard_widget',
            esc_html__('Develux Sales Countdown Timer plugin', 'devellux-sales-countdown-timer-builder'),
            [$this, 'develux_dashboard_widget_render']
        );
    }

    public function develux_dashboard_widget_render(): void
    {
        echo wp_kses_post(DashboardWidgetHTML::generate_dashboard_widget());
    }
}