<?php

namespace DEVELUXSCT\Core;
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Plugin_Setup
{
    public function __construct()
    {
        add_action('init', [$this, 'enable_revisions_for_products']);
        add_filter('safe_style_css', [$this, 'allow_styles_for_wp_kses']);
    }

    public function allow_styles_for_wp_kses(array $styles): array
    {
        $allowed_styles = [
            'display',
            'position',
            'top',
            'left',
            'right',
            'bottom',
            'z-index',
            'clip-path',
            'cursor',
            'pointer-events',
            'visibility',
            'opacity',
            'overflow',
            'filter',
            'mix-blend-mode',
            'transform',
            'transition',
            'animation',
            'background-color',
            'background-image',
            'background',
            'box-shadow',
            'text-shadow',
            'text-orientation',
            'background-clip'
        ];
        return array_merge($styles, $allowed_styles);
    }
    public function enable_revisions_for_products(): void
    {
        add_post_type_support('product', 'revisions');
    }


}