<?php

namespace DEVELUXSCT\Core;
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Plugin_Pro_Links
{

    public function __construct()
    {

        // Add hooks for plugin links
        add_filter('plugin_action_links_' . DEVELUXSCT_PLUGIN_BASENAME, [$this, 'add_action_links']);
        add_filter('plugin_row_meta', [$this, 'add_meta_links'], 10, 2);
        add_action('admin_menu', [$this, 'add_custom_class_to_submenu'], 999);
    }

    // Add "Get Pro" link to action links
    public function add_action_links(array $links): array
    {
        $pro_link = '<a href="#" target="_blank" style="color: #9C75D0; font-weight: bold;">Get Pro Version</a>';
        $links[] = $pro_link;
        return $links;
    }

    // Add "Get Pro" link to meta links
    public function add_meta_links(array $links, string $file): array
    {
        if ($file === DEVELUXSCT_PLUGIN_BASENAME) {
            $pro_link = '<a href="#" target="_blank" style="font-weight:bolder;color: #814dc5;">Get Pro</a>';
            $links[] = $pro_link; // Append "Get Pro" link
        }
        return $links;
    }

    public function add_custom_class_to_submenu(): void
    {
        global $submenu;

        // Check if the submenu item exists and add a custom class
        if (isset($submenu['develux-product-card-builder'])) {
            foreach ($submenu['develux-product-card-builder'] as $key => $submenu_item) {
                if ('get-pro-version' === $submenu_item[2]) { // Match the submenu page slug
                    $submenu['develux-product-card-builder'][$key][0] = '<span class="develux-get-pro">' .
                        $submenu_item[0] . '</span>'; // Add custom class to the link text
                }
                if ('help-center' === $submenu_item[2]) { // Match the submenu page slug
                    $submenu['develux-product-card-builder'][$key][0] = '<span class="develux-help-center">' .
                        $submenu_item[0] . '</span>'; // Add custom class to the link text
                }
            }
        }
    }


}