<?php

namespace DEVELUXSCT\Core;
if (!defined('ABSPATH')) {
    exit;
}

class PluginJSFiles implements EnqueueInterface
{
    public function __construct()
    {
        add_action('admin_enqueue_scripts', [$this, 'enqueue'],0);
        add_action('admin_enqueue_scripts', [$this, 'develux_bulk_editor']);
        add_action('admin_enqueue_scripts', [$this, 'localize_custom_script'],0);
        add_action('wp_enqueue_scripts', [$this, 'enqueue_frontend_scripts']);
        add_action('admin_enqueue_scripts', [$this,'deactivate_plugin_confirm']);
        add_action('admin_enqueue_scripts', [$this, 'enqueue_help_notice_scripts']);
    }
    public function deactivate_plugin_confirm($hook): void
    {
        if ($hook !== 'plugins.php'){
            return;
        }

        $ver = gmdate('ymd-Gis', filemtime(DEVELUXSCT_DWPC_PATH . 'assets/dist/deactivate.js'));
        wp_enqueue_script(
            'develuxsct-deactivate-js',
            DEVELUXSCT_URL. 'assets/dist/deactivate.js',
            ['jquery'],
            $ver,
            true,
        );
        wp_localize_script('develuxsct-deactivate-js', 'develuxsct_develuxTimerDeactivateConfirm', [
            'nonce' => wp_create_nonce('develux_timer_deactivate_confirm'),
            'action'=>'develux_timer_deactivate_confirm'
        ]);


    }

    public function enqueue(): void
    {
        wp_enqueue_media();
        $screen = get_current_screen();
        $allowed_pages = [
            'product',
            'woocommerce_page_develux-timer-builder',
            'woocommerce_page_develux-timer',
        ];

        if (!$screen || !in_array($screen->id, $allowed_pages, true)) {
            return;
        }
        $ver = gmdate('ymd-Gis', filemtime(DEVELUXSCT_DWPC_PATH . 'assets/dist/main.js'));
        wp_enqueue_script(
            'develuxsct-plugin-js',
            DEVELUXSCT_URL . 'assets/dist/main.js',
            ['jquery'],
            $ver,
            true,
        );
    }

    public function enqueue_help_notice_scripts(): void
    {
        $ver = gmdate('ymd-Gis', filemtime(plugin_dir_path(__FILE__) . '../../assets/dist/help_notice.js'));

        wp_enqueue_script(
            'develuxsct-help-notice-js',
            plugin_dir_url(__FILE__) . '../../assets/dist/help_notice.js',
            ['jquery'],
            $ver,
            true,
        );

        wp_localize_script('develuxsct-help-notice-js', 'develuxsct_HelpNoticeScript', [
                'ajax_url' => admin_url('admin-ajax.php'),
            ]
        );
    }

    public function develux_bulk_editor(): void
    {

        $screen = get_current_screen();
        $allowed_pages = [
            'woocommerce_page_develux-timer-builder',
        ];

        if (!$screen || !in_array($screen->id, $allowed_pages, true)) {
            return;
        }

        $ver = gmdate('ymd-Gis', filemtime(DEVELUXSCT_DWPC_PATH . 'assets/dist/develux_bulk.js'));

        wp_enqueue_script(
            'develuxsct_search_product',
            DEVELUXSCT_URL . 'assets/dist/develux_bulk.js',
            [],
            $ver,
            true
        );
        wp_localize_script('develuxsct_search_product', 'develuxsct_search_product_form', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce_search_product' => wp_create_nonce('search_product'),
            'nonce_save_tags' => wp_create_nonce('save_tags'),
            'nonce_save_categories' => wp_create_nonce('save_categories'),
            'nonce_append_product_to_list' => wp_create_nonce('append_product_to_list'),
            'nonce_update_included_products' => wp_create_nonce('update_included_products'),
        ));
    }

    public function localize_custom_script(): void
    {
        wp_localize_script('develuxsct-plugin-js', 'develuxsct_DeveluxTimerScript', [
                'base_url' => get_home_url(),
                'ajax_url' => admin_url('admin-ajax.php'),

                'action' => 'set_options',
                'nonce' => wp_create_nonce('set_options'),

                'action_develux_search_products' => 'develux_search_products',
                'nonce_develux_search_products' => wp_create_nonce('develux_search_products'),

                'action_create_timer' => 'develuxsct_create_timer',
                'nonce_create_timer' => wp_create_nonce('create_timer'),

                'action_delete_timer' => 'develuxsct_delete_timer',
                'nonce_delete_timer' => wp_create_nonce('delete_timer'),

                'action_timer_builder_form' => 'develux_timer_builder_form',
                'nonce_timer_builder_form' => wp_create_nonce('develux_timer_builder_form'),
            ]
        );

    }

    public function enqueue_frontend_scripts(): void
    {
        $ver = gmdate('ymd-Gis', filemtime(plugin_dir_path(__FILE__) . '../../assets/dist/external.js'));

        wp_enqueue_script(
            'develuxsct-plugin-frontend-js',
            DEVELUXSCT_URL . 'assets/dist/external.js',
            [],
            $ver,
            true
        );
    }


}