<?php

namespace DEVELUXSCT\Core;
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class PluginCSSFiles implements EnqueueInterface
{
    public function __construct()
    {
        add_action('admin_enqueue_scripts', [$this, 'enqueue'], 999);
        add_action('wp_enqueue_scripts', [$this, 'enqueue_frontend_styles'], 0);
        add_action('admin_enqueue_scripts', [$this,'deactivate_plugin_confirm']);
    }

    public function deactivate_plugin_confirm($hook): void
    {
        if ($hook !== 'plugins.php'){
            return;
        }
        // phpcs:ignore WordPress.WP.EnqueuedResourceParameters.MissingVersion
        wp_enqueue_style(
            'develuxsct-deactivate-css',
            DEVELUXSCT_URL . 'assets/dist/deactivate.css',
            []
        );
    }

    public function enqueue(): void
    {
        // phpcs:ignore WordPress.WP.EnqueuedResourceParameters.MissingVersion
        wp_enqueue_style('wp-color-picker');
        // phpcs:ignore WordPress.WP.EnqueuedResourceParameters.MissingVersion
        wp_enqueue_style(
            'develuxsct-plugin-css',
            DEVELUXSCT_URL . 'assets/dist/main.css',
            []
        );
        // phpcs:ignore WordPress.WP.EnqueuedResourceParameters.MissingVersion
        wp_enqueue_style('dashicons');
        if (class_exists('WooCommerce')) {
            // phpcs:ignore WordPress.WP.EnqueuedResourceParameters.MissingVersion
            wp_enqueue_style( 'woocommerce_admin_styles', WC()->plugin_url() . '/assets/css/admin.css');
        }
    }
    public function enqueue_frontend_styles(): void
    {
        $css_file =  DEVELUXSCT_DWPC_PATH . 'assets/dist/develux_frontend.css';
        $css_url  = DEVELUXSCT_URL . 'assets/dist/develux_frontend.css';
        $version  = file_exists( $css_file ) ? filemtime( $css_file ) : false;

        wp_enqueue_style(
            'develuxsct-plugin-frontend-css',
            $css_url,
            [],
            $version
        );
    }
}