<?php

namespace DEVELUXSCT\Core;
use DEVELUXSCT\HTMLGenerators\TemplateRenderer;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Admin_Notice
{
    public function __construct()
    {

        add_action('admin_head', [$this, 'add_custom_styles']);
        add_action('admin_notices', [$this, 'display_woocommerce_missing_notice']);
        add_action('admin_notices', [$this, 'display_version_notice']);
        add_action('admin_notices', [$this, 'display_help_info_notice']);

    }

    public function display_version_notice(): void
    {
        if (defined('DEVELUXSCT_WP_VERSION_OUTDATED') && DEVELUXSCT_WP_VERSION_OUTDATED) {
            echo '<div class="notice notice-warning">
            <p>
            <strong>Warning:</strong>
             Your WordPress version is outdated. This plugin requires at least WordPress '
                . esc_html(DEVELUXSCT_MIN_WP_VERSION) . '.
            </p>
            </div>';
        }

        if (defined('DEVELUXSCT_WOOCOMMERCE_VERSION_OUTDATED') && DEVELUXSCT_WOOCOMMERCE_VERSION_OUTDATED) {
            echo '<div class="notice notice-warning"><p><strong>Warning:</strong>
            Your WooCommerce version is outdated. This plugin requires at least WooCommerce '
                . esc_html(DEVELUXSCT_MIN_WC_VERSION) . '.
            </p>
            </div>';
        }
    }
    // Add custom styles to the admin panel
    public function add_custom_styles(): void
    {
        wp_register_style( 'develuxsct-admin-notices', false, [], '1.0' );
        wp_enqueue_style( 'develuxsct-admin-notices' );

        $custom_css = '.notice-warning { border-left-color: #ff9800; }
            .notice-error { border-left-color: #dc3232; }
            .develux-woocommerce-notice { border-left-color: #dc3232; }
            .notice-info.is-dismissible {
                background-color: #fff;
                border-left: 4px solid #2271b1;
            }
            .notice-info.is-dismissible .notice-dismiss {
                border: none;
                color: #888;
                font-size: 18px;
                font-weight: bold;
            }
            .notice-info.is-dismissible .notice-dismiss:hover {
                color: #555;
            }
            .develuxsct-flex-align-center {
                display: flex;
                align-items: center;
                gap: 12px;
            }
            .develuxsct-notice-help-info.notice-info {
                border-left: 4px solid #5B3FBB;
            }
            .develuxsct-notice-help-info h2{
                color: #5B3FBB;
            }';

        wp_add_inline_style( 'develuxsct-admin-notices', $custom_css );
    }
    public function display_woocommerce_missing_notice(): void
    {
        $allowed_html = TemplateRenderer::get_allowed_html();
        if (!class_exists('WooCommerce')) {
            echo wp_kses($this->display_woocommerce_notice(), $allowed_html);
        }
    }

    public function display_woocommerce_notice(): string
    {
        return ' <div class="notice notice-error is-dismissible develux-woocommerce-notice">
                <p><strong>Warning:</strong>
                 Please activate the WooCommerce plugin. The "Sale Countdown Timer Builder" plugin only work when the WooCommerce is enabled.</p>
                <p>
                <a target="_blank"
                 href="plugin-install.php?s=woocommerce&tab=search&type=term"
                  class="button button-primary">Install WooCommerce</a>
                </p>
            </div>';

    }

    public function display_help_info_notice(): void
    {
        $dismissed_at = get_option('develuxsct_help_info_notice_timestap');
        $nonce = wp_create_nonce('develuxsct_notice_help_info_nonce');
        $helpNoticeDelay = 7 * DAY_IN_SECONDS;

        if ($dismissed_at && (time() - $dismissed_at) < $helpNoticeDelay) {
            return;
        }
        ?>

        <div class="notice notice-info is-dismissible develuxsct-notice-help-info" data-nonce="<?php echo esc_attr($nonce); ?>">
            <div class="develux">
                <div class="develuxsct-notice-content develuxsct-flex-align-center">
                    <div class="develuxsct-notice-image">
                        <img src="<?php echo esc_url(plugin_dir_url(__FILE__) . "../../assets/images/icons/admin_help_notice_image.svg"); ?>">
                    </div>
                    <div class="develuxsct-notice-text">
                        <h2>
                            <?php
                            esc_html_e('Sale Countdown Timer Builder', 'devellux-sales-countdown-timer-builder');
                            ?>
                        </h2>
                        <p class="develuxsct-notice-buttons-group develuxsct-flex-align-center">
                            <?php
                            esc_html_e('If you need help setting up the plugin, please contact us', 'devellux-sales-countdown-timer-builder');
                            ?>
<a href="https://codecanyon.net/item/sales-countdown-timer-builder/59002596" target="_blank" class="develux-button styling-button">
                                <?php esc_html_e('Get Pro version', 'devellux-sales-countdown-timer-builder'); ?>
                            </a>
                            <a href="https://develux.com/documentation-for-plugins/sale-countdown-timer-builder/" target="_blank" class="develux-button styling-button">
                                <?php esc_html_e('Visit the plugin page', 'devellux-sales-countdown-timer-builder'); ?>
                            </a>
                            <a href="mailto:plugins_support@develux.com" target="_blank" class="develux-button styling-button">
                                <?php esc_html_e('Contact us', 'devellux-sales-countdown-timer-builder'); ?>
                            </a>
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <?php
    }
}