<?php
/**
 * Uninstall DevBrothers Cyrillic URL
 * 
 * @package DevBrothers_Cyrillic_Slugs
 */

// Защита от прямого доступа
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Удаление опций из базы данных
delete_option('dbcs_settings');
delete_option('dbcs_version');

// Удаление транзиентов
delete_transient('dbcs_conversion_progress');

// Удаление данных для мультисайта
if (is_multisite()) {
    $dbcs_sites = get_sites(['number' => 999]);
    
    foreach ($dbcs_sites as $dbcs_site) {
        switch_to_blog($dbcs_site->blog_id);
        
        delete_option('dbcs_settings');
        delete_option('dbcs_version');
        delete_transient('dbcs_conversion_progress');
        
        restore_current_blog();
    }
}

// Примечание: мы НЕ изменяем существующие slug'и обратно,
// так как это может нарушить работу сайта и SEO

