/**
 * DevBrothers Cyrillic URL Admin Scripts
 * 
 * @package DevBrothers_Cyrillic_Slugs
 */

(function($) {
    'use strict';
    
    $(document).ready(function() {
        
        // === Конвертация URL ===
        var conversionInProgress = false;
        var totalConverted = 0;
        var offset = 0;
        
        $('#dbcs-convert-button').on('click', function(e) {
            e.preventDefault();
            
            if (conversionInProgress) {
                return;
            }
            
            // Подтверждение
            var confirmText = 'Вы уверены, что хотите конвертировать все существующие URL?\n\n' +
                            'Это действие изменит slug всех записей и терминов с кириллицей.\n' +
                            'Рекомендуется сделать резервную копию перед началом.';
            
            if (!confirm(confirmText)) {
                return;
            }
            
            // Начинаем конвертацию
            startConversion();
        });
        
        function startConversion() {
            conversionInProgress = true;
            totalConverted = 0;
            offset = 0;
            
            // Блокируем кнопку
            $('#dbcs-convert-button')
                .prop('disabled', true)
                .find('.dashicons')
                .addClass('dbcs-spinning');
            
            // Показываем прогресс
            $('#dbcs-conversion-progress').slideDown();
            $('#dbcs-conversion-result').slideUp();
            
            // Запускаем конвертацию
            convertBatch();
        }
        
        function convertBatch() {
            $.ajax({
                url: dbcsData.ajax_url,
                type: 'POST',
                data: {
                    action: 'dbcs_convert_urls',
                    nonce: dbcsData.nonce,
                    offset: offset
                },
                success: function(response) {
                    if (response.success) {
                        var data = response.data;
                        
                        totalConverted += data.converted_posts + data.converted_terms;
                        
                        // Обновляем прогресс
                        var progress = Math.round((data.processed / data.total) * 100);
                        updateProgress(progress, totalConverted, data.total);
                        
                        // Если есть еще записи, продолжаем
                        if (data.has_more) {
                            offset = data.processed;
                            convertBatch();
                        } else {
                            // Конвертация завершена
                            finishConversion(totalConverted, data.errors);
                        }
                    } else {
                        // Ошибка
                        showError(response.data.message || 'Произошла неизвестная ошибка');
                    }
                },
                error: function(xhr, status, error) {
                    showError('Ошибка AJAX: ' + error);
                }
            });
        }
        
        function updateProgress(percent, converted, total) {
            $('#dbcs-progress-bar').css('width', percent + '%');
            $('#dbcs-progress-text').text(
                'Обработано: ' + converted + ' из ' + total + ' (' + percent + '%)'
            );
        }
        
        function finishConversion(converted, errors) {
            conversionInProgress = false;
            
            // Разблокируем кнопку
            $('#dbcs-convert-button')
                .prop('disabled', false)
                .find('.dashicons')
                .removeClass('dbcs-spinning');
            
            // Скрываем прогресс
            $('#dbcs-conversion-progress').slideUp();
            
            // Показываем результат
            var resultHtml = '<div class="notice notice-success">';
            resultHtml += '<p><strong>Конвертация завершена!</strong></p>';
            resultHtml += '<p>Успешно конвертировано: <strong>' + converted + '</strong> элементов.</p>';
            
            if (errors && errors.length > 0) {
                resultHtml += '<p style="color: #d63638;">Ошибок: ' + errors.length + '</p>';
                resultHtml += '<details style="margin-top: 10px;"><summary>Показать ошибки</summary>';
                resultHtml += '<ul class="dbcs-errors-list">';
                errors.forEach(function(error) {
                    resultHtml += '<li>' + escapeHtml(error) + '</li>';
                });
                resultHtml += '</ul></details>';
            }
            
            resultHtml += '</div>';
            
            $('#dbcs-conversion-result').html(resultHtml).slideDown();
            
            // Автоскролл к результату
            $('html, body').animate({
                scrollTop: $('#dbcs-conversion-result').offset().top - 100
            }, 500);
        }
        
        function showError(message) {
            conversionInProgress = false;
            
            // Разблокируем кнопку
            $('#dbcs-convert-button')
                .prop('disabled', false)
                .find('.dashicons')
                .removeClass('dbcs-spinning');
            
            // Скрываем прогресс
            $('#dbcs-conversion-progress').slideUp();
            
            // Показываем ошибку
            var errorHtml = '<div class="notice notice-error">';
            errorHtml += '<p><strong>Ошибка!</strong></p>';
            errorHtml += '<p>' + escapeHtml(message) + '</p>';
            errorHtml += '</div>';
            
            $('#dbcs-conversion-result').html(errorHtml).slideDown();
        }
        
        // Экранирование HTML для безопасности
        function escapeHtml(text) {
            var map = {
                '&': '&amp;',
                '<': '&lt;',
                '>': '&gt;',
                '"': '&quot;',
                "'": '&#039;'
            };
            return text.replace(/[&<>"']/g, function(m) { return map[m]; });
        }
        
        // === Подсветка активного якоря (интеграция с DevBrothers) ===
        // Эта функция уже реализована в DevBrothers Admin Panel,
        // но мы можем добавить дополнительное поведение если нужно
        
        // === Подтверждение перед уходом со страницы если идет конвертация ===
        $(window).on('beforeunload', function() {
            if (conversionInProgress) {
                return 'Конвертация еще не завершена. Вы уверены, что хотите покинуть страницу?';
            }
        });
        
    });
    
})(jQuery);

