<?php
/**
 * Uninstall script for DEED Pay WooCommerce Plugin
 *
 * This file is executed when the plugin is uninstalled.
 *
 * @package DEEDPay
 * @since 0.1.1
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete plugin configuration settings (API keys, webhook secrets) for security
delete_option('deedpay_settings');

// NOTE: We DO NOT delete '_deedpay_' order meta
// Financial regulations require maintaining records of transaction IDs and
// escrow references linked to specific orders for at least 5-7 years.
// Order meta data is part of the order record and should be preserved.
