# DEED Pay WooCommerce Plugin - Translation Files

## Overview

This directory contains all translation files for the DEED Pay WooCommerce plugin.

## Files

- **deed-pay-woo.pot** - Translation template (source file for all translations)
- **deed-pay-woo-{locale}.po** - Portable Object files (source translations)
- **deed-pay-woo-{locale}.mo** - Machine Object files (compiled binary translations)

**Important:** The plugin text domain is `deed-pay-woo`. WordPress loads translations from files named `deed-pay-woo-{locale}.mo` (or `.po`) in this directory.

## Available Languages

- **English (en_US)** - Default language (source strings in code)
- **German (de_DE)** - Deutsch
- **Spanish (es_ES)** - Español
- **French (fr_FR)** - Français
- **Portuguese Brazil (pt_BR)** - Português (Brasil)
- **Portuguese Portugal (pt_PT)** - Português (Portugal)
- **Chinese Simplified (zh_CN)** - 简体中文

## Default Language

**English is the default language.** All source strings (`msgid`) in the plugin code are in English. When no translation is available for a user's language, WordPress will automatically fall back to English.

## Compiling Translation Files

WordPress can use `.po` files directly, but `.mo` (Machine Object) files are preferred for better performance as they are binary-compiled versions.

### Method 1: Using WP-CLI (Recommended)

If you have WP-CLI installed:

```bash
wp i18n make-mo languages
```
(from plugin root)

### Method 2: Using Poedit

1. Download and install [Poedit](https://poedit.net/)
2. Open each `.po` file in Poedit
3. Save the file - Poedit will automatically generate the corresponding `.mo` file

### Method 3: Using msgfmt (gettext tools)

If you have gettext tools installed:

```bash
# Windows (with gettext installed, run from plugin root)
msgfmt -o languages/deed-pay-woo-de_DE.mo languages/deed-pay-woo-de_DE.po
msgfmt -o languages/deed-pay-woo-es_ES.mo languages/deed-pay-woo-es_ES.po
# ... repeat for fr_FR, pt_BR, pt_PT, zh_CN

# Linux/Mac (from plugin root)
for po in languages/deed-pay-woo-*.po; do
    msgfmt -o "${po%.po}.mo" "$po"
done
```

### Method 4: Using PowerShell script

Run from the plugin root (requires WP-CLI, msgfmt, or similar on PATH):

```powershell
.\compile-translations.ps1
```

## Translation Status

All translation files contain **81 translatable strings** covering:
- Admin settings and labels
- Error messages
- Order status messages
- Webhook event notifications
- Refund status messages
- Version check warnings

## How WordPress Loads Translations

1. WordPress checks for `.mo` files first (if available)
2. Falls back to `.po` files if `.mo` files are not found
3. Falls back to English (default) if no translation is available

## Adding New Translations

1. Use the `.pot` file as a template
2. Create a new `.po` file for your locale (e.g., `deed-pay-woo-it_IT.po`)
3. Translate all `msgstr` entries
4. Compile to `.mo` file using one of the methods above

## Verification

To verify translations are working:

1. Set your WordPress site language to a translated language (e.g., German)
2. Navigate to WooCommerce > Settings > Payments > DEED Pay
3. Check that all labels and messages appear in the selected language

## Support

For translation issues or to contribute translations, please contact:
- Email: hello@usedeed.com
- Support: https://usedeed.com/support
