/**
 * DEED Pay Checkout Enhancements
 *
 * Optional enhancements for checkout page
 *
 * @package DEEDPay
 * @since 0.1.1
 */

(function($) {
    'use strict';

    $(document).ready(function() {
        // Log that DEED Pay gateway is loaded (only in debug mode)
        if (typeof console !== 'undefined' && console.log) {
            console.log('DEED Pay gateway loaded');
        }

        // Optional: Enhance payment method description visibility
        $('body').on('payment_method_selected', function() {
            if ($('#payment_method_deedpay').is(':checked')) {
                // Payment method is selected - you can add custom UI enhancements here
                // For v1.0, minimal implementation
            }
        });

        // Optional: Show escrow protection message
        $('body').on('change', 'input[name="payment_method"]', function() {
            if ($(this).val() === 'deedpay') {
                // DEED Pay selected - escrow message is already in description
                // Additional enhancements can be added here if needed
            }
        });
    });

})(jQuery);
