<?php
namespace Declarando\Woocommerce\Admin;

use Declarando_Plugin;

class Init
{
  function init()
  {
    if (!empty(Declarando_Plugin::get('token'))) {
      // require 'Column.php';
      $column = new Column();
      $column->init();

      add_action('admin_enqueue_scripts', function ($hook) {
        // Solo en listado y edición de pedidos
        if (!in_array($hook, ['edit.php', 'post.php', 'post-new.php', 'woocommerce_page_wc-orders'], true)) {
          return;
        }

        $screen = function_exists('get_current_screen') ? get_current_screen() : null;
        if (!$screen || $screen->post_type !== 'shop_order') {
          return;
        }

        // Mensaje (puedes ajustarlo aquí)
        $msg = "¿Seguro que quieres borrar este pedido? Esto no cambiará el stock ni modificará tus ingresos en Declarando.";

        // Inyectamos JS usando jQuery ya presente en admin
        wp_add_inline_script('jquery-core', sprintf('
(function($){
  var MSG = %s;

  function confirmOrStop(e){
    if(!window.confirm(MSG)){
      e.preventDefault();
      e.stopImmediatePropagation();
      return false;
    }
  }

  // 1) Enlace "Mover a la papelera" / "Borrar permanentemente" dentro de la ficha
  $(document).on(\'click\', \'a.submitdelete\', function(e){
    confirmOrStop(e);
  });

  // 2) Enlaces de borrar/traspapelar en el listado
  $(document).on(\'click\', \'#the-list a.submitdelete\', function(e){
    confirmOrStop(e);
  });

  // 3) Acciones en lote (Arriba/Abajo)
  function bindBulk(buttonId, selectName){
    $(document).on(\'click\', buttonId, function(e){
      var $tablenav = $(this).closest(\'.tablenav\');
      var action = $tablenav.find(\'select[name="\'+selectName+\'"]\').val();
      // En WP el valor suele ser \'trash\' para "Mover a la papelera" y \'delete\' para "Borrar permanentemente"
      if(action === \'trash\' || action === \'delete\'){
        if(!window.confirm(MSG)){
          e.preventDefault();
          e.stopImmediatePropagation();
          return false;
        }
      }
    });
  }
  bindBulk(\'#doaction\',  \'action\');
  bindBulk(\'#doaction2\', \'action2\');

})(jQuery);
', wp_json_encode($msg)));
      });

    }
  }
}
