jQuery(function ($) {
    // Initialize postboxes for classic editor
    if (window.postboxes) {
        postboxes.add_postbox_toggles('shop_order');
    }

    // Handle refund sync button clicks
    $(document).on("click", ".decl82gf-crear-refund", function (e) {
        e.preventDefault();
        var $btn = $(this);
        if ($btn.prop("disabled")) return;

        $btn.prop("disabled", true).text(declarandoRefunds.creating);
        var refundId = $btn.data("refund");
        var nonce = $btn.data("nonce");

        $.ajax({
            url: (window.ajaxurl || ajaxurl),
            type: "POST",
            dataType: "json",
            data: {
                action: "decl82gf_crear_abono",
                refund_id: refundId,
                nonce: nonce
            }
        })
            .done(function (resp) {
                console.log(resp);
                if (resp && resp.success) {
                    location.reload();
                } else {
                    alert((resp && resp.data && resp.data.message) ? resp.data.message : "Error");
                    $btn.prop("disabled", false).text(declarandoRefunds.syncRefund);
                }
            })
            .fail(function (xhr) {
                alert("Error: " + (xhr.responseJSON?.data?.message || xhr.statusText));
                $btn.prop("disabled", false).text(declarandoRefunds.syncRefund);
            });
    });
});
