jQuery(function ($) {
    $(document).on("click", ".decl82gf-crear", function (e) {
        e.preventDefault();
        var $btn = $(this);
        if ($btn.prop("disabled")) return;

        $btn.prop("disabled", true).text("Creando...");
        var orderId = $btn.data("order");
        var nonce = $btn.data("nonce");

        $.post(ajaxurl, {
            action: "decl82gf_crear_factura",
            order_id: orderId,
            nonce: nonce
        })
            .done(function (resp) {
                if (resp && resp.success) {
                    // Refresca la fila (más simple: recargar la página)
                    location.reload();
                } else {
                    alert((resp && resp.data && resp.data.message) ? resp.data.message : "Error desconocido");
                    $btn.prop("disabled", false).text("Crear factura");
                }
            })
            .fail(function (xhr) {
                alert("Error: " + (xhr.responseJSON?.data?.message || xhr.statusText));
                $btn.prop("disabled", false).text("Crear factura");
            });
    });
});
