<?php
/**
 * Check whether input is a correct formated DeckBird Webshow Link
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit; 
}

 function deckbird_validate_deckbird_link($script_url) {
    // Trim the input URL to remove any extra whitespace
    $script_url = trim($script_url);

    // Check if the URL is a valid WebShow Embed Link 
    if(empty($script_url)){
        return 'Please provide a valid link'; 
    } 
    if (strpos($script_url, 'https://assets.deckbird.ai/web/webshow.js?id=') !== 0) {
        return 'The link you provided is incorrect: "' . esc_html($script_url) .'"';
    }

    return '';
}