<?php
/**
 * Insert the Webshow Button script
 */

 // Exit if accessed directly
if (!defined('ABSPATH')) {
	exit; 
}

include_once 'utils/validate-deckbird-link.php'; 

// Hook to enqueue the script
function deckbird_enqueue_script() {
    $link = get_option('deckbird_embed_link', '');
    $error_message = deckbird_validate_deckbird_link($link);

    if (empty($error_message)) {
          // This add Webshow button to the site 
            wp_enqueue_script(
                'deckbird-webshow',
                esc_url($link),
                array(),
                '1.0.0', // Script version
                true
            );
    } else {
        error_log($error_message);
    }
}
add_action('wp_enqueue_scripts', 'deckbird_enqueue_script');

