<?php
/**
 * Add Setting Page 
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit; 
}

include_once 'utils/validate-deckbird-link.php';

// Register settings 
function deckbird_register_settings() {
    if (get_option('deckbird_embed_link') === false) {
        add_option('deckbird_embed_link', '');
    }
    register_setting(
        'deckbird_options_group', 
        'deckbird_embed_link', 
        array(
            'sanitize_callback' => 'deckbird_validate_link'
        ) 
    );
}
add_action('admin_init', 'deckbird_register_settings');

function deckbird_validate_link($link) {
    $error_message = deckbird_validate_deckbird_link($link);

    // If there's an error, add a settings error and return the previous valid option
    if (!empty($error_message)) {
        add_settings_error('deckbird_embed_link', 'deckbird_embed_link_error', $error_message, 'error');
        return get_option('deckbird_embed_link'); // return the previous valid option
    }

    return $link;
}

// Add setting page to menu
function deckbird_register_options_page() {
    add_options_page('DeckBird.ai WebShow Button Settings', 'DeckBird WebShow', 'manage_options', 'deckbird', 'deckbird_options_page');
}
add_action('admin_menu', 'deckbird_register_options_page');


// Add link to Settings page on Plugins List
add_filter('plugin_action_links_' .  'deckbird-webshow/deckbird-webshow.php', 'deckbird_add_setting');

function deckbird_add_setting($links) {
    // Add a link to settings page
    $settings_link = '<a href="options-general.php?page=deckbird">Settings</a>';

    $links[] = $settings_link; // Append the Settings link to the end of the links array
    return $links;
}

// Enqueue stylesheet for UI
add_action('admin_enqueue_scripts', 'deckbird_enqueue_admin_styles');

function deckbird_enqueue_admin_styles($hook) {
    // Only enqueue on the settings page
    if ($hook == 'settings_page_deckbird') {
        wp_enqueue_style(
            'deckbird-admin-styles', 
            plugin_dir_url(__FILE__) . 'css/style.css', 
            array(), 
            '1.0.0',  // Version number
            'all'   
        );
    }
}


// Display UI
function deckbird_options_page() {
    $link = get_option('deckbird_embed_link');
    $alert_message = '';

    if (empty($link)) {
        $alert_message = '<div class="notice notice-warning"><p>The <strong>WebShow Button</strong> is <strong>hidden</strong> until you add the embed code.</p></div>';
    }
    ?>
    <div class="deckbird-settings-wrapper">
        <h2>DeckBird WebShow Button Settings</h2>
        <form method="post" action="options.php">
            <?php settings_fields('deckbird_options_group'); ?>
            <div class="deckbird-settings-form-wrapper" >
                <table>
                    <tr valign="top">
                        <th class='deckbird-settings-form-input-label' scope="row"><label for="deckbird_embed_link">WebShow Button Embed Link</label></th>
                    </tr>
                    <tr>
                        <td><input class="deckbird-settings-form-input" type="text" id="deckbird_embed_link" name="deckbird_embed_link" placeholder="Please enter the link" value="<?php echo esc_attr($link); ?>"  /></td>
                    </tr>
                </table>
                <?php submit_button(); ?>
            </div>
        </form>
    </div>
    <?php
}
