<?php
/**
 * Remind user to add the webshow url in the Setting page if it is not alread set
 */

 // Exit if accessed directly
if (!defined('ABSPATH')) {
	exit; 
}

include_once 'utils/validate-deckbird-link.php';

function deckbird_activate_plugin() {
    $link = get_option('deckbird_embed_link', '');
    $error_message = deckbird_validate_deckbird_link($link);

    if (!empty($error_message)) {
        add_option('deckbird_show_prompt', true);
    }
}
register_activation_hook(plugin_dir_path(__DIR__) . 'deckbird-webshow.php', 'deckbird_activate_plugin');

// Check if prompt is needed and display notice
function deckbird_check_prompt() {
    if (get_option('deckbird_show_prompt', false)) {
        echo '<div class="notice notice-info is-dismissible"><p>Please complete the setup in <a href="options-general.php?page=deckbird"><strong>DeckBird Settings</strong></a> page</p></div>';
        delete_option('deckbird_show_prompt');
    }
}
add_action('admin_notices', 'deckbird_check_prompt');