<?php
/**
  * Plugin Name: Adsfox tracking Pixel
  * Author: Adsfox
  * Author URI: https://adsfox.com/
  * Requires at least: 5.6.4
  * Tested up to: 5.8.3
  * Requires PHP: 7.2
  * Description: Facebook Pixel and tracking for your Website.
  * Tags: Facebook Pixel, Facebook Tracking, Facebook Contact form 7, Facebook Elementor, Facebook Woocommerce
  * Version: 0.0.1.5
  * License: GPLv2 or later
  * License URI: http://www.gnu.org/licenses/gpl-2.0.html

 **/


if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
//load required parts if in admin dashboard
if(is_admin()):
	if ( is_file(  plugin_dir_path(__FILE__) . 'wpajax/ajax.php') ) {
     require plugin_dir_path(__FILE__) . 'wpajax/ajax.php';
	 }
    add_action('admin_menu', 'ddt_facebook_Nav_create_menu');
    add_action('admin_menu', 'ddt_facebooknav_submenu');

		if (!function_exists('ddt_tracking_enqueue')) {
			add_action('admin_enqueue_scripts', 'ddt_tracking_enqueue');
			function ddt_tracking_enqueue($hook) {

					if ( 'toplevel_page_DDT-navigator-settings-page' != $hook && 'ddt-tracking-pixel_page_ddt-info-page' != $hook) {
							return;
					}
					//main page
						if ( 'toplevel_page_DDT-navigator-settings-page' == $hook ){
								wp_enqueue_style('ddt_facebook_scripts_css', plugins_url('css/main.css',__FILE__ ));
								wp_enqueue_style('ddt_facebook_scripts_switch_css', plugins_url('css/switch.css',__FILE__ ));
								wp_enqueue_style('ddt_facebook_scripts_autocomplete_css', plugins_url('css/autocomplete.css',__FILE__ ));
								wp_enqueue_script('ddt_facebook_scripts_autocomplete_js', plugins_url('js/autocomplete.js',__FILE__ ));
								wp_enqueue_script('ddt_facebook_scripts_main_js', plugins_url('js/main.js',__FILE__));
						}
					//info page
					if('ddt-tracking-pixel_page_ddt-info-page' == $hook){
						wp_enqueue_style('ddt_facebook_scripts_info', plugins_url('css/info.css',__FILE__ ));
						wp_enqueue_script('ddt_facebook_scripts_accordeon_js', plugins_url('js/accordeon.js',__FILE__ ));
					}
			}
		}

 endif;




if (!function_exists('ddt_facebook_Nav_create_menu')) {
function ddt_facebook_Nav_create_menu()
{
   add_menu_page('NavigatorDDT', 'Adsfox tracking pixel', 'administrator', 'DDT-navigator-settings-page', 'fn_DDT_Facebook_nav_settings_page', 'dashicons-facebook-alt');
   add_action( 'admin_init', 'fn_DDT_Facebook_Nav_register_mysettings' );
}
}

if (!function_exists('ddt_facebooknav_submenu')) {
function ddt_facebooknav_submenu()
{
    add_submenu_page(
        'DDT-navigator-settings-page', // ddt-marketing-settings-page
        'adsfox-info',
        'adsfox-info',
        'delete_plugins',
        'ddt-info-page',
        'ddt_info_page'
    );
   //not needed at the moment add_action( 'admin_init', 'fn_ddttimer_register_mysettings' );
}
}
if (!function_exists('fn_DDT_Facebook_Nav_register_mysettings')) {
/*****register settings options****/
function fn_DDT_Facebook_Nav_register_mysettings()
{
  if (!get_option("DDT_Facebook_events_url")): add_option("DDT_Facebook_events_url", "0"); endif;
  if (!get_option("DDT_Pixel_Facebook_auto_setup")): add_option("DDT_Pixel_Facebook_auto_setup", "0"); endif;
  if (!get_option("DDT_Pixel_Facebook_auto_setup_apikey")): add_option("DDT_Pixel_Facebook_auto_setup_apikey", "0"); endif;
  register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_disable_nav' );
  register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_Pixel_Activated' );
  register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_disable_coockieplugin' );
  register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_Pixel_Id' );
  register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_account_Id' );
  register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_account_name' );
  register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Pixel_Facebook_Position' );
  //ecommerce
  register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_ecommerce_Activated' ); //is ecomerce
      //woocommerce
      register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_woocommerce_Activated' ); //is activated
      register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_woocommerce_addtocard_Eventtype' ); //track caart yes = 1
      register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_woocommerce_checkout_Eventtype' ); //track checkout yes = 1
      register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_woocommerce_purchase_Eventtype' ); //track purchase yes = 1
      //ecommerce thankyou page
      register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_ecommerce_thankyou_Activated' );
      register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_ecommerce_thankyou_page' );
    //contact
    register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_contact_Activated' ); //is contact
        //contactform 7
        register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_contact_cf7_Activated' ); //is cf7
        //elementor form
        register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_contact_elementor_Activated' ); //is elementor
        // phone and email click
        register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_contact_phoneemail_Activated' );
        register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_contact_phoneemail_Email' );
        register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_contact_phoneemail_Phone' );
        //thank you page
         register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_contact_thankyou_Activated' );
         register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_contact_thankyou_page' );
		//conversion api
   register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_Capi_Activated' ); //is cconversion api = 1
	 		//Token
			register_setting( 'DDT_Facebook_Nav-settings-group', 'DDT_Facebook_Nav_Capi_token'); //token
}
}

/*****settings options****/
if (!function_exists('fn_DDT_Facebook_nav_settings_page')) {
function fn_DDT_Facebook_nav_settings_page()
{
	if ( is_file(  plugin_dir_path(__FILE__) . 'languages.php') ) {
   require plugin_dir_path(__FILE__) . 'languages.php';
 	}
	if ( is_file(  plugin_dir_path(__FILE__) . 'frontend/options.php') ) {
   require plugin_dir_path(__FILE__) . 'frontend/options.php';
 }
}
}
if (!function_exists('ddt_info_page')) {
function ddt_info_page()
{
	if ( is_file(  plugin_dir_path(__FILE__) . 'languages.php') ) {
   require plugin_dir_path(__FILE__) . 'languages.php';
 }
 if ( is_file(  plugin_dir_path(__FILE__) . 'frontend/info.php') ) {
   require plugin_dir_path(__FILE__) . 'frontend/info.php';
 }
}
}


//facebook tracking
$ddt_facebook_disabled = sanitize_text_field(get_option('DDT_Facebook_Nav_disable_nav', '0'));

if(isset($ddt_facebook_disabled) && $ddt_facebook_disabled == 1):
	 if ( is_file(  plugin_dir_path(__FILE__) . 'tracking/facebook_loader.php') ) {
    require plugin_dir_path(__FILE__) . 'tracking/facebook_loader.php';
	}
endif;




?>
