jQuery(function($) {

    $.fn.createSwitch = function(){
        this.each(function(){

            var thisCheckbox = $(this);
            var switchAlreadyExcist = thisCheckbox.prev('.dd-switch').length;
            var name = thisCheckbox.prop("name");
            var id = thisCheckbox.prop("id");
            var checked = thisCheckbox.prop("checked");
            var status = checked ? ' on' : '';
            if(!switchAlreadyExcist){
                thisCheckbox.before('<div class="dd-switch'+status+'"><div class="switchHolder"><div class="onSquare button-primary"></div><div class="buttonSwitch"></div><div class="offSquare"></div></div></div>' );
            }
            var thisSwitch = thisCheckbox.prev('.dd-switch');

            thisSwitch.on('click',function(){
                //console.log('clicked on switch');

                if (!thisSwitch.parents('label').length){ //if has no label check otherwise the event on the label will check.
                    thisCheckbox.trigger('click');//.prop('checked', checked);
                    $('input[type=checkbox]').updateSwitch();
                }
            })
            thisCheckbox.change(function() {
                $('input[type=checkbox]').updateSwitch();
            });
        });
        return this;
    };

    $.fn.updateSwitch = function(){
        this.each(function(){
            var thisCheckbox = $(this);
            var checked = thisCheckbox.prop("checked");
            if(checked){
                thisCheckbox.prev('.dd-switch').addClass('on');
            }
            else{
                thisCheckbox.prev('.dd-switch').removeClass('on');
            }
        });
        return this;
    };

    $.fn.inlineEditor = function(){
        this.each(function(){
            $(this).addClass('SwitchOpenEditor');
            $(this).on('click', function(){
                //console.log('Open inline Editor');
                var setAppendCheckboxes = setInterval(function(){

                    $('input[type=checkbox]').updateSwitch();
                    clearInterval(setAppendCheckboxes);
                }, 100);
            })
        });
        return this;
    };

    $('input[type=checkbox]').createSwitch();
    $('.editinline').inlineEditor();


    $(document).ajaxComplete(function(){
        //console.log('ajax complete')
        $('input[type=checkbox]').updateSwitch();
        $('.editinline').inlineEditor();

    });
});