jQuery(document).ready(function () {
  function totalCost(input) {
    let shares = jQuery(input).closest(".flex-row").find("input.shares");
    let price = jQuery(input).closest(".flex-row").find("input.avg-buy");
    let total = jQuery(input).closest(".flex-row").find("input.total");

    // let addShares = parseInt(totalShares.val()) + parseInt(shares.val()) - oldTotalShares;
    // totalShares.val(addShares);

    let finalCost = shares.val() * price.val();
    total.val(finalCost);
  }

  function calculateAverageCost() {
    let totalShares = jQuery("#total-shares");

    let newTotalShares = 0;
    let newCostTotal = 0;

    let costAverage = jQuery("#cost-average");
    let totalCost = jQuery("#total-cost");

    jQuery("input.shares").each(function () {
      let value;
      if (jQuery(this).val() == "") {
        value = 0;
      } else {
        value = parseInt(jQuery(this).val());
      }

      newTotalShares += value;
    });
    jQuery("input.total").each(function () {
      let value;
      if (jQuery(this).val() == "") {
        value = 0;
      } else {
        value = parseInt(jQuery(this).val());
      }

      newCostTotal += value;
    });

    let avgCost = parseFloat((newCostTotal / newTotalShares).toFixed(3));

    if (newTotalShares > 0) {
      costAverage.val(avgCost);
    } else {
      costAverage.val(0);
    }
    // costAverage.val(parseInt((newCostTotal / newTotalShares).toFixed(3)));
    totalShares.val(newTotalShares);
    totalCost.val(newCostTotal);
  }

  function totalReturns() {
    let totalShares = jQuery("#total-shares");
    let totalCost = jQuery("#total-cost").val();
    let costAverage = jQuery("#cost-average");
    let sellPrice = jQuery("#sell-price");
    let totalValueOfAssets = jQuery("#total-value-assets");

    let avgPrice = costAverage.val();
    let sellingPrice = sellPrice.val();

    let valueOfAssets = sellingPrice * totalShares.val();
    let returns = ((sellingPrice - avgPrice) * totalShares.val()).toFixed(3);

    if (valueOfAssets < totalCost) {
      jQuery(".total-returns #returns").css("color", "red");
      jQuery(".total-returns #returns").text(Math.abs(returns));
      jQuery(".total-returns #status").text("Loss");
    } else {
      jQuery(".total-returns #returns").css("color", "green");
      jQuery(".total-returns #returns").text(returns);
      jQuery(".total-returns #status").text("Profit");
    }
    if (sellingPrice > 0) {
      jQuery(".total-returns").show();
      jQuery(".error").hide();
    } else {
      jQuery(".error").show();
    }
    totalValueOfAssets.val(valueOfAssets);
  }
  jQuery(document).on("keyup", "input.shares", function () {
    totalCost(this);
    calculateAverageCost();
  });
  jQuery(document).on("keyup", "input.avg-buy", function () {
    totalCost(this);
    calculateAverageCost();
  });
  jQuery(document).on("keyup", "input.total", function () {
    totalCost(this);
    calculateAverageCost();
  });
  jQuery(document).on("click", ".btn-calculate", function () {
    totalReturns();
  });
  jQuery(document).on("click", ".btn-remove", function () {
    jQuery(this).closest(".flex-row").remove();
  });
  jQuery(document).on("click", ".btn-add", function () {
    let id = jQuery(this).attr("id");
    let asset;
    if (id == "coins") {
      asset = "Amount of Coins";
    } else {
      asset = "Number of Shares";
    }
    let newRow = `
                    <div class="flex-row additional-rows">
                        <div class="form-group">
                            <div class="shares">
                                <input type="number" min="0" step="1" id="shares" name="shares" class="shares form-control" placeholder="${asset}" />
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="avg-buy">
                                <div class="dollar-input">
                                    <div class="dollar-sign">$</div>
                                    <input type="number" min="0" step="1" id="avg-buy" name="avg-buy" class="avg-buy form-control price" placeholder="Avg Buy" />
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="cost">
                                <div class="dollar-input">
                                    <div class="dollar-sign">$</div>
                                    <input type="number" min="0" step="1" id="cost" name="cost" class="total form-control price" placeholder="Cost" />
                                </div>
                            </div>
                            </div>
                            <button class="btn btn-danger btn-remove">X</button>
                        </div>
                            
                    </div>
                    `;

    jQuery(".next-investment").append(newRow);
  });
  jQuery(document).on("click", ".btn-reset", function () {
    jQuery("input").val("");
    jQuery("input.shares").val("");
    jQuery("input.avg-buy").val("");
    jQuery("input.total").val("");
    jQuery("#total-shares").val("0");
    jQuery("#cost-average").val("0");
    jQuery("#total-cost").val("0");
    jQuery(".additional-rows").remove();
  });
});
