<?php

/*
 
Plugin Name: DCA Calculator
Plugin URI: https://dcaprofit.com/
Description: DCA Calculator
Version: 1.0.2
Author: Harsh Ganatra
Author URI:  
License: GPLv2 or later
Text Domain: dcaprofit

*/


// register all custom shortcodes on init
add_action('init', 'dca_register_shortcodes' );

// wp_enqueue_script('jquery');

function dca_stylesAndScripts() {
    wp_register_style('calculatorStyle', plugins_url('/css/calculator.css',__FILE__ ), date("h:i:s"), true);
    wp_enqueue_style('calculatorStyle');
    // wp_register_script('calculatorScript', plugins_url('/js/calculator.js',__FILE__ ));
    wp_register_script('calculatorScript', plugins_url('/js/calculator.js',__FILE__ ), array( 'jquery' ), date("h:i:s"), true );
    wp_enqueue_script('calculatorScript');
}
add_action( 'wp_enqueue_scripts','dca_stylesAndScripts');

// register shortcode
function dca_register_shortcodes() {
    add_shortcode('dca_calculator_basic','dca_calculator_shortcode_stocks_basic');
}

add_shortcode('dca_calculator_crypto_coin_basic','dca_calculator_shortcode_coin_basic');
add_shortcode('dca_calculator_stocks_full','dca_calculator_shortcode_stocks_full');
add_shortcode('dca_calculator_crypto_coin_full','dca_calculator_shortcode_crytpo_coin_full');



// shortcode function
function dca_calculator_shortcode_stocks_basic($args, $content="") {

    $output = '';

    $output .= '<div class="dca dca-calculator">';
    

    // initial investment
    $output .= '<div class="initial-investment investment-box">';
    $output .= '<h6 class="dca-calculator-header">Initial Investment</h6>';
    $output .= '<div class="flex-row">';
    $output .= '<div class="form-group">';
    $output .= '<div class="shares">';
    $output .= '<label for="shares">Number of Shares</label>';
    $output .= '<input type="number" min="0" step="1"  id="shares" name="shares" class="shares form-control" placeholder="0" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="avg-buy">';
    $output .= '<label for="avg-buy">Avg Buy</label>';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="avg-buy" name="avg-buy" class="avg-buy form-control price" placeholder="0" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="cost">';
    $output .= '<label for="cost">Cost</label>';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1"  id="cost" name="cost" class="total form-control price" placeholder="0" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    // END - initial investment 
    
    // next investment
    $output .= '<div class="next-investment investment-box">';
    $output .= '<h6 class="dca-calculator-header">Next Investment</h6>';
    $output .= '<div class="flex-row">';
    $output .= '<div class="form-group">';
    $output .= '<div class="shares">';
    $output .= '<input type="number" min="0" step="1" id="shares" name="shares" class="shares form-control" placeholder="Number of Shares" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="avg-buy">';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="avg-buy" name="avg-buy" class="avg-buy form-control price" placeholder="Avg Buy" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="cost">';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="cost" name="cost" class="total form-control price" placeholder="Cost" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    // END - next investment

    // buttons
    $output .= '<div class="dca-buttons">';
    $output .= '<button class="dca-btn btn-add btn">Add</button>';
    $output .= '<button class="dca-btn btn-reset btn">Reset</button>';
    $output .= '</div>';
    $output .= '<div class="border-top">';
    $output .= '<button class="dca-btn btn-calculate btn">Calculate</button>';
    $output .= '</div>';
    // END - buttons

    // total investment
    $output .= '<div class="total-investment">';
    $output .= '<div class="flex-row">';
    $output .= '<div class="form-group">';
    $output .= '<div class="shares">';
    $output .= '<label for="total-shares">Total Shares</label>';
    $output .= '<input type="number" min="0" step="1" id="total-shares" name="total-shares" class="form-control total-shares" value="0" readonly />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="avg-buy">';
    $output .= '<label for="cost-average">Cost Average</label>';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="cost-average" name="cost-average" class="form-control price cost-average" value="0" readonly />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="cost">';
    $output .= '<label for="total-cost">Total Cost</label>';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="total-cost" name="total-cost" class="total-cost form-control price" value="0" readonly />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    // END - total investment
    $output .= '<h6 class="dca-calculator-header" p style="text-align:right;";> <a href="https://dcaprofit.com/"> Powered by DCA-Profit</h6>';



    // end plugin output - last div
    $output .= '</div>';

    // return results 
    return $output;

}

function dca_calculator_shortcode_coin_basic($args, $content="") {

    $output = '';

    $output .= '<div class="dca dca-calculator">';
    

    // initial investment
    $output .= '<div class="initial-investment investment-box">';
    $output .= '<h6 class="dca-calculator-header">First Time You Invested At Price:</h6>';
    $output .= '<div class="flex-row">';
    $output .= '<div class="form-group">';
    $output .= '<div class="shares">';
    $output .= '<label for="shares">Amount of coins</label>';
    $output .= '<input type="number" min="0" step="1"  id="shares" name="shares" class="shares form-control" placeholder="0" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="avg-buy">';
    $output .= '<label for="avg-buy">Avg Buy</label>';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="avg-buy" name="avg-buy" class="avg-buy form-control price" placeholder="0" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="cost">';
    $output .= '<label for="cost">Cost</label>';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1"  id="cost" name="cost" class="total form-control price" placeholder="0" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    // END - initial investment 
    
    // next investment
    $output .= '<div class="next-investment investment-box">';
    $output .= '<h6 class="dca-calculator-header">Bought The Dip At</h6>';
    $output .= '<div class="flex-row">';
    $output .= '<div class="form-group">';
    $output .= '<div class="shares">';
    $output .= '<input type="number" min="0" step="1" id="shares" name="shares" class="shares form-control" placeholder="Amount Of Coins" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="avg-buy">';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="avg-buy" name="avg-buy" class="avg-buy form-control price" placeholder="Avg Buy" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="cost">';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="cost" name="cost" class="total form-control price" placeholder="Cost" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    // END - next investment

    // buttons
    $output .= '<div class="dca-buttons">';
    $output .= '<button id="coins" class="dca-btn btn-add btn">Add</button>';
    $output .= '<button class="dca-btn btn-reset btn">Got Rekt / Reset Calculator</button>';
    $output .= '</div>';
    $output .= '<div class="border-top">';
    $output .= '<button class="dca-btn btn-calculate btn">Calculate Crypto Bags</button>';
    $output .= '</div>';
    // END - buttons

    // total investment
    $output .= '<div class="total-investment">';
    $output .= '<div class="flex-row">';
    $output .= '<div class="form-group">';
    $output .= '<div class="shares">';
    $output .= '<label for="total-shares">Total Coins</label>';
    $output .= '<input type="number" min="0" step="1" id="total-shares" name="total-shares" class="form-control total-shares" value="0" readonly />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="avg-buy">';
    $output .= '<label for="cost-average">Cost Average</label>';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="cost-average" name="cost-average" class="form-control price cost-average" value="0" readonly />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="cost">';
    $output .= '<label for="total-cost">Total Cost</label>';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="total-cost" name="total-cost" class="total-cost form-control price" value="0" readonly />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    // END - total investment
    $output .= '<h6 class="dca-calculator-header" p style="text-align:right;";> <a href="https://dcaprofit.com/"> Powered by DCA-Profit</h6>';



    // end plugin output - last div
    $output .= '</div>';

    // return results 
    return $output;

}

function dca_calculator_shortcode_stocks_full($args, $content="") {

    $output = '';

    $output .= '<div class="dca dca-calculator">';
    

    // initial investment
    $output .= '<div class="initial-investment investment-box">';
    $output .= '<h6 class="dca-calculator-header">Initial Investment</h6>';
    $output .= '<div class="flex-row">';
    $output .= '<div class="form-group">';
    $output .= '<div class="shares">';
    $output .= '<label for="shares">Number of Shares</label>';
    $output .= '<input type="number" min="0" step="1"  id="shares" name="shares" class="shares form-control" placeholder="0" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="avg-buy">';
    $output .= '<label for="avg-buy">Avg Buy</label>';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="avg-buy" name="avg-buy" class="avg-buy form-control price" placeholder="0" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="cost">';
    $output .= '<label for="cost">Cost</label>';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1"  id="cost" name="cost" class="total form-control price" placeholder="0" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    // END - initial investment 
    
    // next investment
    $output .= '<div class="next-investment investment-box">';
    $output .= '<h6 class="dca-calculator-header">Next Investment</h6>';
    $output .= '<div class="flex-row">';
    $output .= '<div class="form-group">';
    $output .= '<div class="shares">';
    $output .= '<input type="number" min="0" step="1" id="shares" name="shares" class="shares form-control" placeholder="Number of Shares" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="avg-buy">';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="avg-buy" name="avg-buy" class="avg-buy form-control price" placeholder="Avg Buy" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="cost">';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="cost" name="cost" class="total form-control price" placeholder="Cost" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    // END - next investment

    // buttons
    $output .= '<div class="dca-buttons">';
    $output .= '<button class="dca-btn btn-add btn">Add</button>';
    $output .= '</div>';
    // END - buttons

    // total investment
    $output .= '<div class="total-investment">';
    $output .= '<div class="flex-row">';
    $output .= '<div class="form-group">';
    $output .= '<div class="shares">';
    $output .= '<label for="total-shares">Total Shares</label>';
    $output .= '<input type="number" min="0" step="1" id="total-shares" name="total-shares" class="form-control total-shares" value="0" readonly />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="avg-buy">';
    $output .= '<label for="cost-average">Cost Average</label>';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="cost-average" name="cost-average" class="form-control price cost-average" value="0" readonly />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="cost">';
    $output .= '<label for="total-cost">Total Cost</label>';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="total-cost" name="total-cost" class="total-cost form-control price" value="0" readonly />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    // END - total investment

    // future investment
    $output .= '<div class="future-investment investment-box">';
    $output .= '<h6 class="dca-calculator-header">Calculate Future Profit</h6>';
    $output .= '<div class="flex-row">';
    $output .= '<div class="form-group">';
    $output .= '<div class="sell-price">';
    $output .= '<label for="sell-price">Predicted Sell Price</label>';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="sell-price" name="sell-price" class="sell-price form-control price" placeholder="0" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="total-value-assets">';
    $output .= '<label for="total-value-assets">Total Value of Assets</label>';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" readonly id="total-value-assets" name="total-value-assets" class="total-value-assets form-control price" placeholder="0" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="error">Enter selling price</div>';
    $output .= '<div class="total-returns">';
    $output .= 'Total <span id="status"></span> after Assets sold = $<span id="returns"><span>';
    $output .= '</div>';
    $output .= '</div>';
    // END - future investment 

    // buttons
    $output .= '<div class="border-top sp-border-top">';
    $output .= '<button class="dca-btn btn-calculate btn">Calculate Profit or Lose</button>';
    $output .= '<p align="right"><button class="dca-btn btn-reset btn">Got Rekt / Reset Calculator</button></p>';
    $output .= '</div>';
    $output .= '<h6 class="dca-calculator-header" p style="text-align:right;";> <a href="https://dcaprofit.com/"> Powered by DCA-Profit</h6>';
    // END - buttons 


    // end plugin output - last div
    $output .= '</div>';

    // return results 
    return $output;

}

function dca_calculator_shortcode_crytpo_coin_full($args, $content="") {


    $output = '';

    $output .= '<div class="dca dca-calculator">';
    

    // initial investment
    $output .= '<div class="initial-investment investment-box">';
    $output .= '<h6 class="dca-calculator-header">First Time You Invested At Price:</h6>';
    $output .= '<div class="flex-row">';
    $output .= '<div class="form-group">';
    $output .= '<div class="shares">';
    $output .= '<label for="shares">Amount of coins</label>';
    $output .= '<input type="number" min="0" step="1"  id="shares" name="shares" class="shares form-control" placeholder="0" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="avg-buy">';
    $output .= '<label for="avg-buy">Avg Buy</label>';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="avg-buy" name="avg-buy" class="avg-buy form-control price" placeholder="0" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="cost">';
    $output .= '<label for="cost">Cost</label>';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1"  id="cost" name="cost" class="total form-control price" placeholder="0" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    // END - initial investment 
    
    // next investment
    $output .= '<div class="next-investment investment-box">';
    $output .= '<h6 class="dca-calculator-header">Bought The Dip At:</h6>';
    $output .= '<div class="flex-row">';
    $output .= '<div class="form-group">';
    $output .= '<div class="shares">';
    $output .= '<input type="number" min="0" step="1" id="shares" name="shares" class="shares form-control" placeholder="Amount Of Coins" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="avg-buy">';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="avg-buy" name="avg-buy" class="avg-buy form-control price" placeholder="Avg Buy" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="cost">';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="cost" name="cost" class="total form-control price" placeholder="Cost" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    // END - next investment
    
    // buttons
    $output .= '<div class="dca-buttons">';
    $output .= '<button id="coins" class="dca-btn btn-add btn">Add</button>';
    $output .= '</div>';
    // END - buttons

    // total investment
    $output .= '<div class="total-investment">';
    $output .= '<div class="flex-row">';
    $output .= '<div class="form-group">';
    $output .= '<div class="shares">';
    $output .= '<label for="total-shares">Total Crypto Coins:</label>';
    $output .= '<input type="number" min="0" step="1" id="total-shares" name="total-shares" class="form-control total-shares" value="0" readonly />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="avg-buy">';
    $output .= '<label for="cost-average">Cost Average</label>';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="cost-average" name="cost-average" class="form-control price cost-average" value="0" readonly />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="cost">';
    $output .= '<label for="total-cost">Total Cost</label>';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="total-cost" name="total-cost" class="total-cost form-control price" value="0" readonly />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    // END - total investment

    // future investment
    $output .= '<div class="future-investment investment-box">';
    $output .= '<h6 class="dca-calculator-header">Calculate Gains or Loss If Sell At Price:</h6>';
    $output .= '<div class="flex-row">';
    $output .= '<div class="form-group">';
    $output .= '<div class="sell-price">';
    $output .= '<label for="sell-price">Sell At Price</label>';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" id="sell-price" name="sell-price" class="sell-price form-control price" placeholder="0" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="form-group">';
    $output .= '<div class="total-value-assets">';
    $output .= '<label for="total-value-assets">Total Value Of Your Crypto</label>';
    $output .= '<div class="dollar-input">';
    $output .= '<div class="dollar-sign">$</div>';
    $output .= '<input type="number" min="0" step="1" readonly id="total-value-assets" name="total-value-assets" class="total-value-assets form-control price" placeholder="0" />';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="error">Enter selling price</div>';
    $output .= '<div class="total-returns">';
    $output .= 'Total <span id="status"></span> After Crypto Sold = $<span id="returns"><span>';
    $output .= '</div>';
    $output .= '</div>';
    // END - future investment 

    // buttons
    $output .= '<div class="border-top sp-border-top">';
    $output .= '<button class="dca-btn btn-calculate btn">Calculate Gains or loss</button>';
    $output .= '<p align="right"><button class="dca-btn btn-reset btn">Got Rekt / Reset Calculator</button></p>';
    $output .= '</div>';
    $output .= '<h6 class="dca-calculator-header" p style="text-align:right;";> <a href="https://dcaprofit.com/"> Powered by DCA-Profit</h6>';
    // END - buttons 


    // end plugin output - last div
    $output .= '</div>';

    // return results 
    return $output;

}