<?php
/**
 * Class PostCheckout
 *
 * @package  Conexa\DappWoo\Gateway\PostCheckout
 */

namespace Conexa\DappWoo\Gateway;

use Conexa\DappWoo\Includes\Helper\Helper;
use Conexa\DappWoo\Sdk\DappWooSdk;
use \WC_Payment_Gateway;
use Conexa\DappWoo\Gateway\WC_DappWoo;

defined( 'ABSPATH' ) || exit();
/**
 * Post Checkout Page Controller
 */
class PostCheckout {

	/**
	 * Run Action
	 *
	 * @param int $order_id ID for WC Order.
	 *
	 * @return bool
	 */
	public static function render( $order_id ) {
		$order = wc_get_order( $order_id );

		if ( \DappWoo::GATEWAY_ID !== $order->get_payment_method() ) {
			return false;
		}

		?>
		<div id="alert_text"></div>
		<span class="cta-dapp-post-checkout" style="font-size:110%">
		<?php echo esc_html__( 'Haga clic en el botón para completar la compra', 'dappayments' ); ?>
		<span>
		<div class="checkout-top-div-container post-checkout">
		<a id="dapp-cta" class="button btn btn-primary">
			<span>
				<?php echo esc_html__( 'Paga con dapp® ', 'dappayments' ); ?> 
			</span>
			<img src="<?php echo esc_url( Helper::get_assets_folder_url() ); ?>/img/logotype_dapp_primary.png" alt="<?php echo esc_attr__( 'Dapp', 'dappayments' ); ?>">
		</a>
		<a id="select-gateway" class="button btn btn-secondary" href="<?php echo esc_url( $order->get_checkout_payment_url( false ) ); ?>">
			<span>
				<?php echo esc_html__( 'Seleccione otro método de pago', 'dappayments' ); ?> 
			</span>			
		</a>
		</div>		

		<?php
			$dapp_cta_flag = isset( $_GET['dapp_cta'] ) ? 'true' : 'false';
		if ( ! isset( $_GET['dapp_nonce'] ) ) {
			$dapp_cta_flag = 'false';
		} else {
			if ( ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_GET['dapp_nonce'] ) ), \DappWoo::GATEWAY_ID ) ) {
				$dapp_cta_flag = 'false';
			}
		}

		$wc_dapp_settings = [
			'action' => 'dapp_request_deposit_action',
			'ajax_url'	=> esc_url( admin_url( 'admin-ajax.php' ) ),
			'order_id' => esc_html( $order_id ),
			'spinner_id' => 'dapp-container-spinner',
			'spinner_url' => esc_url( Helper::get_assets_folder_url() ) . '/img/loading-spinner.png',
			'ajax_nonce' => esc_attr( wp_create_nonce( \DappWoo::GATEWAY_ID )),
			'dapp_cta_flag' => esc_html( $dapp_cta_flag ),
		];
		
		wp_localize_script('dapp-gateway', 'wc_dapp_settings', $wc_dapp_settings);

		wp_enqueue_script( 'dapp-gateway' );

		return true;
	}
}
