<?php
/**
 * Class DappWoo Api Class
 *
 * @package  Conexa\DappWoo\Api;
 */

namespace Conexa\DappWoo\Api;

use Conexa\DappWoo\Includes\Helper\Helper;

defined( 'ABSPATH' ) || exit();
/**
 * DappWoo API Class
 */
class DappWooApi extends \Conexa\DappWoo\Includes\Api\ApiConnector implements \Conexa\DappWoo\Includes\Api\ApiInterface {

	const API_BASE_URL = 'https://api.dapp.mx/v2';

	/**
	 * Class Constructor
	 *
	 * @param array $settings DappWoo Settings Object.
	 */
	public function __construct( array $settings = array() ) {
		$this->api_token = $settings['api_token'];
		$this->debug     = $settings['debug'];
	}

	/**
	 *  Get Base Url
	 *
	 * @return String
	 */
	public function get_base_url() {
		return $this::API_BASE_URL;
	}
}
