(function ($) {
  "use strict";

  var $input = $("#wcpdu-upload-image");
  if (!$input.length) return;

  $input.on("change", function () {
    var file = this.files && this.files[0] ? this.files[0] : null;

    var $nameSpan = $("#file-name");
    if (!$nameSpan.length) return;

    if (!file) {
      $nameSpan.text(wcpduCustomizer?.uploadLabel || "Click to upload");
      return;
    }

    $nameSpan.text(file.name);
  });

  function openModal() {
    $("#wcpdu-customizer-modal").attr("aria-hidden", "false").show();
    $("body").addClass("wcpdu-modal-open");
  }

  function closeModal() {
    $("#wcpdu-customizer-modal").attr("aria-hidden", "true").hide();
    $("body").removeClass("wcpdu-modal-open");
  }

  function getCanvasDataURL() {
    if (!window.wcpduFabricCanvas) return "";

    window.wcpduFabricCanvas.discardActiveObject();
    window.wcpduFabricCanvas.renderAll();

    var targetSize = 1024;
    var w =
      typeof window.wcpduFabricCanvas.getWidth === "function"
        ? window.wcpduFabricCanvas.getWidth()
        : 0;
    var h =
      typeof window.wcpduFabricCanvas.getHeight === "function"
        ? window.wcpduFabricCanvas.getHeight()
        : 0;

    var base = Math.max(w, h);
    var multiplier = 1;

    if (base > 0) {
      multiplier = targetSize / base;
      if (!isFinite(multiplier) || multiplier <= 0) {
        multiplier = 1;
      }
    }

    try {
      return window.wcpduFabricCanvas.toDataURL({
        format: "png",
        quality: 1,
        multiplier: multiplier,
      });
    } catch (e) {
      return "";
    }
  }

  function updateWooProductGallery(dataUrl) {
    if (!dataUrl) return;

    var $gallery = $(".woocommerce-product-gallery");
    var $mainImg = $gallery.find("img.wp-post-image").first();

    if (!$mainImg.length) {
      $mainImg = $gallery.find("img").first();
    }
    if (!$mainImg.length) return;

    $mainImg.attr("src", dataUrl);
    $mainImg.attr("data-src", dataUrl);
    $mainImg.attr("data-large_image", dataUrl);
    $mainImg.attr("data-large_image_width", "1024");
    $mainImg.attr("data-large_image_height", "1024");
    $mainImg.attr("srcset", "");
    $mainImg.attr("sizes", "");

    var $link = $mainImg.closest("a");
    if ($link.length) {
      $link.attr("href", dataUrl);
    }

    var $zoomImg = $(".zoomImg");
    if ($zoomImg.length) {
      $zoomImg.attr("src", dataUrl);
    }

    $zoomImg.remove();

    try {
      if ($mainImg.data("elevateZoom")) {
        $mainImg.data("elevateZoom").destroy();
        $mainImg.removeData("elevateZoom");
        $(".zoomContainer").remove();
      }
    } catch (e) {}

    var $thumb = $(
      ".flex-control-nav img, .woocommerce-product-gallery__thumbs img"
    ).first();
    if ($thumb.length) {
      $thumb.attr("src", dataUrl);
      $thumb.attr("data-src", dataUrl);
      $thumb.attr("srcset", "");
      $thumb.attr("sizes", "");
    }

    if ($gallery.length) {
      $gallery.trigger("woocommerce_gallery_init");
      $gallery.trigger("wc-product-gallery-after-init");
      $gallery.trigger("resize");
    }
  }

  $(document).on("click", ".wcpdu-open-customizer", function (e) {
    e.preventDefault();
    openModal();
  });

  $(document).on("click", "[data-wcpdu-modal-close]", function (e) {
    e.preventDefault();
    closeModal();
  });

  $(document).on("keydown", function (e) {
    if (e.key === "Escape") {
      if ($("#wcpdu-customizer-modal").is(":visible")) {
        closeModal();
      }
    }
  });

  $(document).on("click", ".wcpdu-apply", function (e) {
    e.preventDefault();

    if (
      window.wcpduFabricCanvas &&
      typeof window.wcpduFabricCanvas.discardActiveObject === "function"
    ) {
      window.wcpduFabricCanvas.discardActiveObject();
      if (typeof window.wcpduFabricCanvas.renderAll === "function") {
        window.wcpduFabricCanvas.renderAll();
      }
    }

    var dataUrl = getCanvasDataURL();
    if (!dataUrl) {
      closeModal();
      return;
    }

    $("#wcpdu-custom-design").val(dataUrl);
    updateWooProductGallery(dataUrl);
    closeModal();
  });
})(jQuery);
