<?php

/**
 * Layout: Parallax Rocket
 * Preview: preview-parallax-rocket.png
 *
 * Parallax scrolling effect with rocket launch animation
 */
if (! defined('ABSPATH')) exit;

// Calculate countdown target if auto-end is enabled
$dailybuddy_show_countdown = false;
$dailybuddy_countdown_timestamp = 0;

if (!empty($settings['auto_end_enabled']) && !empty($settings['auto_end_datetime'])) {
    $dailybuddy_show_countdown = true;
    $dailybuddy_countdown_timestamp = strtotime($settings['auto_end_datetime']);
}
?>

<div class="layout-parallax-rocket">
    <ul class="scene">
        <!-- Content Layer -->
        <li class="layer" data-depth="0.40">
            <div class="content">
                <h1 class="dailybuddy-under-construction-title">
                    <?php echo esc_html($settings['title']); ?>
                </h1>
                <p class="dailybuddy-under-construction-message">
                    <?php echo esc_html($settings['message']); ?>
                </p>

                <?php if ($dailybuddy_show_countdown) : ?>
                    <!-- Countdown Timer -->
                    <div class="countdown-timer" data-target-time="<?php echo absint($dailybuddy_countdown_timestamp); ?>">
                        <div class="countdown-item">
                            <span class="countdown-number" id="pr-days">00</span>
                            <span class="countdown-label"><?php esc_html_e('Days', 'dailybuddy'); ?></span>
                        </div>

                        <div class="countdown-item">
                            <span class="countdown-number" id="pr-hours">00</span>
                            <span class="countdown-label"><?php esc_html_e('Hours', 'dailybuddy'); ?></span>
                        </div>

                        <div class="countdown-item">
                            <span class="countdown-number" id="pr-minutes">00</span>
                            <span class="countdown-label"><?php esc_html_e('Minutes', 'dailybuddy'); ?></span>
                        </div>

                        <div class="countdown-item">
                            <span class="countdown-number" id="pr-seconds">00</span>
                            <span class="countdown-label"><?php esc_html_e('Seconds', 'dailybuddy'); ?></span>
                        </div>
                    </div>

                <?php endif; ?>
            </div>
        </li>

        <!-- Footer Layer -->
        <li class="layer" data-depth="1.00">
            <div class="footer"></div>
        </li>

        <!-- Rocket Layer -->
        <li class="layer" data-depth="0.70">
            <div class="rocket-container">
                <svg class="rocket-svg" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img" preserveAspectRatio="xMidYMid meet">
                    <path fill="#FFB636" d="M204.854 309.75l.668 1.748c.208.564.522 1.32.791 2.115l.971 2.795c.38 1.069.689 2.149 1.094 3.4c.386 1.234.843 2.615 1.201 3.973l1.25 4.47c.412 1.558.758 3.122 1.175 4.826a162.186 162.186 0 0 1 3.798 22.366c.426 4.01.607 8.007.696 12.117c.006 4.028-.091 8.159-.468 12.194a101.15 101.15 0 0 1-1.825 11.94a84.231 84.231 0 0 1-3.351 11.379c-2.757 7.354-6.624 14.15-11.647 20.157c-2.485 3.031-5.389 5.734-8.266 8.533c-2.918 2.758-5.904 5.517-9.021 8.191a238.747 238.747 0 0 1-19.729 15.385c-6.908 4.858-14.174 9.358-21.627 13.487a259.059 259.059 0 0 1-11.347 5.865a260.232 260.232 0 0 1-11.582 5.217c-7.784 3.247-15.627 6.066-23.403 8.401a238.5 238.5 0 0 1-22.815 5.681c-14.714 2.934-28.219 4.137-38.257 4.394l-3.589.062l-3.223-.003l-5.218-.139l-3.345-.196l-1.182-.102l-.102-1.182l-.196-3.345l-.139-5.218l-.003-3.223l.062-3.589c.257-10.038 1.459-23.543 4.394-38.257a238.936 238.936 0 0 1 5.68-22.815c2.335-7.776 5.154-15.62 8.401-23.403a260.75 260.75 0 0 1 5.217-11.582c1.86-3.816 3.81-7.611 5.865-11.347c4.129-7.453 8.629-14.719 13.487-21.627a238.532 238.532 0 0 1 15.385-19.729c2.674-3.117 5.432-6.104 8.191-9.021c2.799-2.877 5.502-5.781 8.533-8.266c6.008-5.023 12.803-8.89 20.157-11.647a84.376 84.376 0 0 1 11.379-3.351a101.15 101.15 0 0 1 11.94-1.825c4.035-.377 8.167-.474 12.194-.468c4.11.088 8.106.27 12.117.696a162.035 162.035 0 0 1 22.366 3.798c1.703.416 3.267.763 4.826 1.175l4.47 1.25c1.358.359 2.74.815 3.973 1.201c1.252.404 2.331.714 3.4 1.094l2.795.971c.795.269 1.551.583 2.115.791c1.149.435 1.744.663 1.744.663z" />
                    <path fill="#FF473E" d="M76.86 181.752L4.346 254.266c-5.012 5.012-1.462 13.582 5.626 13.582h60.945c2.11 0 4.134.838 5.626 2.33l39.572 39.572l64.271-130.328h-97.9a7.952 7.952 0 0 0-5.626 2.33z" />
                    <path fill="#FF473E" d="M216.161 392.592l39.572 39.572a7.957 7.957 0 0 1 2.33 5.626v60.945c0 7.088 8.57 10.638 13.582 5.626l72.514-72.514a7.957 7.957 0 0 0 2.33-5.626v-97.9l-130.328 64.271z" />
                    <path fill="#ADBBBC" d="M505.647 17.875l.077.637c.047.419.139 1.065.205 1.862c.131 1.593.428 4.061.569 7.033c.452 6.114.756 14.721.543 25.076c-.207 10.361-.937 22.464-2.519 35.602c-.354 3.326-.859 6.619-1.347 10.041c-.453 3.457-1.098 6.834-1.687 10.373c-1.21 7.047-2.72 14.218-4.463 21.533a361.335 361.335 0 0 1-13.805 44.697c-5.738 15.021-12.624 30.025-20.695 44.6c-8.083 14.563-17.278 28.768-27.555 42.27c-10.263 13.515-21.594 26.34-33.751 38.338c-12.157 11.999-25.124 23.187-38.748 33.341c-3.407 2.537-6.834 5.032-10.338 7.419c-3.466 2.426-7.007 4.746-10.536 7.044c-7.092 4.562-14.334 8.831-21.651 12.837a361.966 361.966 0 0 1-44.669 20.626a372.522 372.522 0 0 1-44.644 13.858c-7.299 1.759-14.432 3.307-21.467 4.528l-5.179.933c-1.716.294-3.457.536-5.147.801l-5.015.765l-4.974.633c-13.067 1.653-25.09 2.463-35.375 2.746c-10.274.294-18.832.04-24.876-.343c-2.942-.111-5.394-.393-6.968-.504c-.789-.058-1.43-.145-1.844-.187l-.631-.07c-4.782-.533-8.409-4.329-8.919-8.919l-.07-.63c-.042-.414-.129-1.055-.187-1.844c-.111-1.574-.393-4.025-.504-6.968c-.382-6.044-.636-14.601-.343-24.876c.283-10.285 1.093-22.308 2.746-35.375l.633-4.974l.765-5.015c.265-1.69.508-3.43.801-5.147l.933-5.179c1.221-7.035 2.769-14.168 4.528-21.467a372.104 372.104 0 0 1 13.858-44.644a362.26 362.26 0 0 1 20.626-44.669c4.007-7.316 8.276-14.559 12.837-21.651c2.298-3.529 4.618-7.07 7.044-10.536c2.387-3.505 4.882-6.931 7.419-10.338c10.154-13.624 21.342-26.592 33.341-38.748c11.998-12.157 24.823-23.488 38.338-33.751c13.502-10.276 27.707-19.472 42.27-27.555c14.575-8.071 29.58-14.957 44.6-20.695a361.335 361.335 0 0 1 44.697-13.805c7.315-1.743 14.486-3.253 21.533-4.463c3.539-.589 6.916-1.234 10.373-1.687c3.422-.488 6.714-.994 10.041-1.347c13.138-1.582 25.241-2.312 35.602-2.519c10.355-.213 18.962.09 25.076.543c2.972.141 5.44.439 7.033.569c.797.066 1.443.157 1.862.205l.637.077c4.769.575 8.37 4.354 8.92 8.919z" />
                    <path fill="#FF473E" d="M243.106 271.497l.583 1.577c.325.981.763 2.392 1.065 3.964c.716 3.255.953 7.217-.341 10.663c-.638 1.732-1.818 3.176-2.929 4.922l-3.693 5.555l-8.865 13.312a1631.323 1631.323 0 0 1-10.652 15.587a1262.693 1262.693 0 0 1-12.115 17.172l-6.51 8.959l-6.764 9.085c-4.589 6.076-9.285 12.215-14.06 18.274a1161.386 1161.386 0 0 1-14.364 17.97c-4.781 5.885-9.469 11.692-14.083 17.235l-6.769 8.192c-2.242 2.646-4.281 5.389-6.649 7.677c-2.353 2.302-5.068 4.116-8.188 5.376c-3.093 1.287-6.479 2.133-9.753 2.923a195.747 195.747 0 0 1-18.695 3.482c-2.904.397-5.681.709-8.304.944c-2.609.248-5.133.347-7.345.506c-2.229.141-4.357.129-6.135.192c-1.805.036-3.43-.023-4.702-.025c-1.299-.029-2.337-.094-3.016-.117l-1.066-.072l-.072-1.066c-.023-.679-.088-1.718-.117-3.016c-.002-1.272-.061-2.896-.025-4.702c.062-1.779.051-3.906.192-6.135c.158-2.212.258-4.736.506-7.345c.234-2.622.546-5.4.944-8.304a195.747 195.747 0 0 1 3.482-18.695c.79-3.273 1.636-6.659 2.923-9.753c1.26-3.121 3.074-5.835 5.376-8.188c2.288-2.367 5.031-4.406 7.678-6.648l8.192-6.769c5.543-4.614 11.35-9.303 17.235-14.083c5.875-4.79 11.893-9.607 17.97-14.364c6.059-4.776 12.198-9.471 18.274-14.06l9.085-6.764l8.959-6.51a1271.61 1271.61 0 0 1 17.172-12.115c5.5-3.811 10.739-7.375 15.587-10.652l13.312-8.865l5.555-3.693c1.745-1.111 3.189-2.291 4.922-2.929c3.446-1.294 7.408-1.057 10.663-.341c1.572.302 2.983.74 3.964 1.065l1.573.579z" />
                    <path fill="#2B3B47" d="M362.113 206.66c0 29.917-24.253 54.17-54.17 54.17s-54.17-24.253-54.17-54.17s24.253-54.17 54.17-54.17s54.17 24.253 54.17 54.17zm27.229-115.881c-19.044 0-34.482 15.438-34.482 34.482s15.438 34.482 34.482 34.482s34.482-15.438 34.482-34.482s-15.438-34.482-34.482-34.482z" />
                </svg>
            </div>
        </li>
    </ul>

    <!-- Social Links -->
    <?php if (!empty($dailybuddy_social_html)) : ?>
        <div class="social">
            <?php echo wp_kses_post($dailybuddy_social_html); ?>
        </div>
    <?php endif; ?>
</div>