<?php
declare(strict_types=1);


namespace DailyTarot\Support;
if (!defined('ABSPATH')) { exit; }


final class SpreadSettings {

    private const OPT = 'dtarot_spread_settings_v1';

    /** @return array<string,mixed> */
    public static function get(): array {
        $raw = get_option(self::OPT, []);
        if (!is_array($raw)) $raw = [];

        $preset = isset($raw['default_preset']) && is_string($raw['default_preset']) ? sanitize_key($raw['default_preset']) : 'three_card';
        if (!in_array($preset, SpreadPresets::ids(), true)) {
            $preset = 'three_card';
        }

        $pack = isset($raw['default_pack']) && is_string($raw['default_pack']) ? sanitize_key($raw['default_pack']) : 'default';
        if ($pack === '') $pack = 'default';

        $deckId = isset($raw['default_deck_id']) ? (int)$raw['default_deck_id'] : 0;

        $showTitles = !isset($raw['show_titles']) ? true : ((string)$raw['show_titles'] === '1');
        $showMeanings = !isset($raw['show_meanings']) ? true : ((string)$raw['show_meanings'] === '1');
        $showLabels = !isset($raw['show_labels']) ? true : ((string)$raw['show_labels'] === '1');
        $linkCards = !isset($raw['link_cards']) ? true : ((string)$raw['link_cards'] === '1');

        return [
            'default_preset' => $preset,
            'default_pack' => $pack,
            'default_deck_id' => $deckId,
            'show_titles' => $showTitles ? '1' : '0',
            'show_meanings' => $showMeanings ? '1' : '0',
            'show_labels' => $showLabels ? '1' : '0',
            'link_cards' => $linkCards ? '1' : '0',
        ];
    }

    public static function set(array $next): void {
        $preset = isset($next['default_preset']) ? sanitize_key((string)$next['default_preset']) : 'three_card';
        if (!in_array($preset, SpreadPresets::ids(), true)) {
            $preset = 'three_card';
        }
        $pack = isset($next['default_pack']) ? sanitize_key((string)$next['default_pack']) : 'default';
        if ($pack === '') $pack = 'default';

        $deckId = isset($next['default_deck_id']) ? (int)$next['default_deck_id'] : 0;
        if ($deckId < 0) $deckId = 0;

        $raw = [
            'default_preset' => $preset,
            'default_pack' => $pack,
            'default_deck_id' => $deckId,
            'show_titles' => !empty($next['show_titles']) ? '1' : '0',
            'show_meanings' => !empty($next['show_meanings']) ? '1' : '0',
            'show_labels' => !empty($next['show_labels']) ? '1' : '0',
            'link_cards' => !empty($next['link_cards']) ? '1' : '0',
        ];

        update_option(self::OPT, $raw, false);
        if (function_exists('wp_cache_delete')) {
            wp_cache_delete(self::OPT, 'options');
            wp_cache_delete('alloptions', 'options');
        }
    }
}
