<?php
declare(strict_types=1);


namespace DailyTarot\Support;
if (!defined('ABSPATH')) { exit; }


use DailyTarot\Registry\Cards;
use DailyTarot\Frontend\Shortcodes;
use DailyTarot\Support\DefaultDecks;

final class SpreadPreview {

    public static function render(string $preset, string $pack, int $deckId): string {
        $preset = sanitize_key($preset);
        $pack = sanitize_key($pack);

        if ($deckId <= 0) {
            $deckId = DefaultDecks::get(Cards::SYSTEM_TAROT);
        }
        if ($deckId <= 0) return '<div class="dtarot-frontend dtarot-frontend-empty">'.esc_html__('No deck available for preview.','daily-tarot').'</div>';

        $system = Cards::normalizeSystem((string)get_post_meta($deckId, '_dtarot_system', true));
        if ($system === '') $system = Cards::SYSTEM_TAROT;

        $presetDef = SpreadPresets::get($preset);
        $slots = $presetDef ? $presetDef['slots'] : [];
        $slotCount = count($slots);
        if ($slotCount <= 0) $slotCount = 3;

        $cards = Cards::forSystem($system);
        $cardIds = array_keys($cards);
        if (!$cardIds) return '<div class="dtarot-frontend dtarot-frontend-empty">'.esc_html__('No cards available for preview.','daily-tarot').'</div>';

        shuffle($cardIds);
        $picked = array_slice($cardIds, 0, $slotCount);
        $cardsAttr = implode(',', $picked);

        return Shortcodes::render_spread([
            'deck_id' => (string)$deckId,
            'cards' => $cardsAttr,
            'columns' => (string)min(4, max(2, $slotCount)),
            'titles' => '1',
            'link' => '0',
            'preset' => $preset,
            'spread_pack' => $pack,
            'show_labels' => '1',
            'show_meanings' => '1',
        ]);
    }
}
