<?php
declare(strict_types=1);


namespace DailyTarot\Support;
if (!defined('ABSPATH')) { exit; }


final class SpreadPresets {

    /**
     * @return array<string,array{label:string,description:string,slots:array<int,array{label:string}>}>
     */
    public static function all(): array {
        return [
            'single_card' => [
                'label' => __('Single Card','daily-tarot'),
                'description' => __('A single message card.','daily-tarot'),
                'slots' => [
                    ['label' => __('Message','daily-tarot'), 'x' => 0.5, 'y' => 0.5],
                ],
            ],
            'two_card' => [
                'label' => __('Two Card Spread','daily-tarot'),
                'description' => __('A two-card balance or advice spread.','daily-tarot'),
                'slots' => [
                    ['label' => __('You / Situation','daily-tarot')],
                    ['label' => __('Advice / Other','daily-tarot')],
                ],
            ],
            'three_card' => [
                'label' => __('Three Card (Past / Present / Future)','daily-tarot'),
                'description' => __('A simple 3-card spread for timeline readings.','daily-tarot'),
                'slots' => [
                    ['label' => __('Past','daily-tarot')],
                    ['label' => __('Present','daily-tarot')],
                    ['label' => __('Future','daily-tarot')],
                ],
            ],
            'four_card' => [
                'label' => __('Four Card (Situation / Challenge / Advice / Outcome)','daily-tarot'),
                'description' => __('A balanced 4-card spread for problem solving.','daily-tarot'),
                'slots' => [
                    ['label' => __('Situation','daily-tarot'), 'x' => 0.5, 'y' => 0.25],
                    ['label' => __('Challenge','daily-tarot'), 'x' => 0.5, 'y' => 0.75],
                    ['label' => __('Advice','daily-tarot'), 'x' => 0.25, 'y' => 0.5],
                    ['label' => __('Outcome','daily-tarot'), 'x' => 0.75, 'y' => 0.5],
                ],
            ],
            'five_cross' => [
                'label' => __('Five Card Cross','daily-tarot'),
                'description' => __('A cross layout with a central theme and surrounding influences.','daily-tarot'),
                'slots' => [
                    ['label' => __('Center','daily-tarot'), 'x' => 0.5, 'y' => 0.5],
                    ['label' => __('Above','daily-tarot'), 'x' => 0.5, 'y' => 0.25],
                    ['label' => __('Below','daily-tarot'), 'x' => 0.5, 'y' => 0.75],
                    ['label' => __('Left','daily-tarot'), 'x' => 0.3, 'y' => 0.5],
                    ['label' => __('Right','daily-tarot'), 'x' => 0.7, 'y' => 0.5],
                ],
            ],
            'celtic_cross' => [
                'label' => __('Celtic Cross','daily-tarot'),
                'description' => __('Classic 10-card Celtic Cross.','daily-tarot'),
                'slots' => [
                    ['label' => __('Present','daily-tarot'), 'x' => 0.4, 'y' => 0.45],
                    ['label' => __('Challenge','daily-tarot'), 'x' => 0.4, 'y' => 0.55],
                    ['label' => __('Subconscious / Root','daily-tarot'), 'x' => 0.4, 'y' => 0.55],
                    ['label' => __('Past','daily-tarot'), 'x' => 0.3, 'y' => 0.45],
                    ['label' => __('Conscious / Goal','daily-tarot'), 'x' => 0.4, 'y' => 0.3],
                    ['label' => __('Near Future','daily-tarot'), 'x' => 0.55, 'y' => 0.45],
                    ['label' => __('Self','daily-tarot'), 'x' => 0.7, 'y' => 0.35],
                    ['label' => __('Environment','daily-tarot'), 'x' => 0.7, 'y' => 0.45],
                    ['label' => __('Hopes & Fears','daily-tarot'), 'x' => 0.7, 'y' => 0.55],
                    ['label' => __('Outcome','daily-tarot'), 'x' => 0.7, 'y' => 0.65],
                ],
            ],
            'relationship' => [
                'label' => __('Relationship Spread','daily-tarot'),
                'description' => __('Relationship insight with 7 positions.','daily-tarot'),
                'slots' => [
                    ['label' => __('You','daily-tarot'), 'x' => 0.25, 'y' => 0.35],
                    ['label' => __('Partner','daily-tarot'), 'x' => 0.75, 'y' => 0.35],
                    ['label' => __('Relationship Energy','daily-tarot'), 'x' => 0.5, 'y' => 0.35],
                    ['label' => __('Strengths','daily-tarot'), 'x' => 0.25, 'y' => 0.55],
                    ['label' => __('Weaknesses','daily-tarot'), 'x' => 0.5, 'y' => 0.55],
                    ['label' => __('Advice','daily-tarot'), 'x' => 0.75, 'y' => 0.55],
                    ['label' => __('Outcome','daily-tarot'), 'x' => 0.5, 'y' => 0.75],
                ],
            ],
            'you_me_us' => [
                'label' => __('You Me Us','daily-tarot'),
                'description' => __('A 3-card relationship snapshot.','daily-tarot'),
                'slots' => [
                    ['label' => __('You','daily-tarot'), 'x' => 0.2, 'y' => 0.5],
                    ['label' => __('Us','daily-tarot'), 'x' => 0.5, 'y' => 0.5],
                    ['label' => __('Them','daily-tarot'), 'x' => 0.8, 'y' => 0.5],
                ],
            ],
            'compatibility' => [
                'label' => __('Compatibility Spread','daily-tarot'),
                'description' => __('Compatibility across needs and expectations.','daily-tarot'),
                'slots' => [
                    ['label' => __('Your Needs','daily-tarot'), 'x' => 0.2, 'y' => 0.35],
                    ['label' => __('Their Needs','daily-tarot'), 'x' => 0.2, 'y' => 0.55],
                    ['label' => __('Your Expectations','daily-tarot'), 'x' => 0.4, 'y' => 0.35],
                    ['label' => __('Their Expectations','daily-tarot'), 'x' => 0.4, 'y' => 0.55],
                    ['label' => __('Emotional Connection','daily-tarot'), 'x' => 0.6, 'y' => 0.35],
                    ['label' => __('Strength of Bond','daily-tarot'), 'x' => 0.6, 'y' => 0.55],
                    ['label' => __('Long-Term Potential','daily-tarot'), 'x' => 0.8, 'y' => 0.35],
                ],
            ],
            'shadow_work' => [
                'label' => __('Shadow Work Spread','daily-tarot'),
                'description' => __('A 5-card shadow work spread.','daily-tarot'),
                'slots' => [
                    ['label' => __('Hidden Shadow','daily-tarot'), 'x' => 0.5, 'y' => 0.2],
                    ['label' => __('Origin','daily-tarot'), 'x' => 0.2, 'y' => 0.5],
                    ['label' => __('Impact','daily-tarot'), 'x' => 0.5, 'y' => 0.5],
                    ['label' => __('What It Needs','daily-tarot'), 'x' => 0.8, 'y' => 0.5],
                    ['label' => __('Integration','daily-tarot'), 'x' => 0.5, 'y' => 0.8],
                ],
            ],
            'inner_child' => [
                'label' => __('Inner Child Spread','daily-tarot'),
                'description' => __('A 5-card inner child healing spread.','daily-tarot'),
                'slots' => [
                    ['label' => __('Wound','daily-tarot'), 'x' => 0.5, 'y' => 0.85],
                    ['label' => __('Protective Self','daily-tarot'), 'x' => 0.2, 'y' => 0.6],
                    ['label' => __('Inner Child Voice','daily-tarot'), 'x' => 0.5, 'y' => 0.55],
                    ['label' => __('Healing Path','daily-tarot'), 'x' => 0.8, 'y' => 0.6],
                    ['label' => __('Integration','daily-tarot'), 'x' => 0.5, 'y' => 0.25],
                ],
            ],
            'career_path' => [
                'label' => __('Career Path Spread','daily-tarot'),
                'description' => __('Career insight in two rows.','daily-tarot'),
                'slots' => [
                    ['label' => __('Current Situation','daily-tarot'), 'x' => 0.2, 'y' => 0.4],
                    ['label' => __('Strengths','daily-tarot'), 'x' => 0.35, 'y' => 0.4],
                    ['label' => __('Weaknesses','daily-tarot'), 'x' => 0.5, 'y' => 0.4],
                    ['label' => __('Purpose','daily-tarot'), 'x' => 0.65, 'y' => 0.4],
                    ['label' => __('Opportunities','daily-tarot'), 'x' => 0.2, 'y' => 0.6],
                    ['label' => __('Challenges','daily-tarot'), 'x' => 0.5, 'y' => 0.6],
                    ['label' => __('Next Step','daily-tarot'), 'x' => 0.8, 'y' => 0.6],
                ],
            ],
            'decision' => [
                'label' => __('Decision Spread','daily-tarot'),
                'description' => __('Compare two options with advice and outcome.','daily-tarot'),
                'slots' => [
                    ['label' => __('Situation','daily-tarot'), 'x' => 0.5, 'y' => 0.25],
                    ['label' => __('Option A Pros','daily-tarot'), 'x' => 0.3, 'y' => 0.4],
                    ['label' => __('Option A Cons','daily-tarot'), 'x' => 0.3, 'y' => 0.5],
                    ['label' => __('Option B Pros','daily-tarot'), 'x' => 0.7, 'y' => 0.4],
                    ['label' => __('Option B Cons','daily-tarot'), 'x' => 0.7, 'y' => 0.5],
                    ['label' => __('Advice','daily-tarot'), 'x' => 0.5, 'y' => 0.6],
                    ['label' => __('Outcome','daily-tarot'), 'x' => 0.5, 'y' => 0.75],
                ],
            ],
            'year_ahead' => [
                'label' => __('Year Ahead Spread','daily-tarot'),
                'description' => __('A 13-card year overview.','daily-tarot'),
                'slots' => [
                    ['label' => __('January','daily-tarot'), 'x' => 0.5, 'y' => 0.1],
                    ['label' => __('February','daily-tarot'), 'x' => 0.65, 'y' => 0.18],
                    ['label' => __('March','daily-tarot'), 'x' => 0.8, 'y' => 0.3],
                    ['label' => __('April','daily-tarot'), 'x' => 0.9, 'y' => 0.45],
                    ['label' => __('May','daily-tarot'), 'x' => 0.8, 'y' => 0.6],
                    ['label' => __('June','daily-tarot'), 'x' => 0.65, 'y' => 0.72],
                    ['label' => __('July','daily-tarot'), 'x' => 0.5, 'y' => 0.8],
                    ['label' => __('August','daily-tarot'), 'x' => 0.35, 'y' => 0.72],
                    ['label' => __('September','daily-tarot'), 'x' => 0.2, 'y' => 0.6],
                    ['label' => __('October','daily-tarot'), 'x' => 0.1, 'y' => 0.45],
                    ['label' => __('November','daily-tarot'), 'x' => 0.2, 'y' => 0.3],
                    ['label' => __('December','daily-tarot'), 'x' => 0.35, 'y' => 0.18],
                    ['label' => __('Theme','daily-tarot'), 'x' => 0.5, 'y' => 0.45],
                ],
            ],
            'wheel_of_year' => [
                'label' => __('Wheel of the Year','daily-tarot'),
                'description' => __('Seasonal wheel spread.','daily-tarot'),
                'slots' => [
                    ['label' => __('Yule','daily-tarot'), 'x' => 0.5, 'y' => 0.15],
                    ['label' => __('Imbolc','daily-tarot'), 'x' => 0.7, 'y' => 0.25],
                    ['label' => __('Ostara','daily-tarot'), 'x' => 0.85, 'y' => 0.45],
                    ['label' => __('Beltane','daily-tarot'), 'x' => 0.7, 'y' => 0.65],
                    ['label' => __('Litha','daily-tarot'), 'x' => 0.5, 'y' => 0.8],
                    ['label' => __('Lammas','daily-tarot'), 'x' => 0.3, 'y' => 0.65],
                    ['label' => __('Mabon','daily-tarot'), 'x' => 0.15, 'y' => 0.45],
                    ['label' => __('Samhain','daily-tarot'), 'x' => 0.3, 'y' => 0.25],
                ],
            ],
            'chakra' => [
                'label' => __('Chakra Spread','daily-tarot'),
                'description' => __('A vertical 7-card chakra alignment.','daily-tarot'),
                'slots' => [
                    ['label' => __('Root','daily-tarot'), 'x' => 0.5, 'y' => 0.85],
                    ['label' => __('Sacral','daily-tarot'), 'x' => 0.5, 'y' => 0.75],
                    ['label' => __('Solar Plexus','daily-tarot'), 'x' => 0.5, 'y' => 0.65],
                    ['label' => __('Heart','daily-tarot'), 'x' => 0.5, 'y' => 0.55],
                    ['label' => __('Throat','daily-tarot'), 'x' => 0.5, 'y' => 0.45],
                    ['label' => __('Third Eye','daily-tarot'), 'x' => 0.5, 'y' => 0.35],
                    ['label' => __('Crown','daily-tarot'), 'x' => 0.5, 'y' => 0.25],
                ],
            ],
            'elemental' => [
                'label' => __('Elemental Spread','daily-tarot'),
                'description' => __('Earth, Air, Fire, Water, Spirit.','daily-tarot'),
                'slots' => [
                    ['label' => __('Earth','daily-tarot'), 'x' => 0.25, 'y' => 0.6],
                    ['label' => __('Air','daily-tarot'), 'x' => 0.5, 'y' => 0.2],
                    ['label' => __('Fire','daily-tarot'), 'x' => 0.75, 'y' => 0.6],
                    ['label' => __('Water','daily-tarot'), 'x' => 0.5, 'y' => 0.85],
                    ['label' => __('Spirit','daily-tarot'), 'x' => 0.5, 'y' => 0.5],
                ],
            ],
            'horseshoe' => [
                'label' => __('Horseshoe Spread','daily-tarot'),
                'description' => __('A 7-card horseshoe.','daily-tarot'),
                'slots' => [
                    ['label' => __('Past','daily-tarot'), 'x' => 0.15, 'y' => 0.6],
                    ['label' => __('Present','daily-tarot'), 'x' => 0.3, 'y' => 0.45],
                    ['label' => __('Hidden Influences','daily-tarot'), 'x' => 0.45, 'y' => 0.35],
                    ['label' => __('Obstacles','daily-tarot'), 'x' => 0.6, 'y' => 0.3],
                    ['label' => __('External Influences','daily-tarot'), 'x' => 0.75, 'y' => 0.35],
                    ['label' => __('Best Course','daily-tarot'), 'x' => 0.9, 'y' => 0.45],
                    ['label' => __('Outcome','daily-tarot'), 'x' => 0.75, 'y' => 0.6],
                ],
            ],
            'star' => [
                'label' => __('Star Spread','daily-tarot'),
                'description' => __('A 6-card star layout.','daily-tarot'),
                'slots' => [
                    ['label' => __('Issue','daily-tarot'), 'x' => 0.25, 'y' => 0.5],
                    ['label' => __('Hope','daily-tarot'), 'x' => 0.5, 'y' => 0.2],
                    ['label' => __('Guidance','daily-tarot'), 'x' => 0.5, 'y' => 0.5],
                    ['label' => __('Action','daily-tarot'), 'x' => 0.75, 'y' => 0.5],
                    ['label' => __('Support','daily-tarot'), 'x' => 0.35, 'y' => 0.75],
                    ['label' => __('Outcome','daily-tarot'), 'x' => 0.65, 'y' => 0.75],
                ],
            ],
            'astrological' => [
                'label' => __('Astrological Spread','daily-tarot'),
                'description' => __('A 12-house astrological wheel.','daily-tarot'),
                'slots' => [
                    ['label' => __('1st House','daily-tarot'), 'x' => 0.5, 'y' => 0.15],
                    ['label' => __('2nd House','daily-tarot'), 'x' => 0.65, 'y' => 0.2],
                    ['label' => __('3rd House','daily-tarot'), 'x' => 0.8, 'y' => 0.3],
                    ['label' => __('4th House','daily-tarot'), 'x' => 0.9, 'y' => 0.45],
                    ['label' => __('5th House','daily-tarot'), 'x' => 0.8, 'y' => 0.6],
                    ['label' => __('6th House','daily-tarot'), 'x' => 0.65, 'y' => 0.7],
                    ['label' => __('7th House','daily-tarot'), 'x' => 0.5, 'y' => 0.75],
                    ['label' => __('8th House','daily-tarot'), 'x' => 0.35, 'y' => 0.7],
                    ['label' => __('9th House','daily-tarot'), 'x' => 0.2, 'y' => 0.6],
                    ['label' => __('10th House','daily-tarot'), 'x' => 0.1, 'y' => 0.45],
                    ['label' => __('11th House','daily-tarot'), 'x' => 0.2, 'y' => 0.3],
                    ['label' => __('12th House','daily-tarot'), 'x' => 0.35, 'y' => 0.2],
                ],
            ],
            'tree_of_life' => [
                'label' => __('Tree of Life Spread','daily-tarot'),
                'description' => __('A 10-card Tree of Life layout.','daily-tarot'),
                'slots' => [
                    ['label' => __('Kether','daily-tarot'), 'x' => 0.5, 'y' => 0.1],
                    ['label' => __('Chokhmah','daily-tarot'), 'x' => 0.3, 'y' => 0.2],
                    ['label' => __('Binah','daily-tarot'), 'x' => 0.7, 'y' => 0.2],
                    ['label' => __('Chesed','daily-tarot'), 'x' => 0.3, 'y' => 0.4],
                    ['label' => __('Geburah','daily-tarot'), 'x' => 0.7, 'y' => 0.4],
                    ['label' => __('Tiphareth','daily-tarot'), 'x' => 0.5, 'y' => 0.35],
                    ['label' => __('Netzach','daily-tarot'), 'x' => 0.3, 'y' => 0.6],
                    ['label' => __('Hod','daily-tarot'), 'x' => 0.7, 'y' => 0.6],
                    ['label' => __('Yesod','daily-tarot'), 'x' => 0.5, 'y' => 0.65],
                    ['label' => __('Malkuth','daily-tarot'), 'x' => 0.5, 'y' => 0.8],
                ],
            ],
            'seven_card_fan' => [
                'label' => __('Seven Card Fan','daily-tarot'),
                'description' => __('A fan-shaped 7-card spread.','daily-tarot'),
                'slots' => [
                    ['label' => __('Past','daily-tarot'), 'x' => 0.1, 'y' => 0.7],
                    ['label' => __('Present','daily-tarot'), 'x' => 0.25, 'y' => 0.6],
                    ['label' => __('Hidden Influences','daily-tarot'), 'x' => 0.4, 'y' => 0.5],
                    ['label' => __('Advice','daily-tarot'), 'x' => 0.6, 'y' => 0.5],
                    ['label' => __('External Factors','daily-tarot'), 'x' => 0.75, 'y' => 0.6],
                    ['label' => __('Hopes & Fears','daily-tarot'), 'x' => 0.9, 'y' => 0.7],
                    ['label' => __('Outcome','daily-tarot'), 'x' => 0.5, 'y' => 0.85],
                ],
            ],
        ];
    }

    /**
     * @return array{label:string,description:string,slots:array<int,array{label:string}>}|null
     */
    public static function get(string $id): ?array {
        $id = sanitize_key($id);
        $all = self::all();
        return isset($all[$id]) ? $all[$id] : null;
    }

    /**
     * @return array<int,string>
     */
    public static function ids(): array {
        return array_keys(self::all());
    }
}
