<?php
declare(strict_types=1);


namespace DailyTarot\Support;
if (!defined('ABSPATH')) { exit; }


final class SpreadMappings {

    private const OPT = 'dtarot_spread_instances_v1';

    /**
     * @return array<int,array<int,array<string,mixed>>>
     */
    public static function all(): array {
        $raw = get_option(self::OPT, []);
        return is_array($raw) ? $raw : [];
    }

    /**
     * @return array<int,array<string,mixed>>
     */
    public static function forPost(int $postId): array {
        $all = self::all();
        $key = (int)$postId;
        return isset($all[$key]) && is_array($all[$key]) ? $all[$key] : [];
    }

    public static function setMapping(int $postId, int $index, array $data): void {
        if ($postId <= 0 || $index < 0) return;
        $all = self::all();
        $key = (int)$postId;
        if (!isset($all[$key]) || !is_array($all[$key])) $all[$key] = [];

        $preset = isset($data['preset']) ? sanitize_key((string)$data['preset']) : '';
        $pack = isset($data['pack']) ? sanitize_key((string)$data['pack']) : '';
        $deckId = isset($data['deck_id']) ? (int)$data['deck_id'] : 0;

        $all[$key][$index] = [
            'preset' => $preset,
            'pack' => $pack,
            'deck_id' => $deckId,
        ];

        update_option(self::OPT, $all, false);
        if (function_exists('wp_cache_delete')) {
            wp_cache_delete(self::OPT, 'options');
            wp_cache_delete('alloptions', 'options');
        }
    }
}
