<?php
declare(strict_types=1);


namespace DailyTarot\Support;
if (!defined('ABSPATH')) { exit; }


final class ProUrls {

    public static function buyProUrl(): string {
        if (function_exists('dtarot_fs')) {
            $fs = dtarot_fs();
            if (is_object($fs)) {
                if (method_exists($fs, 'get_upgrade_url')) {
                    $url = (string)$fs->get_upgrade_url();
                    if ($url !== '') return $url;
                }
                if (method_exists($fs, 'get_pricing_url')) {
                    $url = (string)$fs->get_pricing_url();
                    if ($url !== '') return $url;
                }
            }
        }

        $url = apply_filters('dtarot_pro_buy_url', '');
        $url = is_string($url) ? trim($url) : '';
        return $url;
    }

    public static function settingsProUrl(): string {
        return (string)admin_url('admin.php?page=daily-tarot-settings&tab=pro');
    }

    public static function accountUrl(): string {
        if (class_exists(License::class) && !License::isPro()) {
            return '';
        }
        if (function_exists('dtarot_fs')) {
            $fs = dtarot_fs();
            if (is_object($fs) && method_exists($fs, 'get_account_url')) {
                $url = (string)$fs->get_account_url();
                if ($url !== '') return $url;
            }
        }
        return '';
    }
}
