<?php
declare(strict_types=1);


namespace DailyTarot\Support;
if (!defined('ABSPATH')) { exit; }


use DailyTarot\Calendar\DayEntry;

final class PlanLimits {

    /**
     * Free plan: editing is allowed up to and including tomorrow.
     * Pro: edit any date.
     */
    public static function calendarAllowedFreeEditDate(): string {
        $tz = function_exists('wp_timezone') ? wp_timezone() : new \DateTimeZone('UTC');
        $today = new \DateTimeImmutable('now', $tz);

        return $today->modify('+1 day')->format('Y-m-d');
    }

    /**
     * Back-compat alias: older callers use calendarMaxEditableDate().
     */
    public static function calendarMaxEditableDate(): string {
        return self::calendarAllowedFreeEditDate();
    }

    public static function canEditCalendarDate(string $date): bool {
        $date = DayEntry::normalizeDate($date);
        if ($date === '') return false;

        $isPro = class_exists(FeatureFlags::class) && FeatureFlags::enabled('pro');
        if ($isPro) return true;

        $max = self::calendarAllowedFreeEditDate();
        if ($max === '') return false;

        // Lexicographic compare works for YYYY-MM-DD.
        return $date <= $max;
    }
}
