<?php
declare(strict_types=1);


namespace DailyTarot\Support;
if (!defined('ABSPATH')) { exit; }

use DailyTarot\Support\PostTypes;


final class DefaultReadingTypes {

    public static function ensureExists(): void {
        $existing = get_posts([
            'post_type' => PostTypes::readingTypeTypes(),
            'numberposts' => 1,
            'post_status' => ['publish','draft','pending','private'],
            'fields' => 'ids',
        ]);
        if (is_array($existing) && !empty($existing)) {
            return;
        }

        $defaults = [
            [
                'title' => __('Quick 3-Card','daily-tarot'),
                'desc' => __('A focused, short reading for clarity and direction.','daily-tarot'),
                'duration' => 15,
            ],
            [
                'title' => __('Standard Reading','daily-tarot'),
                'desc' => __('A balanced reading with space to explore the theme.','daily-tarot'),
                'duration' => 30,
            ],
            [
                'title' => __('Deep Oracle','daily-tarot'),
                'desc' => __('A longer session for deep insight and layered guidance.','daily-tarot'),
                'duration' => 60,
            ],
        ];

        foreach ($defaults as $row) {
            $postId = wp_insert_post([
                'post_type' => PostTypes::READING_TYPE,
                'post_status' => 'publish',
                'post_title' => (string)$row['title'],
                'post_content' => (string)$row['desc'],
            ]);
            if (!$postId || is_wp_error($postId)) {
                continue;
            }

            $duration = isset($row['duration']) ? (int)$row['duration'] : 30;
            if ($duration <= 0) $duration = 30;
            update_post_meta($postId, '_dtarot_reading_duration', $duration);
        }
    }
}
