<?php
declare(strict_types=1);

namespace DailyTarot\Support;
if (!defined('ABSPATH')) { exit; }

final class CacheVersion {

    private const OPT = 'dtarot_cache_ver';

    public static function get(): int {
        $v = (int)get_option(self::OPT, 1);
        return max(1, $v);
    }

    public static function bump(): void {
        $v = self::get();
        update_option(self::OPT, $v + 1, false);
    }

    public static function dayLastModifiedKey(string $date): string {
        return 'dtarot_day_lastmod_' . $date;
    }

    public static function setDayLastModified(string $date, int $unixTs = 0): void {
        $date = trim($date);
        if ($date === '') return;
        if ($unixTs <= 0) {
            $unixTs = (int)current_time('timestamp');
        }
        update_option(self::dayLastModifiedKey($date), $unixTs, false);
    }

    public static function getDayLastModified(string $date): int {
        $date = trim($date);
        if ($date === '') return 0;
        return (int)get_option(self::dayLastModifiedKey($date), 0);
    }
}
