<?php
declare(strict_types=1);


namespace DailyTarot\Support;
if (!defined('ABSPATH')) { exit; }


final class BookingEmails {

    public static function sendUserRequest(array $booking): void {
        self::sendUserTemplate('user_request_subject', 'user_request_body', $booking);
    }

    public static function sendUserConfirmed(array $booking): void {
        self::sendUserTemplate('user_confirmed_subject', 'user_confirmed_body', $booking);
    }

    public static function sendUserDeclined(array $booking): void {
        self::sendUserTemplate('user_declined_subject', 'user_declined_body', $booking);
    }

    public static function sendAdminNew(array $booking): void {
        $s = BookingSettings::get();
        $adminEmail = isset($s['admin_email']) ? sanitize_email((string)$s['admin_email']) : '';
        if ($adminEmail === '') {
            $adminEmail = (string)get_option('admin_email', '');
        }
        if ($adminEmail === '') return;

        $subject = wp_strip_all_tags(self::tpl('admin_new_subject', $booking));
        $body = self::tpl('admin_new_body', $booking);

        wp_mail($adminEmail, $subject, $body, self::headers());
    }

    private static function sendUserTemplate(string $subjectKey, string $bodyKey, array $booking): void {
        $email = isset($booking['email']) ? sanitize_email((string)$booking['email']) : '';
        if ($email === '') return;

        $subject = wp_strip_all_tags(self::tpl($subjectKey, $booking));
        $body = self::tpl($bodyKey, $booking);

        wp_mail($email, $subject, $body, self::headers());
    }

    private static function tpl(string $key, array $booking): string {
        $s = BookingSettings::get();
        $templates = isset($s['templates']) && is_array($s['templates']) ? $s['templates'] : [];
        $raw = isset($templates[$key]) ? (string)$templates[$key] : '';

        $site = (string)get_bloginfo('name');
        $repl = [
            '{site}' => $site,
            '{name}' => (string)($booking['name'] ?? ''),
            '{email}' => (string)($booking['email'] ?? ''),
            '{reading}' => (string)($booking['reading'] ?? ''),
            '{date}' => (string)($booking['date'] ?? ''),
            '{time}' => (string)($booking['time'] ?? ''),
            '{timezone}' => (string)($booking['timezone'] ?? ''),
            '{status}' => (string)($booking['status'] ?? ''),
            '{question}' => (string)($booking['question'] ?? ''),
            '{message}' => (string)($booking['message'] ?? ''),
            '{admin_date}' => (string)($booking['admin_date'] ?? ''),
            '{admin_time}' => (string)($booking['admin_time'] ?? ''),
            '{admin_timezone}' => (string)($booking['admin_timezone'] ?? ''),
        ];

        return strtr($raw, $repl);
    }

    public static function headers(): array {
        $s = BookingSettings::get();
        $fromName = isset($s['from_name']) ? trim((string)$s['from_name']) : '';
        $fromEmail = isset($s['from_email']) ? trim((string)$s['from_email']) : '';
        $headers = [];
        if ($fromEmail !== '') {
            $name = $fromName !== '' ? $fromName : (string)get_bloginfo('name');
            $headers[] = 'From: ' . $name . ' <' . $fromEmail . '>';
        }
        return $headers;
    }
}
