<?php
declare(strict_types=1);


namespace DailyTarot\Packs;
if (!defined('ABSPATH')) { exit; }


final class PackVersion {

    public const META_KEY = '_dtarot_pack_version';

    public static function sanitize(string $version): string {
        $version = trim($version);
        if ($version === '') return '';

        // SemVer-ish: keep it permissive but safe.
        $version = preg_replace('/[^0-9A-Za-z\.\-\+]/', '', $version);
        $version = is_string($version) ? $version : '';
        $version = trim($version, ".-+ ");

        if ($version === '') return '';
        if (strlen($version) > 32) {
            $version = substr($version, 0, 32);
        }
        return $version;
    }
}
