<?php
declare(strict_types=1);


namespace DailyTarot\Packs;
if (!defined('ABSPATH')) { exit; }


final class ManifestValidator {

    /**
     * Validates only the common top-level fields used for gating import.
     *
     * @return string empty string when ok, otherwise an error code used by Settings notices.
     */
    public static function validateCommon(array $manifest, int $expectedFormatVersion, string $pluginVersion): string {
        $v = isset($manifest['format_version']) ? (int)$manifest['format_version'] : 0;
        if ($v !== $expectedFormatVersion) {
            return 'format_version';
        }

        $min = isset($manifest['plugin_min_version']) && is_string($manifest['plugin_min_version'])
            ? trim($manifest['plugin_min_version'])
            : '';

        if ($min !== '' && $pluginVersion !== '') {
            if (version_compare($pluginVersion, $min, '<')) {
                return 'min_version';
            }
        }

        return '';
    }
}
