<?php
declare(strict_types=1);


namespace DailyTarot\Calendar;
if (!defined('ABSPATH')) { exit; }
// phpcs:disable WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter



final class DayEntryTable {

    public const SCHEMA_VERSION = 2;

    public static function name(): string {
        global $wpdb;
        if (!isset($wpdb) || !is_object($wpdb) || !property_exists($wpdb, 'prefix')) {
            return '';
        }
        /** @var string $prefix */
        $prefix = (string)$wpdb->prefix;
        return $prefix . 'dtarot_day_entries';
    }

    public static function exists(): bool {
        global $wpdb;
        $table = self::name();
        if ($table === '' || !preg_match('/^[A-Za-z0-9_]+$/', $table) || !isset($wpdb) || !is_object($wpdb)) return false;

        $like = $table;
        $sql = $wpdb->prepare('SHOW TABLES LIKE %s', $like);
        $found = $wpdb->get_var($sql);
        return is_string($found) && $found === $table;
    }

    public static function countRows(): int {
        global $wpdb;
        $table = self::name();
        if ($table === '' || !preg_match('/^[A-Za-z0-9_]+$/', $table) || !self::exists() || !isset($wpdb) || !is_object($wpdb)) return 0;

        $n = $wpdb->get_var('SELECT COUNT(*) FROM ' . $table);
        return is_numeric($n) ? (int)$n : 0;
    }

    public static function ensureSchema(): void {
        if (!function_exists('add_option') || !function_exists('get_option')) return;

        $table = self::name();
        if ($table === '') return;

        $installed = get_option('dtarot_day_entry_schema', 0);
        $installed = is_numeric($installed) ? (int)$installed : 0;

        if ($installed >= self::SCHEMA_VERSION && self::exists()) {
            return;
        }

        global $wpdb;
        if (!isset($wpdb) || !is_object($wpdb) || !property_exists($wpdb, 'charset')) {
            return;
        }

        $charsetCollate = '';
        if (method_exists($wpdb, 'get_charset_collate')) {
            $charsetCollate = (string)$wpdb->get_charset_collate();
        }

        if (!function_exists('dbDelta')) {
            $upgrade = ABSPATH . 'wp-admin/includes/upgrade.php';
            if (is_readable($upgrade)) {
                require_once $upgrade;
            }
        }
        if (!function_exists('dbDelta')) {
            return;
        }

        $sql = "CREATE TABLE {$table} (
            date date NOT NULL,
            status varchar(20) NOT NULL DEFAULT 'draft',
            deck_id bigint(20) unsigned NOT NULL DEFAULT 0,
            pack_id bigint(20) unsigned NOT NULL DEFAULT 0,
            card_id varchar(100) NOT NULL DEFAULT '',
            content longtext NOT NULL,
            daily_text longtext NOT NULL,
            image_override_attachment_id bigint(20) unsigned NOT NULL DEFAULT 0,
            image_override_url text NOT NULL,
            created_at datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
            updated_at datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
            PRIMARY KEY  (date),
            KEY status_date (status,date),
            KEY deck_date (deck_id,date)
        ) {$charsetCollate};";

        dbDelta($sql);

        if (self::exists()) {
            update_option('dtarot_day_entry_schema', self::SCHEMA_VERSION, false);
        }
    }
}
